/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.dateAndTime;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.TimePickerPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class WorkScheduleOptionsPanel
extends AbstractOptionPanel {
    private HashMap<Integer, CurrentCheckBox> mapCheckButtons;
    private TimePickerPanel pnlTimePicker;
    private JComboBox cmbTimeZone;
    private JButton btnSetAllwaysAvailable;
    private static final Logger logger = Logger.getLogger(WorkScheduleOptionsPanel.class);

    public WorkScheduleOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
    }

    private void init() {
        this.mapCheckButtons = new HashMap();
        this.mapCheckButtons.put(1, new CurrentCheckBox(StringResources.SUNDAY));
        this.mapCheckButtons.put(2, new CurrentCheckBox(StringResources.MONDAY));
        this.mapCheckButtons.put(4, new CurrentCheckBox(StringResources.TUESDAY));
        this.mapCheckButtons.put(8, new CurrentCheckBox(StringResources.WEDNESDAY));
        this.mapCheckButtons.put(16, new CurrentCheckBox(StringResources.THURSDAY));
        this.mapCheckButtons.put(32, new CurrentCheckBox(StringResources.FRIDAY));
        this.mapCheckButtons.put(64, new CurrentCheckBox(StringResources.SATURDAY));
        this.cmbTimeZone = new OrientableComboBox(OptionManager.getInstance().getDateTimeOptions().getTimeZoneOptions().getTimeZoneNames());
        this.cmbTimeZone.addItemListener(this.itemListener);
        this.pnlTimePicker = new TimePickerPanel(this.changesListener, this.controller);
        this.btnSetAllwaysAvailable = new OrientableButton(new SetAllwaysAvailableAction());
        this.btnSetAllwaysAvailable.addItemListener(this.itemListener);
    }

    protected void build() {
        this.init();
        this.buildUI();
    }

    public void collectValues() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        int mask = 0;
        int m = 1;
        for (int i = 0; i < 7; ++i) {
            if (this.mapCheckButtons.get(m).isSelected()) {
                mask += m;
            }
            m *= 2;
        }
        dataStoreSettings.setCalendarWorkDays(mask);
        dataStoreSettings.setCalendarWorkDayStartTime(this.pnlTimePicker.getStartTime());
        dataStoreSettings.setCalendarWorkDayEndTime(this.pnlTimePicker.getEndTime());
    }

    public void fireOptionsChanged() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        int mask = (Integer)dataStoreSettings.getCalendarWorkDays().getValue();
        boolean isLocked = dataStoreSettings.getCalendarWorkDays().isLocked();
        int m = 64;
        for (int i = 0; i < 7; ++i) {
            if (mask / m == 1) {
                this.mapCheckButtons.get(m).setSelected(true);
                this.mapCheckButtons.get(m).setEnabled(!isLocked);
                mask -= m;
            }
            m /= 2;
        }
        long time = System.currentTimeMillis();
        this.pnlTimePicker.setStartTime((Integer)dataStoreSettings.getCalendarWorkDayStartTime().getValue());
        this.pnlTimePicker.setEndTime((Integer)dataStoreSettings.getCalendarWorkDayEndTime().getValue());
        this.pnlTimePicker.setEnabled(!dataStoreSettings.getCalendarWorkDayStartTime().isLocked());
        time = System.currentTimeMillis() - time;
        logger.debug((Object)("time: " + time));
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    private void setAllwaysAvailable() {
        for (int i = 1; i < 65; i *= 2) {
            this.mapCheckButtons.get(i).setSelected(true);
        }
        this.pnlTimePicker.setEndTime(0);
        this.pnlTimePicker.setStartTime(0);
    }

    private void buildUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)new OrientableLabel(StringResources.YOUR_WORK_SCHEDULE_SHOWS_OTHERS_WHEN_YOU_ARE_AVAILABLE_), constraints);
        ++constraints.gridy;
        constraints.insets.top = 20;
        this.add((Component)this.createTimePickerPanel(), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.insets.top = 20;
        this.add((Component)this.btnSetAllwaysAvailable, constraints);
    }

    private JPanel createTimePickerPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)new OrientableLabel(StringResources.START_TIME_C), constraints);
        ++constraints.gridy;
        constraints.insets.top = 2;
        panel.add((Component)new OrientableLabel(StringResources.END_TIME_C), constraints);
        constraints.gridy = 0;
        ++constraints.gridx;
        constraints.gridheight = 2;
        constraints.insets.top = 10;
        panel.add((Component)this.pnlTimePicker, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridheight = 1;
        constraints.insets.top = 10;
        panel.add((Component)new OrientableLabel(StringResources.WORK_DAYS_C), constraints);
        constraints.insets.top = 10;
        ++constraints.gridx;
        for (int i = 2; i < 33; i *= 2) {
            panel.add((Component)this.mapCheckButtons.get(i), constraints);
            ++constraints.gridy;
            constraints.insets.top = 0;
        }
        constraints.insets.top = 10;
        panel.add((Component)this.mapCheckButtons.get(64), constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        panel.add((Component)this.mapCheckButtons.get(1), constraints);
        return panel;
    }

    private class CurrentCheckBox
    extends OrientableCheckBox {
        public CurrentCheckBox(String name) {
            super(name);
            this.addItemListener(WorkScheduleOptionsPanel.this.itemListener);
        }
    }

    private class SetAllwaysAvailableAction
    extends AbstractAction {
        public SetAllwaysAvailableAction() {
            super(StringResources.SET_ALWAYS_AVAILABLE);
        }

        public void actionPerformed(ActionEvent e) {
            WorkScheduleOptionsPanel.this.setAllwaysAvailable();
        }
    }
}

