/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class CleanupOptionPane
extends AbstractOptionPanel {
    private AbstractButton rbManualDeleteMail = new OrientableRadioButton(StringResources.MANUAL_DELETE_AND_ARCHIVE);
    private AbstractButton rbManualDeleteAppointment = new OrientableRadioButton(StringResources.MANUAL_DELETE_AND_ARCHIVE);
    private AbstractButton rbAutoDeleteMail = new OrientableRadioButton(StringResources.AUTO_DELETE_AFTER_C);
    private AbstractButton rbAutoDeleteAppointment = new OrientableRadioButton(StringResources.AUTO_DELETE_AFTER_C);
    private AbstractButton rbAutoArchiveMail = new OrientableRadioButton(StringResources.AUTO_ARCHIVE_AFTER_C);
    private AbstractButton rbAutoArchiveAppointment = new OrientableRadioButton(StringResources.AUTO_ARCHIVE_AFTER_C);
    private AbstractButton rbManualEmptyTrash = new OrientableRadioButton(StringResources.MANUAL);
    private AbstractButton rbAutoDeleteTrash = new OrientableRadioButton(StringResources.AUTO_DELETE_AFTER_C);
    private CleanupSpinner spMailDays = new CleanupSpinner();
    private CleanupSpinner spAppointmentDays = new CleanupSpinner();
    private CleanupSpinner spTrashDays = new CleanupSpinner();
    private String userGuid;

    public CleanupOptionPane(OptionChangesListener theChangesListener, MVCController theParentController, String userGuid) {
        super(theChangesListener, theParentController);
        this.userGuid = userGuid;
        this.setName(StringResources.CLEANUP);
    }

    private void registerListeners() {
        this.rbManualDeleteMail.addItemListener(this.itemListener);
        this.rbManualDeleteAppointment.addItemListener(this.itemListener);
        this.rbAutoDeleteMail.addItemListener(this.itemListener);
        this.rbAutoDeleteAppointment.addItemListener(this.itemListener);
        this.rbAutoArchiveMail.addItemListener(this.itemListener);
        this.rbAutoArchiveAppointment.addItemListener(this.itemListener);
        this.rbManualEmptyTrash.addItemListener(this.itemListener);
        this.rbAutoDeleteTrash.addItemListener(this.itemListener);
        this.spMailDays.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.spAppointmentDays.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.spTrashDays.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
    }

    public void collectValues() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(this.userGuid).getDataStoreSettings();
        Integer mailAndPhone = new Integer(CleanupOptionPane.getCleanupOption(this.rbManualDeleteMail, this.rbAutoDeleteMail, this.rbAutoArchiveMail));
        Integer callItem = new Integer(CleanupOptionPane.getCleanupOption(this.rbManualDeleteAppointment, this.rbAutoDeleteAppointment, this.rbAutoArchiveAppointment));
        Integer trash = new Integer(CleanupOptionPane.getCleanupOption(this.rbManualEmptyTrash, this.rbAutoDeleteTrash, null));
        Integer mailAndPhoneDays = (Integer)this.spMailDays.getValue();
        Integer callItemDays = (Integer)this.spAppointmentDays.getValue();
        Integer trashDays = (Integer)this.spTrashDays.getValue();
        dataStoreSettings.setCleanupOptions(mailAndPhone, mailAndPhoneDays, callItem, callItemDays, trash, trashDays);
    }

    private static int getCleanupOption(AbstractButton button1, AbstractButton button2, AbstractButton button3) {
        if (button1.isSelected()) {
            return 0;
        }
        if (button2.isSelected()) {
            if (button3 == null) {
                return 1;
            }
            return 1;
        }
        if (button3 != null && button3.isSelected()) {
            return 2;
        }
        return -1;
    }

    public void fireOptionsChanged() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(this.userGuid).getDataStoreSettings();
        DataStoreSettings.CleanupOptions cleanupOption = dataStoreSettings.getCleanupOption();
        CleanupOptionPane.selectButtons(cleanupOption.getMailAndPhone(), this.rbManualDeleteMail, this.rbAutoDeleteMail, this.rbAutoArchiveMail);
        CleanupOptionPane.selectButtons(cleanupOption.getCalItem(), this.rbManualDeleteAppointment, this.rbAutoDeleteAppointment, this.rbAutoArchiveAppointment);
        CleanupOptionPane.selectButtons(cleanupOption.getTrash(), this.rbManualEmptyTrash, this.rbAutoDeleteTrash, null);
        this.spMailDays.setValue(new Integer(cleanupOption.getMailAndPhoneDays()));
        this.spAppointmentDays.setValue(new Integer(cleanupOption.getCalItemDays()));
        this.spTrashDays.setValue(new Integer(cleanupOption.getTrashDays()));
        this.spMailDays.setLocked(cleanupOption.isMailAndPhoneDaysLocked());
        this.spAppointmentDays.setLocked(cleanupOption.isCalItemDaysLocked());
        this.spTrashDays.setLocked(cleanupOption.isTrashDaysLocked());
        if (cleanupOption.isMailAndPhoneLocked()) {
            CleanupOptionPane.lockButtons(this.rbManualDeleteMail, this.rbAutoDeleteMail, this.rbAutoArchiveMail);
        }
        if (cleanupOption.isCalItemLocked()) {
            CleanupOptionPane.lockButtons(this.rbManualDeleteAppointment, this.rbAutoDeleteAppointment, this.rbAutoArchiveAppointment);
        }
        if (cleanupOption.isTrashLocked()) {
            CleanupOptionPane.lockButtons(this.rbManualEmptyTrash, this.rbAutoDeleteTrash, null);
        }
    }

    private static void lockButtons(AbstractButton button1, AbstractButton button2, AbstractButton button3) {
        button1.setEnabled(false);
        button2.setEnabled(false);
        if (button3 != null) {
            button3.setEnabled(false);
        }
    }

    private static void selectButtons(int cleanupOption, AbstractButton button1, AbstractButton button2, AbstractButton button3) {
        switch (cleanupOption) {
            case 0: {
                button1.setSelected(true);
                break;
            }
            case 1: {
                button2.setSelected(true);
                break;
            }
            case 2: {
                if (button3 == null) break;
                button3.setSelected(true);
            }
        }
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    protected void build() {
        this.registerListeners();
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel pnlMail = CleanupOptionPane.buildPane(StringResources.MAIL_AND_PHONE, this.rbManualDeleteMail, this.rbAutoDeleteMail, this.rbAutoArchiveMail, this.spMailDays);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets.bottom = 10;
        constraints.fill = 2;
        constraints.anchor = 23;
        this.add((Component)pnlMail, constraints);
        pnlMail = CleanupOptionPane.buildPane(StringResources.APPOINTMENT_TASK_AND_REMINDER_NOTE, this.rbManualDeleteAppointment, this.rbAutoDeleteAppointment, this.rbAutoArchiveAppointment, this.spAppointmentDays);
        constraints.gridy = 1;
        this.add((Component)pnlMail, constraints);
        pnlMail = CleanupOptionPane.buildPane(StringResources.EMPTY_TRASH, this.rbManualEmptyTrash, this.rbAutoDeleteTrash, null, this.spTrashDays);
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        this.add((Component)pnlMail, constraints);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private static JPanel buildPane(String title, AbstractButton button1, AbstractButton button2, AbstractButton button3, final JSpinner spinner) {
        OrientablePanel pnlMail = new OrientablePanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(title);
        pnlMail.setBorder(titledBorder);
        final OrientableLabel lbDays = new OrientableLabel(StringResources.DAYS_L);
        spinner.setModel(new SpinnerNumberModel(1, 1, 9999, 1));
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(button1);
        buttonGroup.add(button2);
        buttonGroup.add(button3);
        button1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                spinner.setEnabled(e.getStateChange() == 2);
                lbDays.setEnabled(e.getStateChange() == 2);
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets.right = 5;
        constraints.insets.bottom = 5;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        constraints.anchor = 21;
        pnlMail.add((Component)button1, constraints);
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.insets.bottom = 0;
        if (button3 == null) {
            constraints.insets.bottom = 10;
        }
        pnlMail.add((Component)button2, constraints);
        constraints.gridy = 1;
        constraints.gridx = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        pnlMail.add((Component)spinner, constraints);
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        pnlMail.add((Component)lbDays, constraints);
        if (button3 != null) {
            constraints.gridy = 2;
            constraints.gridx = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.insets.top = 5;
            constraints.insets.bottom = 10;
            pnlMail.add((Component)button3, constraints);
        }
        return pnlMail;
    }

    private static class CleanupSpinner
    extends OrientableSpinner {
        private boolean isLocked = false;

        public void setLocked(boolean locked) {
            this.isLocked = locked;
            if (locked) {
                this.setEnabled(false);
            }
        }

        public void setEnabled(boolean enabled) {
            if (!this.isLocked) {
                super.setEnabled(enabled);
            }
        }
    }
}

