/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.mvc.MVCController;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.SettingsValue;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class DefaultActionsOptionPane
extends AbstractOptionPanel {
    Logger logger = Logger.getLogger(DefaultActionsOptionPane.class);
    private JRadioButton rbMailBoxFolder = new OrientableRadioButton(StringResources.MAILBOX_FOLDER);
    private JRadioButton rbHomeFolder = new OrientableRadioButton(StringResources.HOME_FOLDER);
    private JRadioButton rbAlwaysShowWarning = new OrientableRadioButton(StringResources.ALWAYS_SHOW_WARNING);
    private JRadioButton rbNeverShowWarning = new OrientableRadioButton(StringResources.NEVER_SHOW_WARNING);
    private JRadioButton rbCheckFrequentContacts = new OrientableRadioButton(StringResources.CHECK_FREQUENT_CONTACTS);
    private JRadioButton rbCreateDiscussionNote = new OrientableRadioButton(StringResources.CREATE_DISCUSSION_NOTE);
    private JRadioButton rbCreateTask = new OrientableRadioButton(StringResources.CREATE_TASK);
    private JSpinner spnFileSize = new OrientableSpinner(new SpinnerNumberModel(100, 100, 30000, 100));
    private JCheckBox cbWarnIfLarger = new JMnemonicCheckBox(StringResources.WARN_IF_LARGER_THAN_C);

    public DefaultActionsOptionPane(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        this.setName(StringResources.DEFAULT_ACTIONS);
        this.init();
    }

    private void init() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbCreateDiscussionNote);
        buttonGroup.add(this.rbCreateTask);
    }

    private void registerListeners() {
        this.rbMailBoxFolder.addItemListener(this.itemListener);
        this.rbHomeFolder.addItemListener(this.itemListener);
        this.cbWarnIfLarger.addItemListener(this.itemListener);
        this.cbWarnIfLarger.setSelected(true);
        this.spnFileSize.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.rbAlwaysShowWarning.addItemListener(this.itemListener);
        this.rbNeverShowWarning.addItemListener(this.itemListener);
        this.rbCheckFrequentContacts.addItemListener(this.itemListener);
        this.rbCreateDiscussionNote.addItemListener(this.itemListener);
        this.rbCreateTask.addItemListener(this.itemListener);
        this.spnFileSize.addChangeListener(this.changeListener);
        this.cbWarnIfLarger.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DefaultActionsOptionPane.this.spnFileSize.setEnabled(DefaultActionsOptionPane.this.cbWarnIfLarger.isSelected());
            }
        });
    }

    protected void build() {
        this.registerListeners();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbMailBoxFolder);
        group.add(this.rbHomeFolder);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 10, 5, 10);
        panel.add((Component)new OrientableLabel(StringResources.START_IN_C), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)this.rbMailBoxFolder, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 10, 10);
        panel.add((Component)this.rbHomeFolder, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)panel, constraints);
        panel = new OrientablePanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 10, 5, 10);
        panel.add((Component)new JSeparator(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)new OrientableLabel(StringResources.FILE_ATTACHMENTS_C), constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)this.cbWarnIfLarger, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 30, 10, 5);
        panel.add((Component)this.spnFileSize, constraints);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 10, 10);
        panel.add((Component)new OrientableLabel(StringResources.KB), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)panel, constraints);
        panel = new OrientablePanel(new GridBagLayout());
        group = new ButtonGroup();
        group.add(this.rbAlwaysShowWarning);
        group.add(this.rbNeverShowWarning);
        group.add(this.rbCheckFrequentContacts);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 10, 5, 10);
        panel.add((Component)new JSeparator(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)new OrientableLabel(StringResources.HTML_EXTERNAL_IMAGES_C), constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)this.rbAlwaysShowWarning, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)this.rbNeverShowWarning, constraints);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)this.rbCheckFrequentContacts, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)panel, constraints);
        panel = new OrientablePanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 10, 5, 10);
        panel.add((Component)new JSeparator(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)new OrientableLabel(StringResources.NEW_TASKLIST_ITEM_C), constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)this.rbCreateDiscussionNote, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)this.rbCreateTask, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)panel, constraints);
        panel = new OrientablePanel(new GridBagLayout());
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)panel, constraints);
    }

    public void collectValues() {
        String userGuid = ControlsUtils.getUserGuid(this.controller);
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        try {
            GWCommandManager commandManager = GWCommandManager.getInstance(userGuid);
            if (this.rbHomeFolder.isSelected()) {
                accountSettings.setStartupFolder(commandManager.getRootFolder().getNativeFolder().getNativeFolder());
            } else {
                accountSettings.setStartupFolder(commandManager.getMailboxFolder().getNativeFolder().getNativeFolder());
            }
        }
        catch (GWCommandException e) {
            this.logger.warn((Object)e);
        }
        if (this.cbWarnIfLarger.isSelected()) {
            accountSettings.setAttachmentSizeWarningThreshold((Integer)this.spnFileSize.getValue() * 1024);
        } else {
            accountSettings.setAttachmentSizeWarningThreshold(-1);
        }
        if (this.rbAlwaysShowWarning.isSelected()) {
            accountSettings.setCheckHTMLExternalImages(0);
        } else if (this.rbCheckFrequentContacts.isSelected()) {
            accountSettings.setCheckHTMLExternalImages(1);
        } else if (this.rbNeverShowWarning.isSelected()) {
            accountSettings.setCheckHTMLExternalImages(3);
        }
        DataStoreSettings dataStoreSettings = EngineCommandManager.getInstance(userGuid).getDataStoreSettings();
        dataStoreSettings.setNewTasklistItemType(this.rbCreateTask.isSelected() ? 4 : 1);
    }

    public void fireOptionsChanged() {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        IFolder folder = APIFolderWrapperManager.getFolder(accountSettings.getStartupFolder());
        if (folder == null || folder.getType() == FolderType.UNIVERSAL) {
            this.rbMailBoxFolder.setSelected(true);
        } else if (folder.getType() == FolderType.USER) {
            this.rbHomeFolder.setSelected(true);
        }
        if (accountSettings.getAttachmentSizeWarningThreshold() == -1) {
            this.cbWarnIfLarger.setSelected(false);
        } else {
            this.spnFileSize.getModel().setValue(accountSettings.getAttachmentSizeWarningThreshold() / 1024);
        }
        int value = accountSettings.getCheckHTMLExternalImages();
        if (value == 0) {
            this.rbAlwaysShowWarning.setSelected(true);
        } else if (value == 1) {
            this.rbCheckFrequentContacts.setSelected(true);
        } else if (value == 3) {
            this.rbNeverShowWarning.setSelected(true);
        }
        String userGuid = ControlsUtils.getUserGuid(this.controller);
        DataStoreSettings dataStoreSettings = EngineCommandManager.getInstance(userGuid).getDataStoreSettings();
        SettingsValue settingsValue = dataStoreSettings.getNewTasklistItemType();
        Integer itemType = (Integer)settingsValue.getValue();
        this.rbCreateTask.setSelected(4 == itemType);
        boolean locked = settingsValue.isLocked();
        this.rbCreateTask.setEnabled(!locked);
        this.rbCreateDiscussionNote.setSelected(1 == itemType);
        this.rbCreateDiscussionNote.setEnabled(!locked);
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }
}

