/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.listener.ListenerType;
import com.appframework.mvc.MVCController;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextArea;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColorChooserButton;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ReplyFormatOptionPane
extends AbstractOptionPanel {
    Logger logger = Logger.getLogger(ReplyFormatOptionPane.class);
    private static final String SEPARATOR = ">>>";
    private AbstractButton rbPlainGWClassic = new OrientableRadioButton(StringResources.GROUPWISE_CLASSIC);
    private AbstractButton rbIncludeHeaders = new OrientableRadioButton(StringResources.INCLUDE_HEADERS);
    private AbstractButton rbInternetStandard = new OrientableRadioButton(StringResources.INTERNET_STANDARD);
    private AbstractButton rbHTMLEnhanced = new OrientableRadioButton(StringResources.HTML_ENHANCED);
    private AbstractButton rbHTMLGWClassic = new OrientableRadioButton(StringResources.GROUPWISE_CLASSIC);
    private AbstractButton rbPlainTextTop = new OrientableRadioButton(StringResources.TOP);
    private AbstractButton rbHTMLTop = new OrientableRadioButton(StringResources.TOP);
    private AbstractButton rbPlainTextBottom = new OrientableRadioButton(StringResources.BOTTOM);
    private AbstractButton rbHTMLBottom = new OrientableRadioButton(StringResources.BOTTOM);
    private JTextField tfSeparator = new GWTextField(">", 2);
    private JCheckBox cbIncludeHeaders = new JMnemonicCheckBox(StringResources.INCLUDE_HEADERS);
    private JCheckBox cbTextColor;
    private JCheckBox cbPlainSeparator = new JMnemonicCheckBox(">>>");
    private JCheckBox cbPlainDate = new JMnemonicCheckBox(StringResources.DATE);
    private JCheckBox cbPlainMessageIdentifier = new JMnemonicCheckBox(StringResources.MESSAGE_IDENTIFIER);
    private JCheckBox cbPlainUserName = new JMnemonicCheckBox(StringResources.USER_NAME);
    private JCheckBox cbPlainEmail = new JMnemonicCheckBox(StringResources.EMAIL_ADDRESS);
    private JCheckBox cbHtmlSeparator = new JMnemonicCheckBox(">>>");
    private JCheckBox cbHtmlDate = new JMnemonicCheckBox(StringResources.DATE);
    private JCheckBox cbHtmlMessageIdentifier = new JMnemonicCheckBox(StringResources.MESSAGE_IDENTIFIER);
    private JCheckBox cbHtmlUserName = new JMnemonicCheckBox(StringResources.USER_NAME);
    private JCheckBox cbHtmlEmail = new JMnemonicCheckBox(StringResources.EMAIL_ADDRESS);
    private JTextArea taPlainSampleText;
    private JTextArea taHtmlSampleText;
    private Boolean showSampleTextForPlainText = true;
    private ColorChooserButton btnColorChooser;

    public ReplyFormatOptionPane(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        this.setName(StringResources.REPLY_FORMAT);
    }

    private void registerListeners() {
        this.rbPlainGWClassic.addItemListener(this.itemListener);
        this.rbPlainTextBottom.addItemListener(this.itemListener);
        this.rbPlainTextTop.addItemListener(this.itemListener);
        this.rbIncludeHeaders.addItemListener(this.itemListener);
        this.rbInternetStandard.addItemListener(this.itemListener);
        this.rbHTMLTop.addItemListener(this.itemListener);
        this.rbHTMLBottom.addItemListener(this.itemListener);
        this.rbHTMLEnhanced.addItemListener(this.itemListener);
        this.rbHTMLGWClassic.addItemListener(this.itemListener);
        this.cbIncludeHeaders.addItemListener(this.itemListener);
        this.tfSeparator.getDocument().addDocumentListener(new AbstractOptionPanel.CustomDocumentListener(this.changesListener));
        this.cbPlainDate.addItemListener(this.itemListener);
        this.cbPlainSeparator.addItemListener(this.itemListener);
        this.cbPlainMessageIdentifier.addItemListener(this.itemListener);
        this.cbPlainUserName.addItemListener(this.itemListener);
        this.cbPlainEmail.addItemListener(this.itemListener);
        this.cbHtmlDate.addItemListener(this.itemListener);
        this.cbHtmlSeparator.addItemListener(this.itemListener);
        this.cbHtmlMessageIdentifier.addItemListener(this.itemListener);
        this.cbHtmlUserName.addItemListener(this.itemListener);
        this.cbHtmlEmail.addItemListener(this.itemListener);
        this.taPlainSampleText = new OrientableTextArea();
        this.taPlainSampleText.setOpaque(false);
        this.taPlainSampleText.setRows(2);
        this.taPlainSampleText.setEditable(false);
        this.taPlainSampleText.setLineWrap(true);
        this.taHtmlSampleText = new OrientableTextArea();
        this.taHtmlSampleText.setOpaque(false);
        this.taHtmlSampleText.setRows(2);
        this.taHtmlSampleText.setEditable(false);
        this.taHtmlSampleText.setLineWrap(true);
        RefreshButtonAction refreshPlainAction = new RefreshButtonAction(true);
        this.rbPlainGWClassic.addItemListener(refreshPlainAction);
        this.rbIncludeHeaders.addItemListener(refreshPlainAction);
        this.rbInternetStandard.addItemListener(refreshPlainAction);
        RefreshButtonAction refreshHTMLAction = new RefreshButtonAction(false);
        this.rbHTMLGWClassic.addItemListener(refreshHTMLAction);
        this.rbHTMLEnhanced.addItemListener(refreshHTMLAction);
        this.cbIncludeHeaders.addItemListener(refreshHTMLAction);
        RefreshTextAction refreshTextAction = new RefreshTextAction();
        this.cbPlainDate.addItemListener(refreshTextAction);
        this.cbPlainEmail.addItemListener(refreshTextAction);
        this.cbPlainMessageIdentifier.addItemListener(refreshTextAction);
        this.cbPlainSeparator.addItemListener(refreshTextAction);
        this.cbPlainUserName.addItemListener(refreshTextAction);
        this.cbHtmlDate.addItemListener(refreshTextAction);
        this.cbHtmlEmail.addItemListener(refreshTextAction);
        this.cbHtmlMessageIdentifier.addItemListener(refreshTextAction);
        this.cbHtmlSeparator.addItemListener(refreshTextAction);
        this.cbHtmlUserName.addItemListener(refreshTextAction);
        this.rbIncludeHeaders.setSelected(true);
        this.cbIncludeHeaders.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (ReplyFormatOptionPane.this.cbIncludeHeaders.isSelected()) {
                    ReplyFormatOptionPane.this.rbHTMLTop.setSelected(true);
                }
            }
        });
        this.btnColorChooser = new ColorChooserButton(Color.RED);
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ReplyFormatOptionPane.this.logger.debug((Object)("-> property: " + evt.getPropertyName()));
                ReplyFormatOptionPane.this.logger.debug((Object)("---> " + evt.getOldValue() + " >>> " + evt.getNewValue()));
                Color color = ReplyFormatOptionPane.this.btnColorChooser.getColor();
                if (color == null && ReplyFormatOptionPane.this.cbTextColor.isSelected()) {
                    ReplyFormatOptionPane.this.cbTextColor.setSelected(false);
                    ReplyFormatOptionPane.this.btnColorChooser.setEnabled(false);
                }
                ReplyFormatOptionPane.this.changesListener.setValueChanged();
            }
        };
        ControlsUtils.getListenerManager(this.controller).addListener(this.btnColorChooser, listener, ListenerType.PROPERTY_CHANGE_LISTENER);
        this.cbTextColor = new OrientableCheckBox(StringResources.TEXT_COLOR_C);
        this.cbTextColor.setSelected(true);
        this.cbTextColor.addItemListener(this.itemListener);
        this.cbTextColor.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = ReplyFormatOptionPane.this.cbTextColor.isSelected();
                if (isSelected || ReplyFormatOptionPane.this.btnColorChooser.getColor() != null) {
                    if (!isSelected) {
                        ReplyFormatOptionPane.this.btnColorChooser.setColor(null);
                        ReplyFormatOptionPane.this.btnColorChooser.setEnabled(false);
                    } else {
                        ReplyFormatOptionPane.this.btnColorChooser.setColor(Color.GRAY);
                        ReplyFormatOptionPane.this.btnColorChooser.setEnabled(true);
                    }
                }
            }
        });
    }

    protected void build() {
        this.registerListeners();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbPlainGWClassic);
        buttonGroup.add(this.rbIncludeHeaders);
        buttonGroup.add(this.rbInternetStandard);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbPlainTextTop);
        buttonGroup.add(this.rbPlainTextBottom);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.buildPlainTextFormatPanel(), constraints);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbHTMLGWClassic);
        buttonGroup.add(this.rbHTMLEnhanced);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbHTMLTop);
        buttonGroup.add(this.rbHTMLBottom);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 24;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.buildHTMLFormatPanel(), constraints);
    }

    private JPanel buildPlainTextFormatPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(StringResources.PLAIN_TEXT_REPLY_FORMAT));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(5, 0, 5, 0);
        panel.add((Component)this.buildPlainTextLeft(), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weighty = 1.0;
        c.fill = 3;
        c.anchor = 23;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)new JSeparator(1), c);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 1;
        c.anchor = 23;
        c.insets = new Insets(5, 0, 5, 0);
        panel.add((Component)this.buildPlainTextRight(), c);
        return panel;
    }

    private JPanel buildHTMLFormatPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(StringResources.HTML_REPLY_FORMAT));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(5, 0, 5, 0);
        panel.add((Component)this.buildHTMLLeft(), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weighty = 1.0;
        c.fill = 3;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)new JSeparator(1), c);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 5, 0);
        panel.add((Component)this.buildHTMLRight(), c);
        return panel;
    }

    private JPanel buildPlainTextLeft() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.addMouseListener(new PanelSelectAction(true));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(10, 10, 5, 10);
        panel.add((Component)this.rbPlainGWClassic, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 10, 5, 20);
        panel.add((Component)this.rbIncludeHeaders, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)this.rbInternetStandard, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 30, 5, 5);
        panel.add((Component)new OrientableLabel(StringResources.SEPARATOR_C), c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 5, 10);
        this.tfSeparator.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.add((Component)this.tfSeparator, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(5, 30, 10, 5);
        panel.add((Component)this.cbTextColor, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(5, 0, 10, 10);
        this.tfSeparator.setBorder(BorderFactory.createLoweredBevelBorder());
        this.btnColorChooser.setMinimumSize(this.btnColorChooser.getPreferredSize());
        panel.add((Component)this.btnColorChooser, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.buildReplyPositionChooserPanel(this.rbPlainTextTop, this.rbPlainTextBottom), c);
        return panel;
    }

    private JPanel buildPlainTextRight() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        OrientablePanel p = new OrientablePanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 5;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(5, 5, 0, 10);
        p.add((Component)new OrientableLabel(StringResources.FIRST_LINE_OF_REPLY_CONTAINS_C), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 5, 0, 0);
        p.add((Component)this.cbPlainSeparator, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 5, 0, 0);
        p.add((Component)this.cbPlainMessageIdentifier, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.insets = new Insets(0, 5, 0, 0);
        p.add((Component)this.cbPlainEmail, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 5, 0, 0);
        p.add((Component)this.cbPlainDate, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 5, 0, 0);
        p.add((Component)this.cbPlainUserName, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)p, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JPanel(), c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 23;
        c.insets = new Insets(0, 10, 0, 10);
        panel.add((Component)this.taPlainSampleText, c);
        return panel;
    }

    private JPanel buildHTMLLeft() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.addMouseListener(new PanelSelectAction(false));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(10, 10, 5, 10);
        panel.add((Component)this.rbHTMLGWClassic, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)this.rbHTMLEnhanced, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 30, 5, 10);
        panel.add((Component)this.cbIncludeHeaders, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.buildReplyPositionChooserPanel(this.rbHTMLTop, this.rbHTMLBottom), c);
        return panel;
    }

    private JPanel buildHTMLRight() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        OrientablePanel p = new OrientablePanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 5;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(5, 5, 0, 10);
        p.add((Component)new OrientableLabel(StringResources.FIRST_LINE_OF_REPLY_CONTAINS_C), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 5, 0, 0);
        p.add((Component)this.cbHtmlSeparator, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 5, 0, 0);
        p.add((Component)this.cbHtmlMessageIdentifier, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.insets = new Insets(0, 5, 0, 0);
        p.add((Component)this.cbHtmlEmail, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 5, 0, 0);
        p.add((Component)this.cbHtmlDate, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 5, 0, 0);
        p.add((Component)this.cbHtmlUserName, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)p, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JPanel(), c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 23;
        c.insets = new Insets(0, 10, 0, 10);
        panel.add((Component)this.taHtmlSampleText, c);
        return panel;
    }

    private JPanel buildReplyPositionChooserPanel(AbstractButton top, AbstractButton bottom) {
        OrientablePanel replyChooserPanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(10, 10, 10, 10);
        replyChooserPanel.add((Component)new OrientableLabel(StringResources.TYPE_MY_REPLY_C), constraints);
        replyChooserPanel.add(top);
        replyChooserPanel.add(bottom);
        return replyChooserPanel;
    }

    private Integer getHTMLReplyFormat() {
        int result = this.rbHTMLGWClassic.isSelected() ? 0 : 1;
        return result;
    }

    private Integer getPlainTextReplyFormat() {
        int result = this.rbPlainGWClassic.isSelected() ? 0 : (this.rbIncludeHeaders.isSelected() ? 1 : 2);
        return result;
    }

    public void collectValues() {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        accountSettings.setHTMLReplyFormat(this.getHTMLReplyFormat(), Boolean.valueOf(this.rbHTMLBottom.isSelected()), Boolean.valueOf(this.cbIncludeHeaders.isSelected()));
        Character replyChar = null;
        if (this.tfSeparator.getText().length() > 0) {
            replyChar = Character.valueOf(this.tfSeparator.getText().charAt(0));
        }
        accountSettings.setPlainTextReplyFormat(this.getPlainTextReplyFormat(), Boolean.valueOf(this.rbPlainTextBottom.isSelected()), replyChar);
        accountSettings.setStartReplyIncludeGtGtGt(this.cbPlainSeparator.isSelected());
        accountSettings.setStartReplyIncludeDate(this.cbPlainDate.isSelected());
        accountSettings.setStartReplyIncludeMessageId(this.cbPlainMessageIdentifier.isSelected());
        accountSettings.setStartReplyIncludeSenderName(this.cbPlainUserName.isSelected());
        accountSettings.setStartReplyIncludeSenderEmail(this.cbPlainEmail.isSelected());
        accountSettings.setStartReplyIncludeGtGtGtHTML(this.cbHtmlSeparator.isSelected());
        accountSettings.setStartReplyIncludeDateHTML(this.cbHtmlDate.isSelected());
        accountSettings.setStartReplyIncludeMessageIdHTML(this.cbHtmlMessageIdentifier.isSelected());
        accountSettings.setStartReplyIncludeSenderNameHTML(this.cbHtmlUserName.isSelected());
        accountSettings.setStartReplyIncludeSenderEmailHTML(this.cbHtmlEmail.isSelected());
        accountSettings.setReplyHighlightColor(this.btnColorChooser.getColor());
    }

    public void fireOptionsChanged() {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        AccountSettings.HTMLReplyFormat htmlReplyFormat = accountSettings.getHTMLReplyFormat();
        switch (htmlReplyFormat.getReplyType()) {
            case 0: {
                this.rbHTMLGWClassic.setSelected(true);
                break;
            }
            case 1: {
                this.rbHTMLEnhanced.setSelected(true);
            }
        }
        this.cbIncludeHeaders.setSelected(htmlReplyFormat.isReplyIncludeHeaders());
        if (htmlReplyFormat.isReplyInsertAtBottom()) {
            this.rbHTMLBottom.setSelected(true);
        } else {
            this.rbHTMLTop.setSelected(true);
        }
        AccountSettings.PlainTextReplyFormat plainTextReplyFormat = accountSettings.getPlainTextReplyFormat();
        int replyFormat = plainTextReplyFormat.getReplyType();
        switch (replyFormat) {
            case 0: {
                this.rbPlainGWClassic.setSelected(true);
                break;
            }
            case 1: {
                this.rbIncludeHeaders.setSelected(true);
                break;
            }
            case 2: {
                this.rbInternetStandard.setSelected(true);
            }
        }
        boolean bInternetStandard = replyFormat == 2;
        this.tfSeparator.setEnabled(bInternetStandard);
        if (plainTextReplyFormat.isReplyInsertAtBottom()) {
            this.rbPlainTextBottom.setSelected(true);
        } else {
            this.rbPlainTextTop.setSelected(true);
        }
        this.tfSeparator.setText(Character.toString(plainTextReplyFormat.getReplyChar()));
        this.cbPlainSeparator.setSelected(accountSettings.getStartReplyIncludeGtGtGt());
        this.cbPlainDate.setSelected(accountSettings.getStartReplyIncludeDate());
        this.cbPlainMessageIdentifier.setSelected(accountSettings.getStartReplyIncludeMessageId());
        this.cbPlainUserName.setSelected(accountSettings.getStartReplyIncludeSenderName());
        this.cbPlainEmail.setSelected(accountSettings.getStartReplyIncludeSenderEmail());
        this.cbHtmlSeparator.setSelected(accountSettings.getStartReplyIncludeGtGtGtHTML());
        this.cbHtmlDate.setSelected(accountSettings.getStartReplyIncludeDateHTML());
        this.cbHtmlMessageIdentifier.setSelected(accountSettings.getStartReplyIncludeMessageIdHTML());
        this.cbHtmlUserName.setSelected(accountSettings.getStartReplyIncludeSenderNameHTML());
        this.cbHtmlEmail.setSelected(accountSettings.getStartReplyIncludeSenderEmailHTML());
        Color replyColor = accountSettings.getReplyHighlightColor();
        this.btnColorChooser.setColor(replyColor);
        this.btnColorChooser.setEnabled(replyColor != null);
        this.cbTextColor.setSelected(replyColor != null);
        if (!this.isPrepared) {
            this.showSampleTextForPlainText = !OptionManager.getInstance().getTextOption().isDefaultComposeHTML();
        }
    }

    public void prepareForShow() {
        super.prepareForShow();
        this.refreshText();
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    private void refreshButtons() {
        if (this.showSampleTextForPlainText.booleanValue()) {
            if (this.rbPlainGWClassic.isSelected()) {
                this.setEnablePlainReplyContains(false);
                this.tfSeparator.setEnabled(false);
                this.cbPlainSeparator.setEnabled(false);
                this.rbPlainTextTop.setEnabled(false);
                this.rbPlainTextBottom.setEnabled(false);
            } else if (this.rbIncludeHeaders.isSelected()) {
                this.setEnablePlainReplyContains(false);
                this.tfSeparator.setEnabled(false);
                this.cbPlainSeparator.setEnabled(true);
                this.rbPlainTextTop.setEnabled(true);
                this.rbPlainTextBottom.setEnabled(true);
            } else if (this.rbInternetStandard.isSelected()) {
                this.setEnablePlainReplyContains(true);
                this.tfSeparator.setEnabled(true);
                this.rbPlainTextBottom.setEnabled(true);
                this.rbPlainTextTop.setEnabled(true);
                this.cbPlainSeparator.setEnabled(true);
                this.rbPlainTextTop.setSelected(true);
            }
        } else if (this.rbHTMLGWClassic.isSelected()) {
            this.setEnableHtmlReplyContains(false);
            this.setEnableHTMLButtons(false);
            this.tfSeparator.setEnabled(false);
            this.cbHtmlSeparator.setEnabled(false);
            this.rbHTMLTop.setSelected(true);
            this.cbIncludeHeaders.setSelected(false);
        } else if (this.rbHTMLEnhanced.isSelected()) {
            this.setEnableHTMLButtons(true);
            if (this.cbIncludeHeaders.isSelected()) {
                this.setEnableHtmlReplyContains(false);
                this.setEnableHTMLButtons(true);
                this.tfSeparator.setEnabled(false);
                this.cbHtmlSeparator.setEnabled(true);
            } else {
                this.setEnableHtmlReplyContains(true);
                this.tfSeparator.setEnabled(false);
                this.cbHtmlSeparator.setEnabled(true);
            }
        }
    }

    private void refreshText() {
        if (!this.isPrepared) {
            return;
        }
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        boolean isGWCLassic = this.rbPlainGWClassic.isSelected();
        boolean isIncludeHeaders = this.rbIncludeHeaders.isSelected();
        String samplePlainText = accountSettings.getStartReplySampleText(isGWCLassic, isIncludeHeaders, this.cbPlainSeparator.isSelected(), this.cbPlainDate.isSelected(), this.cbPlainMessageIdentifier.isSelected(), this.cbPlainUserName.isSelected(), this.cbPlainEmail.isSelected());
        this.taPlainSampleText.setText(samplePlainText);
        isGWCLassic = this.rbHTMLGWClassic.isSelected();
        isIncludeHeaders = this.rbHTMLEnhanced.isSelected() && this.cbIncludeHeaders.isSelected();
        String sampleHtmlText = accountSettings.getStartReplySampleText(isGWCLassic, isIncludeHeaders, this.cbHtmlSeparator.isSelected(), this.cbHtmlDate.isSelected(), this.cbHtmlMessageIdentifier.isSelected(), this.cbHtmlUserName.isSelected(), this.cbHtmlEmail.isSelected());
        this.taHtmlSampleText.setText(sampleHtmlText);
        this.logger.debug((Object)("PlainText: " + this.showSampleTextForPlainText + ", GWClassic: " + isGWCLassic + ", Headers: " + isIncludeHeaders));
    }

    private void setEnableHTMLButtons(boolean b) {
        this.rbHTMLTop.setEnabled(b);
        this.rbHTMLBottom.setEnabled(b);
        this.cbIncludeHeaders.setEnabled(b);
    }

    private void setEnablePlainReplyContains(boolean b) {
        this.cbPlainDate.setEnabled(b);
        this.cbPlainEmail.setEnabled(b);
        this.cbPlainMessageIdentifier.setEnabled(b);
        this.cbPlainUserName.setEnabled(b);
    }

    private void setEnableHtmlReplyContains(boolean b) {
        this.cbHtmlDate.setEnabled(b);
        this.cbHtmlEmail.setEnabled(b);
        this.cbHtmlMessageIdentifier.setEnabled(b);
        this.cbHtmlUserName.setEnabled(b);
    }

    private void setEnableInternetStandard(boolean b) {
        this.cbTextColor.setEnabled(b);
        this.tfSeparator.setEnabled(b);
        if (!b) {
            this.btnColorChooser.setEnabled(b);
        } else if (b && this.cbTextColor.isSelected()) {
            this.btnColorChooser.setEnabled(b);
        }
    }

    private class PanelSelectAction
    extends MouseAdapter {
        boolean bPlainTextSide;

        public PanelSelectAction(boolean bPlainTextSide) {
            this.bPlainTextSide = bPlainTextSide;
        }

        public void mouseReleased(MouseEvent e) {
            ReplyFormatOptionPane.this.showSampleTextForPlainText = this.bPlainTextSide;
            ReplyFormatOptionPane.this.refreshText();
        }
    }

    private class RefreshTextAction
    implements ItemListener {
        private RefreshTextAction() {
        }

        public void itemStateChanged(ItemEvent e) {
            ReplyFormatOptionPane.this.refreshText();
        }
    }

    private class RefreshButtonAction
    implements ItemListener {
        boolean bPlainTextAction;

        public RefreshButtonAction(boolean bPlainTextAction) {
            this.bPlainTextAction = bPlainTextAction;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 || e.getSource() instanceof JCheckBox) {
                ReplyFormatOptionPane.this.showSampleTextForPlainText = this.bPlainTextAction;
                ReplyFormatOptionPane.this.refreshButtons();
                ReplyFormatOptionPane.this.refreshText();
            }
        }
    }
}

