/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.printing;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

class PrintingMessagePanel
extends AbstractOptionPanel {
    private JCheckBox cbUserName;
    private JCheckBox cbItemType;
    private JCheckBox cbFrom;
    private JCheckBox cbTo;
    private JCheckBox cbSubject;
    private PrintingOptions printingOptions;

    public PrintingMessagePanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        this.setName(StringResources.MESSAGE);
    }

    protected void build() {
        CheckClickActionListener clickListener = new CheckClickActionListener();
        this.cbUserName = new JMnemonicCheckBox(StringResources.USER_NAME);
        this.cbItemType = new JMnemonicCheckBox(StringResources.MESSAGE_TYPE);
        this.cbFrom = new JMnemonicCheckBox(StringResources.FROM);
        this.cbTo = new JMnemonicCheckBox(StringResources.TO);
        this.cbSubject = new JMnemonicCheckBox(StringResources.SUBJECT);
        this.cbFrom.addActionListener(clickListener);
        this.cbItemType.addActionListener(clickListener);
        this.cbSubject.addActionListener(clickListener);
        this.cbTo.addActionListener(clickListener);
        this.cbUserName.addActionListener(clickListener);
        this.setBorder(BorderFactory.createTitledBorder(StringResources.FOR_EVERY_MESSAGE_PRINT_C));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.insets = new Insets(5, 5, 2, 0);
        this.add((Component)this.cbUserName, c);
        this.add((Component)this.cbItemType, c);
        this.add((Component)this.cbFrom, c);
        this.add((Component)this.cbTo, c);
        this.add((Component)this.cbSubject, c);
        c.weighty = 1.0;
        this.add((Component)new JPanel(), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)new JPanel(), c);
    }

    public void collectValues() {
        this.printingOptions.setUserNamePrinted(this.cbUserName.isSelected());
        this.printingOptions.setItemTypePrinted(this.cbItemType.isSelected());
        this.printingOptions.setFromPrinted(this.cbFrom.isSelected());
        this.printingOptions.setToPrinted(this.cbTo.isSelected());
        this.printingOptions.setSubjectPrinted(this.cbSubject.isSelected());
    }

    public void fireOptionsChanged() {
        this.cbUserName.setSelected(this.printingOptions.isUserNamePrinted());
        this.cbItemType.setSelected(this.printingOptions.isItemTypePrinted());
        this.cbFrom.setSelected(this.printingOptions.isFromPrinted());
        this.cbTo.setSelected(this.printingOptions.isToPrinted());
        this.cbSubject.setSelected(this.printingOptions.isSubjectPrinted());
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
        if (!(theAbstractOptions instanceof PrintingOptions)) {
            throw new IllegalArgumentException();
        }
        this.printingOptions = (PrintingOptions)theAbstractOptions;
    }

    private class CheckClickActionListener
    implements ActionListener {
        private CheckClickActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintingMessagePanel.this.changesListener.setValueChanged();
        }
    }
}

