/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.security;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.AbstractPasswordChangePanel;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.options.compose.security.ChangePasswordPaneController;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.GWSecurityPasswordOptions;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ChangePasswordPane
extends AbstractPasswordChangePanel
implements MVCView {
    private static Logger logger = Logger.getLogger(ChangePasswordPane.class);
    private boolean canClearPassword;
    private GWSecurityPasswordOptions securityPasswordOptions;
    private ActionClearPassword actionClearPassword;
    private JCheckBox cbUseCasa;
    private JCheckBox cbRememberPassword;
    private JButton btnClearPassword;
    private MVCController controller;
    private OptionChangesListener changesListener;
    private boolean modified;
    private boolean thisTabSelected = true;

    public ChangePasswordPane(boolean performChange, boolean disableOldPassword, String userGuid, MVCController parentController, OptionChangesListener changesListener) {
        super(false, performChange, disableOldPassword, userGuid);
        this.controller = new ChangePasswordPaneController(this, parentController);
        this.setName(StringResources.PASSWORD);
        this.setChangesListener(changesListener);
    }

    protected void init() {
        super.init();
        GWCommandManager commandManager = GWCommandManager.getInstance(this.userGuid);
        this.securityPasswordOptions = commandManager.getSecurityPasswordOptions();
        this.canClearPassword = commandManager.canClearPassword();
        logger.debug((Object)("canClearPassword = " + this.canClearPassword));
    }

    private void setChangesListener(OptionChangesListener changesListener) {
        if (changesListener == null) {
            throw new IllegalArgumentException("Changes listener is null");
        }
        this.changesListener = changesListener;
        FieldModificationListener fieldModificationListener = new FieldModificationListener();
        if (this.securityPasswordOptions.isCasaSupported()) {
            this.cbRememberPassword.addChangeListener(fieldModificationListener);
            this.cbUseCasa.addChangeListener(fieldModificationListener);
        }
    }

    protected void handleNewPasswordDontMatch() {
        this.setModified(true);
    }

    protected void handleNewPasswordMatch() {
        this.setModified(true);
    }

    protected void buildComponents() {
        super.buildComponents();
        if (this.canClearPassword) {
            this.actionClearPassword = new ActionClearPassword();
            this.btnClearPassword = new JButton(this.actionClearPassword);
            this.actionClearPassword.setEnabled(this.isClearPasswordAllowed());
        }
        if (this.securityPasswordOptions.isCasaSupported()) {
            this.cbUseCasa = new JCheckBox(StringResources.USE_COLLABORATION_SINGLE_SIGN_ON_CASA);
            this.cbRememberPassword = new JCheckBox(StringResources.REMENBER_MY_PASSWORD);
            this.cbUseCasa.setSelected(this.securityPasswordOptions.isCasaEnabled());
            this.cbRememberPassword.setSelected(this.securityPasswordOptions.isRememberPassword());
            this.cbUseCasa.setEnabled(this.isOldPasswordValid());
            this.cbRememberPassword.setEnabled(this.isOldPasswordValid());
        }
    }

    protected void layoutComponents() {
        super.layoutComponents();
        if (this.canClearPassword) {
            this.constraints.gridx = 0;
            this.constraints.gridwidth = 2;
            ++this.constraints.gridy;
            this.constraints.fill = 0;
            this.constraints.weightx = 0.0;
            this.constraints.anchor = 24;
            this.add((Component)this.btnClearPassword, this.constraints);
            this.constraints.anchor = 21;
            this.constraints.fill = 2;
        }
        if (this.securityPasswordOptions.isCasaSupported()) {
            this.constraints.gridx = 0;
            this.constraints.gridwidth = 2;
            ++this.constraints.gridy;
            this.constraints.weightx = 1.0;
            this.add((Component)this.cbUseCasa, this.constraints);
            ++this.constraints.gridy;
            this.add((Component)this.cbRememberPassword, this.constraints);
        }
        ++this.constraints.gridy;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 1;
        this.add(Box.createVerticalGlue(), this.constraints);
    }

    private void clearPassword() {
        try {
            boolean result = GWCommandManager.getInstance(this.userGuid).clearPassword(this.getOldPassword());
            boolean isPasswordSet = GWCommandManager.getInstance(this.userGuid).isPasswordSet();
            this.reset(!isPasswordSet);
            if (result) {
                this.updateFocus();
            } else {
                JOptionPane.showMessageDialog(this, StringResources.PASSWORD_WAS_NOT_CLEARED, StringResources.ERROR, 0);
            }
        }
        catch (GWCommandException e) {
            logger.error((Object)e, (Throwable)e);
            ErrorDialog.processGWException(e, this);
            this.clearFields();
        }
    }

    protected void handleOldPasswordValidated() {
        if (this.canClearPassword) {
            this.actionClearPassword.setEnabled(this.isClearPasswordAllowed());
        }
        if (this.securityPasswordOptions.isCasaSupported()) {
            this.cbUseCasa.setEnabled(true);
            this.cbRememberPassword.setEnabled(true);
        }
    }

    private boolean changePassword() {
        if (!this.isOldPasswordValid()) {
            throw new IllegalStateException("old password is not validated");
        }
        boolean success = false;
        String newPassword = null;
        if (this.isNewPasswordProvided()) {
            logger.debug((Object)"new password is provided...");
            if (this.isNewPasswordFine()) {
                logger.debug((Object)"new password is fine...");
                newPassword = this.getNewPassword();
            } else {
                logger.debug((Object)"new password is NOT fine...");
                JOptionPane.showMessageDialog(this, StringResources.THE_PASSWORDS_DONT_MATCH, StringResources.GROUP_WISE_ERROR, 2);
                return false;
            }
        }
        if (this.performChange) {
            try {
                Boolean useCasa = null;
                Boolean rememberPassword = null;
                if (this.securityPasswordOptions.isCasaSupported()) {
                    useCasa = this.cbUseCasa.isSelected();
                    rememberPassword = this.cbRememberPassword.isSelected();
                } else if (newPassword == null) {
                    logger.debug((Object)"nothing to change");
                    return true;
                }
                success = GWCommandManager.getInstance(this.userGuid).setSecurityPasswordOptions(this.getOldPassword(), newPassword, useCasa, rememberPassword);
                if (!success) {
                    JOptionPane.showMessageDialog(this, StringResources.PASSWORD_WAS_NOT_CHANGED, StringResources.ERROR, 0);
                }
            }
            catch (GWCommandException ee) {
                logger.error((Object)ee, (Throwable)ee);
                ErrorDialog.processGWException(ee, this);
                this.clearFields();
            }
        }
        return success;
    }

    public boolean saveChanges() {
        boolean success = false;
        if (this.isOldPasswordValid()) {
            logger.debug((Object)"old password is valid");
            success = this.changePassword();
        } else {
            success = true;
        }
        boolean isPasswordSet = GWCommandManager.getInstance(this.userGuid).isPasswordSet();
        this.reset(!isPasswordSet);
        logger.debug((Object)("success = " + success));
        return success;
    }

    protected void reset(boolean disableOldPassword) {
        super.reset(disableOldPassword);
        if (this.canClearPassword) {
            this.actionClearPassword.setEnabled(this.isClearPasswordAllowed());
        }
        if (this.securityPasswordOptions.isCasaSupported()) {
            this.cbUseCasa.setEnabled(this.isOldPasswordValid());
            this.cbRememberPassword.setEnabled(this.isOldPasswordValid());
        }
        this.setModified(false);
    }

    private void setModified(boolean modified) {
        this.modified = modified;
        if (modified) {
            this.changesListener.setValueChanged();
        } else {
            this.changesListener.setValueSaved();
        }
    }

    private boolean isClearPasswordAllowed() {
        return this.canClearPassword && this.isOldPasswordValid() && this.getOldPassword().length() > 0;
    }

    protected void updateFocus() {
        if (!this.isFocusUpdateAllowed()) {
            throw new IllegalStateException("focus update is not allowed");
        }
        if (this.isOldPasswordValid()) {
            this.pfNewPassword.requestFocusInWindow();
        } else {
            this.pfOldPassword.requestFocusInWindow();
        }
    }

    public boolean isFocusUpdateAllowed() {
        boolean result = false;
        if (!this.modified && this.thisTabSelected && ((ChangePasswordPaneController)this.controller).isViewCardDisplayed()) {
            result = true;
        }
        return result;
    }

    public void registerTabbedPaneListener(final JTabbedPane tabbedPane) {
        if (tabbedPane == null) {
            throw new IllegalArgumentException("tabbed pane is null");
        }
        tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (tabbedPane.getSelectedComponent() == ChangePasswordPane.this) {
                    ChangePasswordPane.this.thisTabSelected = true;
                    if (ChangePasswordPane.this.isFocusUpdateAllowed()) {
                        ChangePasswordPane.this.updateFocus();
                    }
                } else {
                    ChangePasswordPane.this.thisTabSelected = false;
                }
            }
        });
    }

    public MVCController getController() {
        return this.controller;
    }

    public Object getMVCModel() {
        return null;
    }

    public void setController(MVCController controller) {
        this.controller = controller;
    }

    public void setMVCModel(Object model) {
    }

    private class FieldModificationListener
    implements ChangeListener {
        private FieldModificationListener() {
        }

        public void stateChanged(ChangeEvent e) {
            ChangePasswordPane.this.setModified(true);
        }
    }

    private class ActionClearPassword
    extends AbstractAction {
        public ActionClearPassword() {
            super(StringResources.CLEAR_PASSWORD);
        }

        public void actionPerformed(ActionEvent e) {
            ChangePasswordPane.this.clearPassword();
        }
    }
}

