/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.security;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.ProxyAccessEntry;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.application.frames.options.compose.security.AbstractAddressListOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.security.AccessTableModel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class ProxyAccessPane
extends AbstractAddressListOptionPanel {
    protected AccessTableModel model;
    private JPanel pnlAccessRights;
    private JCheckBox cbMailReadAccess = new OrientableCheckBox();
    private JCheckBox cbMailWriteAccess = new OrientableCheckBox();
    private JCheckBox cbAppointmentReadAccess = new OrientableCheckBox();
    private JCheckBox cbAppointmentWriteAccess = new OrientableCheckBox();
    private JCheckBox cbNotesReadAccess = new OrientableCheckBox();
    private JCheckBox cbNotesWriteAccess = new OrientableCheckBox();
    private JCheckBox cbTaskReadAccess = new OrientableCheckBox();
    private JCheckBox cbTaskWriteAccess = new OrientableCheckBox();
    private JCheckBox cbSubscribeToMyAlarm = new OrientableCheckBox();
    private JCheckBox cbSubscribeToMyNotifications = new OrientableCheckBox();
    private JCheckBox cbModifyOptionsRulesFolders = new OrientableCheckBox();
    private JCheckBox cbReadItemsMarkedPrivate = new OrientableCheckBox();
    private JButton defaultButton;

    public ProxyAccessPane(OptionChangesListener theChangesListener, MVCController theParentController, String userGuid) {
        super(theChangesListener, theParentController, userGuid);
        this.model = new AccessTableModel(this.userGuid);
    }

    private void init() {
        this.tblAddressList.setModel(this.model);
        this.pnlAccessRights = this.buildAccessRightsPane();
        this.strBorderTitle = StringResources.ACCESS_RIGHTS_FOR;
        this.titledBorder.setTitle(this.strBorderTitle);
        this.tblAddressList.getSelectionModel().setSelectionMode(0);
        this.tblAddressList.setDefaultRenderer(Object.class, new OrientableTableCellRenderer());
        int initSel = this.model.getRowCount() > 1 ? 1 : 0;
        this.tblAddressList.setRowSelectionInterval(initSel, initSel);
        this.lblTableTitle.setText(StringResources.ACCESS_LIST_C);
        this.cbMailReadAccess.setAction(new AbstractAction(StringResources.READ){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().mail.setReadAccess(ProxyAccessPane.this.cbMailReadAccess.isSelected());
            }
        });
        this.cbMailWriteAccess.setAction(new AbstractAction(StringResources.WRITE){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().mail.setWriteAccess(ProxyAccessPane.this.cbMailWriteAccess.isSelected());
            }
        });
        this.cbAppointmentReadAccess.setAction(new AbstractAction(StringResources.READ){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().appt.setReadAccess(ProxyAccessPane.this.cbAppointmentReadAccess.isSelected());
            }
        });
        this.cbAppointmentWriteAccess.setAction(new AbstractAction(StringResources.WRITE){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().appt.setWriteAccess(ProxyAccessPane.this.cbAppointmentWriteAccess.isSelected());
            }
        });
        this.cbNotesReadAccess.setAction(new AbstractAction(StringResources.READ){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().note.setReadAccess(ProxyAccessPane.this.cbNotesReadAccess.isSelected());
            }
        });
        this.cbNotesWriteAccess.setAction(new AbstractAction(StringResources.WRITE){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().note.setWriteAccess(ProxyAccessPane.this.cbNotesWriteAccess.isSelected());
            }
        });
        this.cbTaskReadAccess.setAction(new AbstractAction(StringResources.READ){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().todo.setReadAccess(ProxyAccessPane.this.cbTaskReadAccess.isSelected());
            }
        });
        this.cbTaskWriteAccess.setAction(new AbstractAction(StringResources.WRITE){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().todo.setWriteAccess(ProxyAccessPane.this.cbTaskWriteAccess.isSelected());
            }
        });
        this.cbModifyOptionsRulesFolders.setAction(new AbstractAction(StringResources.MODIFY_OPTIONS_RULES_FOLDERS){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().misc.setModifySettings(ProxyAccessPane.this.cbModifyOptionsRulesFolders.isSelected());
            }
        });
        this.cbReadItemsMarkedPrivate.setAction(new AbstractAction(StringResources.READ_ITEMS_MARKED_PRIVATE){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().misc.setReadPrivate(ProxyAccessPane.this.cbReadItemsMarkedPrivate.isSelected());
            }
        });
        this.cbSubscribeToMyAlarm.setAction(new AbstractAction(StringResources.SUBSCRIBE_TO_MY_ALARMS){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().misc.setSubscribeAlarms(ProxyAccessPane.this.cbSubscribeToMyAlarm.isSelected());
            }
        });
        this.cbSubscribeToMyNotifications.setAction(new AbstractAction(StringResources.SUBSCRIBE_TO_MY_NOTIFICATIONS){

            public void actionPerformed(ActionEvent e) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().misc.setSubscribeNotify(ProxyAccessPane.this.cbSubscribeToMyNotifications.isSelected());
            }
        });
        this.tfName.setListener(new SearchResultListener(){

            public void searchFinished(SearchEvent e) {
                ProxyAccessPane.this.search(e);
                if (ProxyAccessPane.this.defaultButton != null) {
                    ProxyAccessPane.this.getRootPane().setDefaultButton(ProxyAccessPane.this.defaultButton);
                }
            }
        });
        this.processItemSelection();
    }

    void processItemSelection() {
        int index = this.tblAddressList.getSelectedRow();
        if (index != -1) {
            ProxyAccessEntry proxyAccessEntry = this.model.getProxyAccessEntry(index);
            this.pnlAccessRights.setBorder(BorderFactory.createTitledBorder(StringResources.formatString(StringResources.ACCESS_RIGHTS_FOR, proxyAccessEntry.getDisplayName())));
            this.cbMailReadAccess.setSelected(proxyAccessEntry.mail.hasReadAccess());
            this.cbMailWriteAccess.setSelected(proxyAccessEntry.mail.hasWriteAccess());
            this.cbAppointmentReadAccess.setSelected(proxyAccessEntry.appt.hasReadAccess());
            this.cbAppointmentWriteAccess.setSelected(proxyAccessEntry.appt.hasWriteAccess());
            this.cbNotesReadAccess.setSelected(proxyAccessEntry.note.hasReadAccess());
            this.cbNotesWriteAccess.setSelected(proxyAccessEntry.note.hasWriteAccess());
            this.cbTaskReadAccess.setSelected(proxyAccessEntry.todo.hasReadAccess());
            this.cbTaskWriteAccess.setSelected(proxyAccessEntry.todo.hasWriteAccess());
            this.cbModifyOptionsRulesFolders.setSelected(proxyAccessEntry.misc.hasModifySettings());
            this.cbReadItemsMarkedPrivate.setSelected(proxyAccessEntry.misc.hasReadPrivate());
            this.cbSubscribeToMyAlarm.setSelected(proxyAccessEntry.misc.hasSubscribeAlarms());
            this.cbSubscribeToMyNotifications.setSelected(proxyAccessEntry.misc.hasSubscribeNotify());
            this.btnRemoveUser.setEnabled(this.tblAddressList.getSelectedRow() != 0);
        }
        boolean isEnabled = index != -1;
        this.cbMailReadAccess.setEnabled(isEnabled);
        this.cbMailWriteAccess.setEnabled(isEnabled);
        this.cbAppointmentReadAccess.setEnabled(isEnabled);
        this.cbAppointmentWriteAccess.setEnabled(isEnabled);
        this.cbNotesReadAccess.setEnabled(isEnabled);
        this.cbNotesWriteAccess.setEnabled(isEnabled);
        this.cbTaskReadAccess.setEnabled(isEnabled);
        this.cbTaskWriteAccess.setEnabled(isEnabled);
        this.cbModifyOptionsRulesFolders.setEnabled(isEnabled);
        this.cbReadItemsMarkedPrivate.setEnabled(isEnabled);
        this.cbSubscribeToMyAlarm.setEnabled(isEnabled);
        this.cbSubscribeToMyNotifications.setEnabled(isEnabled);
    }

    void removeUser() {
        int selectedRow = this.tblAddressList.getSelectedRow();
        this.model.removeContact(selectedRow);
    }

    void addContacts(List contacts) {
        this.model.addContacts(contacts);
        IAddressable addressable = (IAddressable)contacts.get(0);
        int index = this.model.indexOf(addressable);
        if (index > 0) {
            this.tblAddressList.setRowSelectionInterval(index, index);
        }
    }

    void search(SearchEvent e) {
        boolean bBad = true;
        IAddressable addressable = e.getFoundContact();
        if (addressable != null && addressable instanceof IContact) {
            ArrayList<IAddressable> list = new ArrayList<IAddressable>(1);
            list.add(addressable);
            this.model.addContacts(list);
            int index = this.model.indexOf(addressable);
            if (index > 0) {
                this.tblAddressList.setRowSelectionInterval(index, index);
            }
            bBad = false;
        }
        if (bBad) {
            JOptionPane.showMessageDialog(null, StringResources.formatString(StringResources.IS_NOT_A_VALID_GROUPWISE_USER, this.tfName.getText(), this.tfName.getText()), StringResources.NOVELL_GROUPWISE, 2);
        }
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
    }

    private ProxyAccessEntry getSelectedAccessEntry() {
        int index = this.tblAddressList.getSelectedRow();
        return this.model.getProxyAccessEntry(index);
    }

    public void saveChanges() {
        this.model.saveChanges();
    }

    void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createAddressListPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.pnlAccessRights, constraints);
    }

    private JPanel buildAccessRightsPane() {
        OrientablePanel pnlContent = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.insets.left = 5;
        constraints.gridy = 0;
        pnlContent.add((Component)new OrientableLabel(StringResources.MAIL_PHONE_C), constraints);
        pnlContent.add((Component)this.cbMailReadAccess, constraints);
        constraints.weightx = 1.0;
        pnlContent.add((Component)this.cbMailWriteAccess, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        pnlContent.add((Component)new OrientableLabel(StringResources.APPOINTMENTS_C), constraints);
        pnlContent.add((Component)this.cbAppointmentReadAccess, constraints);
        constraints.weightx = 1.0;
        pnlContent.add((Component)this.cbAppointmentWriteAccess, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        pnlContent.add((Component)new OrientableLabel(StringResources.REMINDER_NOTES_C), constraints);
        pnlContent.add((Component)this.cbNotesReadAccess, constraints);
        constraints.weightx = 1.0;
        pnlContent.add((Component)this.cbNotesWriteAccess, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        pnlContent.add((Component)new OrientableLabel(StringResources.TASKS_C), constraints);
        pnlContent.add((Component)this.cbTaskReadAccess, constraints);
        constraints.weightx = 1.0;
        pnlContent.add((Component)this.cbTaskWriteAccess, constraints);
        constraints.gridwidth = 3;
        ++constraints.gridy;
        pnlContent.add((Component)this.cbSubscribeToMyAlarm, constraints);
        ++constraints.gridy;
        pnlContent.add((Component)this.cbSubscribeToMyNotifications, constraints);
        ++constraints.gridy;
        pnlContent.add((Component)this.cbModifyOptionsRulesFolders, constraints);
        ++constraints.gridy;
        pnlContent.add((Component)this.cbReadItemsMarkedPrivate, constraints);
        return pnlContent;
    }

    protected void build() {
        this.init();
        this.buildUI();
    }

    public void collectValues() {
    }

    public void fireOptionsChanged() {
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }
}

