/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.compose.send.AbstractItemOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.GWExpandButton;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.sendoptions.AppSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.Notification;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.ItemSendOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AppointmentTrackingOptionsPanel
extends AbstractItemOptionsPanel {
    public AppointmentTrackingOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        this.init();
        this.buildUI();
    }

    private void init() {
        this.cbCreateSentItemToTrack.setEnabled(false);
        this.btnWhenDeclined = new GWExpandButton(Notification.NOTIFICATION_LIST, this.itemListener);
        this.btnWhenOpened = new GWExpandButton(Notification.NOTIFICATION_LIST, this.itemListener);
        this.btnWhenAccepted = new GWExpandButton(Notification.NOTIFICATION_LIST, this.itemListener);
        this.cbSendNotifications.setEnabled(false);
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
        this.fireOptionsChanged((AppSendOptions)theAbstractOptions);
    }

    public void fireOptionsChanged(AppSendOptions appSendOptions) {
        super.fireOptionsChanged();
        this.btnWhenAccepted.setSelectedItem(appSendOptions.getRNWhenAccept());
        this.btnWhenDeclined.setSelectedItem(appSendOptions.getRNWhenDeclined());
        this.btnWhenOpened.setSelectedItem(appSendOptions.getRNWhenOpened());
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.cbCreateSentItemToTrack.setSelected((Boolean)dataStoreSettings.getSendOptionCreateSentItem().getValue());
        ((JRadioButton)this.buttonList.get((Integer)dataStoreSettings.getSendOptionStatusTracking(ItemType.APPT.getValue()).getValue() - 1)).setSelected(true);
    }

    public void collectValues(ItemSendOptions itemSendOptions) {
        itemSendOptions.setRNAppAccepted((Notification)this.btnWhenAccepted.getSelectedItem());
        itemSendOptions.setRNAppDeclined((Notification)this.btnWhenDeclined.getSelectedItem());
        itemSendOptions.setRNAppOpened((Notification)this.btnWhenOpened.getSelectedItem());
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        dataStoreSettings.setSendOptionStatusTracking(ItemType.APPT.getValue(), this.getSendOptionStatusTrackingValue());
    }

    JPanel createReturnNotificationPanel() {
        OrientablePanel panel = new OrientablePanel(new GridLayout());
        panel.setBorder(BorderFactory.createTitledBorder(StringResources.RETURN_NOTIFICATION));
        OrientablePanel panelLeft = new OrientablePanel(new GridBagLayout());
        OrientablePanel panelRight = new OrientablePanel(new GridBagLayout());
        panel.add(panelLeft);
        panel.add(panelRight);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 10, 0, 10);
        panelLeft.add((Component)new JMnemonicLabel(StringResources.WHEN_OPENED, this.btnWhenOpened), constraints);
        ++constraints.gridy;
        constraints.insets.top = 5;
        panelLeft.add((Component)this.btnWhenOpened, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panelLeft.add((Component)new JMnemonicLabel(StringResources.WHEN_DECLINED, this.btnWhenDeclined), constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(5, 10, 10, 10);
        panelLeft.add((Component)this.btnWhenDeclined, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(10, 10, 0, 10);
        panelRight.add((Component)new JMnemonicLabel(StringResources.WHEN_ACCEPTED, this.btnWhenAccepted), constraints);
        ++constraints.gridy;
        constraints.insets.top = 5;
        constraints.weighty = 1.0;
        panelRight.add((Component)this.btnWhenAccepted, constraints);
        return panel;
    }
}

