/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.novell.gw.jclient.api.enums.CategoryListRecordStatusType;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CategoriesCheckBoxChooser
extends ExtendedGWTable {
    private ICategoryList categories;
    private JTextField viewComponent;
    private Object[][] data = new Object[][]{{StringResources.NO_CATEGORIES}};
    private boolean isMultiple = true;
    private String userGuid;

    public CategoriesCheckBoxChooser(ICategoryList itemCategories, JTextField viewComponent, boolean isMultiple, String userGuid) {
        this.categories = itemCategories;
        this.viewComponent = viewComponent;
        this.isMultiple = isMultiple;
        this.userGuid = userGuid;
        this.initTable();
        this.addListeners();
    }

    private void addListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    CategoriesCheckBoxChooser.this.tableKeyPressed();
                }
            }
        });
        this.addKeyListener(new TableKeyListener());
    }

    private void tableKeyPressed() {
        if (this.isMultiple) {
            if (this.categories.findCategoryIndex(CategoryUtils.getCategory(this.getSelectedRow(), this.userGuid)) == -1) {
                this.categories.addCategory(CategoryUtils.getCategory(this.getSelectedRow(), this.userGuid), CategoryListRecordStatusType.ADD);
            } else {
                this.categories.addCategory(CategoryUtils.getCategory(this.getSelectedRow(), this.userGuid), CategoryListRecordStatusType.REMOVE);
            }
        } else {
            this.categories.clear();
            this.categories.addCategory(CategoryUtils.getCategory(this.getSelectedRow(), this.userGuid), CategoryListRecordStatusType.ADD);
        }
        ((TableCheckBoxModel)this.getModel()).fireTableDataChanged();
        this.updateText();
    }

    public void updateText() {
        String viewText = "";
        int count = CategoryUtils.getCategoryCount(this.userGuid);
        for (int i = 0; i < count; ++i) {
            if (this.categories == null || this.categories.findCategoryIndex(CategoryUtils.getCategory(i, this.userGuid)) <= -1) continue;
            viewText = viewText + CategoryUtils.getCategory(i, this.userGuid).getName() + ';';
        }
        if (viewText.length() != 0) {
            viewText = viewText.substring(0, viewText.length() - 1);
        }
        this.viewComponent.setText(viewText);
    }

    public void setCategories(ICategoryList categories) {
        this.categories = categories;
        this.initTable();
    }

    public ICategoryList getCategories() {
        return this.categories;
    }

    private void initTable() {
        if (CategoryUtils.getCategoryCount(this.userGuid) != 0) {
            this.setModel(new TableCheckBoxModel());
            this.setDefaultRenderer(Object.class, new ItemCategoryRenderer());
            if (this.isMultiple) {
                this.setDefaultRenderer(Boolean.class, new ItemCategoryCheckboxRenderer());
                TableColumn column = this.getColumnModel().getColumn(0);
                column.setResizable(false);
                column.setMaxWidth(16);
                column.setMinWidth(16);
            }
        } else {
            this.setModel(new DefaultTableModel(this.data, this.data[0]){

                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            });
        }
        this.setShowGrid(false);
        this.setSelectionMode(0);
        this.setTableHeader(null);
    }

    private class TableKeyListener
    implements KeyListener {
        private TableKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if ((e.getKeyCode() == 32 || e.getKeyCode() == 10) && CategoriesCheckBoxChooser.this.getSelectedRow() != -1) {
                CategoriesCheckBoxChooser.this.tableKeyPressed();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class ItemCategoryCheckboxRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        public ItemCategoryCheckboxRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0 && CategoriesCheckBoxChooser.this.isMultiple) {
                this.setSelected((Boolean)value);
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    private class ItemCategoryRenderer
    extends OrientableTableCellRenderer {
        private ItemCategoryRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 1 || !CategoriesCheckBoxChooser.this.isMultiple) {
                Color textColor = CategoryUtils.checkTextColorForNull(CategoryUtils.getCategory(row, CategoriesCheckBoxChooser.this.userGuid).getTextColor());
                Color backgroundColor = CategoryUtils.checkBackgroundColorForNull(CategoryUtils.getCategory(row, CategoriesCheckBoxChooser.this.userGuid).getBackgroundColor());
                component.setForeground(isSelected ? backgroundColor : textColor);
                component.setBackground(isSelected ? textColor : backgroundColor);
            }
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableCheckBoxModel
    extends AbstractTableModel {
        private TableCheckBoxModel() {
        }

        @Override
        public int getRowCount() {
            return CategoryUtils.getCategoryCount(CategoriesCheckBoxChooser.this.userGuid);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 && CategoriesCheckBoxChooser.this.isMultiple;
        }

        @Override
        public int getColumnCount() {
            if (CategoriesCheckBoxChooser.this.isMultiple) {
                return 2;
            }
            return 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0 && CategoriesCheckBoxChooser.this.isMultiple) {
                if (CategoriesCheckBoxChooser.this.categories != null && CategoriesCheckBoxChooser.this.categories.findCategoryIndex(CategoryUtils.getCategory(rowIndex, CategoriesCheckBoxChooser.this.userGuid)) > -1) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return CategoryUtils.getCategory(rowIndex, CategoriesCheckBoxChooser.this.userGuid).getName();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0 && CategoriesCheckBoxChooser.this.isMultiple) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0 && CategoriesCheckBoxChooser.this.isMultiple) {
                if (((Boolean)aValue).booleanValue()) {
                    CategoriesCheckBoxChooser.this.categories.addCategory(CategoryUtils.getCategory(rowIndex, CategoriesCheckBoxChooser.this.userGuid), CategoryListRecordStatusType.ADD);
                } else {
                    CategoriesCheckBoxChooser.this.categories.addCategory(CategoryUtils.getCategory(rowIndex, CategoriesCheckBoxChooser.this.userGuid), CategoryListRecordStatusType.REMOVE);
                    CategoriesCheckBoxChooser.this.categories.resetState();
                }
                CategoriesCheckBoxChooser.this.updateText();
            } else {
                CategoryUtils.getCategory(rowIndex, CategoriesCheckBoxChooser.this.userGuid).setName((String)aValue);
            }
        }
    }
}

