/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.GWExpandButton;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.MailSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.Notification;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.ItemSendOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ItemNotificationOptionPanel
extends AbstractOptionPanel {
    private GWExpandButton btnOne;
    private GWExpandButton btnTwo;
    private GWExpandButton btnThree;
    private GWExpandButton btnFour;
    private ComposeItemSendOptions composeItemSendOptions;
    private String itemType;

    public ItemNotificationOptionPanel(OptionChangesListener theChangesListener, MVCController theParentController, String itemType) {
        super(theChangesListener, theParentController);
        this.itemType = itemType;
        this.btnOne = new GWExpandButton(Notification.NOTIFICATION_LIST, this.itemListener);
        this.btnTwo = new GWExpandButton(Notification.NOTIFICATION_LIST, this.itemListener);
        this.btnThree = new GWExpandButton(Notification.NOTIFICATION_LIST, this.itemListener);
        this.btnFour = new GWExpandButton(Notification.NOTIFICATION_LIST, this.itemListener);
        this.btnOne.addItemListener(this.itemListener);
        this.btnTwo.addItemListener(this.itemListener);
        this.btnThree.addItemListener(this.itemListener);
        this.btnFour.addItemListener(this.itemListener);
        this.buildUI();
    }

    protected void build() {
    }

    private void buildUI() {
        this.removeAll();
        JPanel rightPanel = new JPanel(new GridBagLayout());
        JPanel leftPanel = new JPanel(new GridBagLayout());
        this.add(leftPanel);
        this.add(rightPanel);
        this.setLayout(new GridLayout(0, 2));
        this.setBorder(new TitledBorder(StringResources.RETURN_NOTIFICATION));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(10, 10, 5, 10);
        leftPanel.add((Component)new JMnemonicLabel(StringResources.WHEN_OPENED, this.btnOne), constraints);
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 10, 10, 10);
        leftPanel.add((Component)this.btnOne, constraints);
        constraints.gridy = 2;
        constraints.insets = new Insets(0, 10, 5, 10);
        if (this.itemType.equals(StringResources.MAIL_MESSAGES)) {
            leftPanel.add((Component)new JMnemonicLabel(StringResources.WHEN_DELETED, this.btnTwo), constraints);
        } else {
            leftPanel.add((Component)new JMnemonicLabel(StringResources.WHEN_DECLINED, this.btnTwo), constraints);
        }
        constraints.gridy = 3;
        constraints.insets = new Insets(0, 10, 10, 10);
        leftPanel.add((Component)this.btnTwo, constraints);
        if (this.itemType.equals(StringResources.MAIL_MESSAGES)) {
            return;
        }
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(10, 10, 5, 10);
        rightPanel.add((Component)new JMnemonicLabel(StringResources.WHEN_ACCEPTED, this.btnThree), constraints);
        constraints.weighty = 1.0;
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 10, 10, 10);
        rightPanel.add((Component)this.btnThree, constraints);
        if (!this.itemType.equals(StringResources.TASKS)) {
            return;
        }
        constraints.gridy = 2;
        constraints.insets = new Insets(0, 10, 5, 10);
        rightPanel.add((Component)new JMnemonicLabel(StringResources.WHEN_COMPLETED, this.btnFour), constraints);
        constraints.gridy = 3;
        constraints.insets = new Insets(0, 10, 10, 10);
        rightPanel.add((Component)this.btnFour, constraints);
    }

    public void collectValues() {
        if (this.itemType.equals(StringResources.MAIL_MESSAGES)) {
            this.composeItemSendOptions.setRNWhenOpened((Notification)this.btnOne.getSelectedItem());
        } else if (this.itemType.equals(StringResources.APPOINTMENTS) || this.itemType.equals(StringResources.TASKS) || this.itemType.equals(StringResources.NOTES)) {
            // empty if block
        }
    }

    public void fireOptionsChanged() {
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    public void setReturnNotifications(ComposeItemSendOptions sendOptions) {
        this.composeItemSendOptions = sendOptions;
        this.btnOne.setSelectedItem(sendOptions.getRNWhenOpened());
        this.btnTwo.setSelectedItem(sendOptions.getRNWhenDeclined());
        this.btnThree.setSelectedItem(sendOptions.getRNWhenAccept());
        this.btnFour.setSelectedItem(sendOptions.getRNWhenCompleted());
        if (sendOptions instanceof MailSendOptions) {
            this.btnTwo.setSelectedItem(sendOptions.getRNWhenDeleted());
        }
    }

    public void readReturnNotifications(ItemSendOptions itemSendOptions) {
        if (this.itemType.equals(StringResources.MAIL_MESSAGES)) {
            itemSendOptions.setRNMailOpened((Notification)this.btnOne.getSelectedItem());
            itemSendOptions.setRNMailDeleted((Notification)this.btnTwo.getSelectedItem());
        } else if (this.itemType.equals(StringResources.APPOINTMENTS)) {
            itemSendOptions.setRNAppOpened((Notification)this.btnOne.getSelectedItem());
            itemSendOptions.setRNAppAccepted((Notification)this.btnThree.getSelectedItem());
            itemSendOptions.setRNAppDeclined((Notification)this.btnTwo.getSelectedItem());
        } else if (this.itemType.equals(StringResources.TASKS)) {
            itemSendOptions.setRNTaskOpened((Notification)this.btnOne.getSelectedItem());
            itemSendOptions.setRNTaskDeclined((Notification)this.btnTwo.getSelectedItem());
            itemSendOptions.setRNTaskAccepted((Notification)this.btnThree.getSelectedItem());
            itemSendOptions.setRNTaskCompleted((Notification)this.btnFour.getSelectedItem());
        } else if (this.itemType.equals(StringResources.NOTES)) {
            itemSendOptions.setRNNoteOpened((Notification)this.btnOne.getSelectedItem());
            itemSendOptions.setRNNoteDeclined((Notification)this.btnTwo.getSelectedItem());
            itemSendOptions.setRNNoteAccepted((Notification)this.btnThree.getSelectedItem());
        }
    }
}

