/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.sendoptions.AppSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.MailSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.NoteSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.Notification;
import com.novell.gw.jclient.bl.om.items.sendoptions.TaskSendOptions;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.ItemSendOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

class ReturnNotificationPane
extends AbstractOptionPanel {
    private static Logger logger = Logger.getLogger(ReturnNotificationPane.class);
    private RNPane pnlMail;
    private RNPane pnlApp;
    private RNPane pnlTask;
    private RNPane pnlNote;
    private ItemSendOptions itemSendOptions;
    private static Insets INSETS_55 = new Insets(5, 5, 5, 5);
    private static Insets INSETS_05 = new Insets(0, 5, 5, 5);

    public ReturnNotificationPane(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        this.setName(StringResources.RETURN_NOTIFICATION);
    }

    protected void build() {
        this.pnlApp = ReturnNotificationPane.createAppPane(this.changesListener);
        this.pnlMail = ReturnNotificationPane.createMailPane(this.changesListener);
        this.pnlNote = ReturnNotificationPane.createNotePane(this.changesListener);
        this.pnlTask = ReturnNotificationPane.createTaskPane(this.changesListener);
        OrientablePanel content = new OrientablePanel(new GridLayout(2, 2, 7, 9));
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        content.add(this.pnlMail);
        content.add(this.pnlTask);
        content.add(this.pnlApp);
        content.add(this.pnlNote);
        this.setLayout(new BorderLayout());
        this.add((Component)content, "North");
    }

    public void collectValues() {
        this.pnlApp.readReturnNotifications(this.itemSendOptions);
        this.pnlMail.readReturnNotifications(this.itemSendOptions);
        this.pnlNote.readReturnNotifications(this.itemSendOptions);
        this.pnlTask.readReturnNotifications(this.itemSendOptions);
    }

    public void fireOptionsChanged() {
        this.pnlApp.setReturnNotifications(new AppSendOptions(this.itemSendOptions));
        this.pnlMail.setReturnNotifications(new MailSendOptions(this.itemSendOptions));
        this.pnlNote.setReturnNotifications(new NoteSendOptions(this.itemSendOptions));
        this.pnlTask.setReturnNotifications(new TaskSendOptions(this.itemSendOptions));
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
        if (!(theAbstractOptions instanceof ItemSendOptions)) {
            throw new IllegalArgumentException("instance of ItemSendOptions expected.");
        }
        this.itemSendOptions = (ItemSendOptions)theAbstractOptions;
        this.fireOptionsChanged();
    }

    static RNPane createMailPane(OptionChangesListener theChangesListener) {
        final NotificationComboBox ncmbMailOpen = ReturnNotificationPane.createCombo(theChangesListener);
        final NotificationComboBox ncmbMailDelete = ReturnNotificationPane.createCombo(theChangesListener);
        RNPane content = new RNPane(new GridBagLayout()){

            public void setReturnNotifications(ComposeItemSendOptions iso) {
                ncmbMailOpen.setNotification(iso.getRNWhenOpened());
                ncmbMailDelete.setNotification(iso.getRNWhenDeleted());
            }

            public void readReturnNotifications(ComposeItemSendOptions iso) {
                iso.setRNWhenOpened(ncmbMailOpen.getNotification());
                iso.setRNWhenDeleted(ncmbMailDelete.getNotification());
            }

            public void readReturnNotifications(ItemSendOptions iso) {
                iso.setRNMailDeleted(ncmbMailDelete.getNotification());
                iso.setRNMailOpened(ncmbMailOpen.getNotification());
            }
        };
        ImprovedLabel lbOpened = new ImprovedLabel(StringResources.WHEN_OPENED, ncmbMailOpen);
        ImprovedLabel lbDeleted = new ImprovedLabel(StringResources.WHEN_DELETED, ncmbMailDelete);
        content.setBorder(new TitledBorder(StringResources.MAIL));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.weightx = 1.0;
        ReturnNotificationPane.putComponents(content, c, new Component[]{lbOpened, ncmbMailOpen, lbDeleted, ncmbMailDelete}, new int[]{0, 0, 1, 1}, new int[]{0, 1, 0, 1}, new Insets[]{INSETS_55, INSETS_05, INSETS_55, INSETS_05});
        c.weighty = 1.0;
        ++c.gridy;
        content.add((Component)new JPanel(), c);
        return content;
    }

    static RNPane createAppPane(OptionChangesListener theChangesListener) {
        final NotificationComboBox ncmbAppOpen = ReturnNotificationPane.createCombo(theChangesListener);
        final NotificationComboBox ncmbAppDecline = ReturnNotificationPane.createCombo(theChangesListener);
        final NotificationComboBox ncmbAppAccept = ReturnNotificationPane.createCombo(theChangesListener);
        RNPane content = new RNPane(new GridBagLayout()){

            public void setReturnNotifications(ComposeItemSendOptions iso) {
                ncmbAppAccept.setNotification(iso.getRNWhenAccept());
                ncmbAppDecline.setNotification(iso.getRNWhenDeclined());
                ncmbAppOpen.setNotification(iso.getRNWhenOpened());
            }

            public void readReturnNotifications(ComposeItemSendOptions iso) {
                iso.setRNWhenAccept(ncmbAppAccept.getNotification());
                iso.setRNWhenDeclined(ncmbAppDecline.getNotification());
                iso.setRNWhenOpened(ncmbAppOpen.getNotification());
            }

            public void readReturnNotifications(ItemSendOptions iso) {
                iso.setRNAppAccepted(ncmbAppAccept.getNotification());
                iso.setRNAppDeclined(ncmbAppDecline.getNotification());
                iso.setRNAppOpened(ncmbAppOpen.getNotification());
            }
        };
        ImprovedLabel lbOpened = new ImprovedLabel(StringResources.WHEN_OPENED, ncmbAppOpen);
        ImprovedLabel lbDeclined = new ImprovedLabel(StringResources.WHEN_DECLINED, ncmbAppDecline);
        ImprovedLabel lbAccepted = new ImprovedLabel(StringResources.WHEN_ACCEPTED, ncmbAppAccept);
        UIUtils.updateLabelHeight(lbOpened);
        UIUtils.updateLabelHeight(lbDeclined);
        UIUtils.updateLabelHeight(lbAccepted);
        TitledBorder border = BorderFactory.createTitledBorder(StringResources.APPOINTMENT);
        content.setBorder(border);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.weightx = 1.0;
        ReturnNotificationPane.putComponents(content, c, new Component[]{lbOpened, ncmbAppOpen, lbDeclined, ncmbAppDecline, lbAccepted, ncmbAppAccept}, new int[]{0, 0, 1, 1, 0, 0}, new int[]{0, 1, 0, 1, 2, 3}, new Insets[]{INSETS_55, INSETS_05, INSETS_55, INSETS_05, INSETS_55, INSETS_05});
        return content;
    }

    static RNPane createTaskPane(OptionChangesListener theChangesListener) {
        final NotificationComboBox ncmbTaskOpen = ReturnNotificationPane.createCombo(theChangesListener);
        final NotificationComboBox ncmbTaskDecline = ReturnNotificationPane.createCombo(theChangesListener);
        final NotificationComboBox ncmbTaskAccept = ReturnNotificationPane.createCombo(theChangesListener);
        final NotificationComboBox ncmbTaskComplete = ReturnNotificationPane.createCombo(theChangesListener);
        RNPane content = new RNPane(new GridBagLayout()){

            public void setReturnNotifications(ComposeItemSendOptions iso) {
                ncmbTaskAccept.setNotification(iso.getRNWhenAccept());
                ncmbTaskComplete.setNotification(iso.getRNWhenCompleted());
                ncmbTaskDecline.setNotification(iso.getRNWhenDeclined());
                ncmbTaskOpen.setNotification(iso.getRNWhenOpened());
            }

            public void readReturnNotifications(ComposeItemSendOptions iso) {
                iso.setRNWhenAccept(ncmbTaskAccept.getNotification());
                iso.setRNWhenCompleted(ncmbTaskComplete.getNotification());
                iso.setRNWhenDeclined(ncmbTaskDecline.getNotification());
                iso.setRNWhenOpened(ncmbTaskOpen.getNotification());
            }

            public void readReturnNotifications(ItemSendOptions iso) {
                iso.setRNTaskAccepted(ncmbTaskAccept.getNotification());
                iso.setRNTaskCompleted(ncmbTaskComplete.getNotification());
                iso.setRNTaskDeclined(ncmbTaskDecline.getNotification());
                iso.setRNTaskOpened(ncmbTaskOpen.getNotification());
            }
        };
        ImprovedLabel lbOpened = new ImprovedLabel(StringResources.WHEN_OPENED, ncmbTaskOpen);
        ImprovedLabel lbDecline = new ImprovedLabel(StringResources.WHEN_DECLINED, ncmbTaskDecline);
        ImprovedLabel lbAccepted = new ImprovedLabel(StringResources.WHEN_ACCEPTED, ncmbTaskAccept);
        ImprovedLabel lbCompleted = new ImprovedLabel(StringResources.WHEN_COMPLETED, ncmbTaskComplete);
        TitledBorder border = BorderFactory.createTitledBorder(StringResources.TASK);
        content.setBorder(border);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.weightx = 1.0;
        ReturnNotificationPane.putComponents(content, c, new Component[]{lbOpened, ncmbTaskOpen, lbDecline, ncmbTaskDecline, lbAccepted, ncmbTaskAccept, lbCompleted, ncmbTaskComplete}, new int[]{0, 0, 1, 1, 0, 0, 1, 1}, new int[]{0, 1, 0, 1, 2, 3, 2, 3}, new Insets[]{INSETS_55, INSETS_05, INSETS_55, INSETS_05, INSETS_55, INSETS_05, INSETS_55, INSETS_05});
        return content;
    }

    static RNPane createNotePane(OptionChangesListener theChangesListener) {
        final NotificationComboBox ncmbNoteOpen = ReturnNotificationPane.createCombo(theChangesListener);
        final NotificationComboBox ncmbNoteDecline = ReturnNotificationPane.createCombo(theChangesListener);
        final NotificationComboBox ncmbNoteAccept = ReturnNotificationPane.createCombo(theChangesListener);
        RNPane content = new RNPane(new GridBagLayout()){

            public void setReturnNotifications(ComposeItemSendOptions iso) {
                ncmbNoteAccept.setNotification(iso.getRNWhenAccept());
                ncmbNoteDecline.setNotification(iso.getRNWhenDeclined());
                ncmbNoteOpen.setNotification(iso.getRNWhenOpened());
            }

            public void readReturnNotifications(ComposeItemSendOptions iso) {
                iso.setRNWhenAccept(ncmbNoteAccept.getNotification());
                iso.setRNWhenDeclined(ncmbNoteDecline.getNotification());
                iso.setRNWhenOpened(ncmbNoteOpen.getNotification());
            }

            public void readReturnNotifications(ItemSendOptions iso) {
                iso.setRNNoteAccepted(ncmbNoteAccept.getNotification());
                iso.setRNNoteDeclined(ncmbNoteDecline.getNotification());
                iso.setRNNoteOpened(ncmbNoteOpen.getNotification());
            }
        };
        ImprovedLabel lbOpened = new ImprovedLabel(StringResources.WHEN_OPENED, ncmbNoteOpen);
        ImprovedLabel lbDeclined = new ImprovedLabel(StringResources.WHEN_DECLINED, ncmbNoteDecline);
        ImprovedLabel lbAccepted = new ImprovedLabel(StringResources.WHEN_ACCEPTED, ncmbNoteAccept);
        TitledBorder border = BorderFactory.createTitledBorder(StringResources.NOTE);
        content.setBorder(border);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.weightx = 1.0;
        ReturnNotificationPane.putComponents(content, c, new Component[]{lbOpened, ncmbNoteOpen, lbDeclined, ncmbNoteDecline, lbAccepted, ncmbNoteAccept}, new int[]{0, 0, 1, 1, 0, 0}, new int[]{0, 1, 0, 1, 2, 3}, new Insets[]{INSETS_55, INSETS_05, INSETS_55, INSETS_05, INSETS_55, INSETS_05});
        return content;
    }

    private static void putComponents(Container theContainer, GridBagConstraints theConstraints, Component[] theComponents, int[] x, int[] y, Insets[] theInsets) {
        for (int i = 0; i < theComponents.length; ++i) {
            theConstraints.fill = theComponents[i] instanceof JLabel ? 0 : 2;
            theConstraints.gridx = x[i];
            theConstraints.gridy = y[i];
            theConstraints.insets = theInsets[i];
            theContainer.add(theComponents[i], theConstraints);
        }
    }

    private static NotificationComboBox createCombo(final OptionChangesListener theChangesListener) {
        NotificationComboBox ncmb = new NotificationComboBox(Notification.NOTIFICATION_LIST);
        ncmb.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (theChangesListener != null) {
                    theChangesListener.setValueChanged();
                }
            }
        });
        return ncmb;
    }

    protected static class NotificationComboBox
    extends OrientableComboBox {
        public NotificationComboBox(Notification[] items) {
            super(items);
        }

        public void setNotification(Notification theNotification) {
            this.setSelectedItem(theNotification);
            this.setEnabled(!theNotification.isLocked());
        }

        public Notification getNotification() {
            if (this.getSelectedIndex() >= 0) {
                return (Notification)this.getSelectedItem();
            }
            return Notification.NONE;
        }
    }

    protected static abstract class RNPane
    extends OrientablePanel {
        public RNPane(LayoutManager layout) {
            super(layout);
        }

        public abstract void setReturnNotifications(ComposeItemSendOptions var1);

        public abstract void readReturnNotifications(ComposeItemSendOptions var1);

        public abstract void readReturnNotifications(ItemSendOptions var1);
    }

    private static class ImprovedLabel
    extends JMnemonicLabel {
        public ImprovedLabel(String text, Component theComponent) {
            super(text, theComponent);
            UIUtils.updateLabelHeight(this);
        }
    }
}

