/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.search;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTree;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeModelUtils;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeRendererColor;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import java.awt.Rectangle;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PlainFoldersTree
extends GWFoldersTree {
    private int tree_row_height;
    protected String userGuid;
    private boolean refreshBlocked = false;
    private boolean allowModify = false;
    protected GWFoldersTreeRendererColor renderer;

    public PlainFoldersTree(MVCController parentController, String userGuid) {
        super(parentController, userGuid);
        this.userGuid = userGuid;
        this.renderer = new GWFoldersTreeRendererColor();
        this.renderer.setTreeFocused(true);
        this.setCellRenderer(this.renderer);
        this.tree_row_height = this.cellRenderer instanceof JComponent ? ((JComponent)((Object)this.cellRenderer)).getPreferredSize().height : this.getRowHeight();
        this.allowModify = GWCommandManager.getInstance(userGuid).getCurrentDataStore().checkAccess(DataStoreAccessRequestType.ITEM_CREATE, ItemType.FOLDER, 0);
    }

    public String getUIClassID() {
        if (PLAFChanger.isCustomFolderTreeUIUsed()) {
            return "FoldersTreeInDialogUI";
        }
        return super.getUIClassID();
    }

    public void selectFolder(AbstractFolder theFolder) {
        DefaultMutableTreeNode folderNode = GWFoldersTreeModelUtils.getFolderTreeNode((DefaultMutableTreeNode)this.getModel().getRoot(), theFolder);
        if (folderNode != null) {
            TreePath treePath = new TreePath(folderNode.getPath());
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
        } else {
            this.selectFolder(FoldersCache.getMailboxFolder(this.userGuid));
        }
    }

    public DefaultMutableTreeNode getFolderNode(AbstractFolder folder) {
        return GWFoldersTreeModelUtils.getFolderTreeNode((DefaultMutableTreeNode)this.getModel().getRoot(), folder);
    }

    public void expandFolder(AbstractFolder theFolder) {
        this.expandPath(new TreePath(this.getFolderNode(theFolder).getPath()));
    }

    public AbstractFolder getSelectedFolder() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
        return (AbstractFolder)node.getUserObject();
    }

    public void scrollFolderToBottom(AbstractFolder folder) {
        DefaultMutableTreeNode folderNode = this.getFolderNode(folder);
        Rectangle pathBounds = this.getPathBounds(new TreePath(folderNode.getPath()));
        if (pathBounds == null) {
            pathBounds = new Rectangle();
        }
        int y1 = Math.abs(this.getVisibleRect().height - this.tree_row_height);
        pathBounds.setLocation(pathBounds.x, pathBounds.y - y1);
        this.scrollRectToVisible(pathBounds);
    }

    public void refreshTree(boolean doReload) {
        if (this.refreshBlocked) {
            return;
        }
        TreeSelectionListener[] treeSelectionListeners = this.getTreeSelectionListeners();
        for (int i = 0; i < treeSelectionListeners.length; ++i) {
            TreeSelectionListener treeSelectionListener = treeSelectionListeners[i];
            this.removeTreeSelectionListener(treeSelectionListener);
        }
        AbstractFolder selectedFolder = this.getSelectedFolder();
        super.refreshTree(doReload);
        this.selectFolder(selectedFolder);
        for (int i = 0; i < treeSelectionListeners.length; ++i) {
            TreeSelectionListener treeSelectionListener = treeSelectionListeners[i];
            this.getSelectionModel().addTreeSelectionListener(treeSelectionListener);
        }
    }

    public void moveUpFolder(AbstractFolder folder) {
        DefaultMutableTreeNode folderNode = this.getFolderNode(folder);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)folderNode.getParent();
        int index = parent.getIndex(folderNode);
        parent.remove(folderNode);
        parent.insert(folderNode, --index);
        this.updateFolderNode(parent, folder);
    }

    public void moveDownFolder(AbstractFolder folder) {
        DefaultMutableTreeNode folderNode = this.getFolderNode(folder);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)folderNode.getParent();
        int index = parent.getIndex(folderNode);
        parent.remove(folderNode);
        parent.insert(folderNode, ++index);
        this.updateFolderNode(parent, folder);
    }

    public void moveLeftFolder(AbstractFolder folder) {
        DefaultMutableTreeNode folderNode = this.getFolderNode(folder);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)folderNode.getParent();
        DefaultMutableTreeNode where = (DefaultMutableTreeNode)parent.getParent();
        int index = where.getIndex(parent);
        parent.remove(folderNode);
        where.insert(folderNode, ++index);
        this.collapsePath(this.getPathForRow(index));
        this.updateFolderNode(parent, folder);
    }

    public void moveRightFolder(AbstractFolder folder) {
        DefaultMutableTreeNode folderNode = this.getFolderNode(folder);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)folderNode.getParent();
        DefaultMutableTreeNode where = (DefaultMutableTreeNode)parent.getChildBefore(folderNode);
        parent.remove(folderNode);
        where.insert(folderNode, 0);
        this.updateFolderNode(parent, folder);
    }

    public void updateFolderNode(TreeNode treeNode, AbstractFolder folder) {
        ((DefaultTreeModel)this.getModel()).nodeChanged(treeNode);
        this.updateUI();
        this.selectFolder(folder);
    }

    public void enableActions(AbstractFolder folder, AbstractAction actionUp, AbstractAction actionDown, AbstractAction actionRight, AbstractAction actionLeft) {
        DefaultMutableTreeNode folderNode;
        DefaultMutableTreeNode parent;
        boolean upEnabled = false;
        boolean downEnabled = false;
        boolean rightEnabled = false;
        boolean leftEnabled = false;
        if (this.allowModify && (parent = (DefaultMutableTreeNode)(folderNode = this.getFolderNode(folder)).getParent()) != null) {
            IFolder nativeFolder = folder.getNativeFolder();
            boolean nntpNewsgroupFolder = nativeFolder != null && nativeFolder.getType() == FolderType.NNTP_NEWSGROUP;
            int index = parent.getIndex(folderNode);
            upEnabled = index != 0;
            boolean bl = downEnabled = index < parent.getChildCount() - 1;
            if (!nntpNewsgroupFolder) {
                AbstractFolder parentFolder;
                if (index != 0) {
                    DefaultMutableTreeNode target;
                    boolean bl2 = rightEnabled = (folder = (AbstractFolder)(target = (DefaultMutableTreeNode)parent.getChildAt(--index)).getUserObject()).canHaveChildren() && !folder.isCalendarFolder();
                }
                if ((parentFolder = folder.getParent()) == null || !(parentFolder instanceof CalendarFolder)) {
                    leftEnabled = !parent.equals(this.getModel().getRoot());
                }
            }
        }
        actionUp.setEnabled(upEnabled);
        actionDown.setEnabled(downEnabled);
        actionRight.setEnabled(rightEnabled);
        actionLeft.setEnabled(leftEnabled);
    }

    public boolean isRefreshBlocked() {
        return this.refreshBlocked;
    }

    public void setRefreshBlocked(boolean refreshBlocked) {
        this.refreshBlocked = refreshBlocked;
    }

    public class TreeSetEditableListener
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            AbstractFolder f = null;
            if (e.getSource() instanceof DefaultTreeSelectionModel && ((DefaultTreeSelectionModel)e.getSource()).getSelectionPath() != null) {
                f = (AbstractFolder)((DefaultMutableTreeNode)((DefaultTreeSelectionModel)e.getSource()).getSelectionPath().getLastPathComponent()).getUserObject();
            } else if (e.getSource() instanceof JTree && ((JTree)e.getSource()).getSelectionPath() != null) {
                f = (AbstractFolder)((DefaultMutableTreeNode)((JTree)e.getSource()).getSelectionPath().getLastPathComponent()).getUserObject();
            }
            if (f == null) {
                PlainFoldersTree.this.setEditable(false);
            } else {
                PlainFoldersTree.this.setEditable(f.canRename());
            }
        }
    }
}

