/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify;

import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.NotificationItem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class AudioPlayer {
    private static Logger logger = Logger.getLogger(AudioPlayer.class);
    private SourceDataLine sourceDataLine;
    private NotificationItem notificationItem;
    private boolean ready = false;
    AudioInputStream audioInputStream;

    private boolean init(AudioInputStream audioInputStream, NotificationItem notificationItem) throws UnsupportedAudioFileException, IOException {
        if (notificationItem == null) {
            throw new IllegalArgumentException("notificationId is null");
        }
        this.notificationItem = notificationItem;
        try {
            DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, audioInputStream.getFormat());
            Line line = AudioSystem.getLine(dataLineInfo);
            this.audioInputStream = audioInputStream;
            this.sourceDataLine = (SourceDataLine)line;
            this.sourceDataLine.addLineListener(new StopLineListener());
            this.sourceDataLine.open(this.audioInputStream.getFormat());
            this.ready = true;
        }
        catch (LineUnavailableException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        if (!this.ready) {
            this.release();
        }
        return this.ready;
    }

    public boolean init(InputStream inputStream, NotificationItem notificationItem) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            return this.init(AudioSystem.getAudioInputStream(bufferedInputStream), notificationItem);
        }
        catch (UnsupportedAudioFileException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return false;
    }

    public boolean init(String pathToSoundFile, NotificationItem notificationItem) {
        if (pathToSoundFile == null) {
            throw new IllegalArgumentException("pathToSoundFile is null");
        }
        File file = new File(pathToSoundFile);
        if (!file.exists()) {
            logger.warn((Object)("audio file does not found: " + pathToSoundFile));
            String message = StringResources.formatString(StringResources.FILE_DOES_NOT_EXIST, pathToSoundFile);
            JOptionPane.showMessageDialog(null, message, StringResources.GROUP_WISE_NOTIFY, 0);
        } else {
            try {
                return this.init(AudioSystem.getAudioInputStream(file), notificationItem);
            }
            catch (UnsupportedAudioFileException e) {
                logger.error((Object)e);
                JOptionPane.showMessageDialog(null, StringResources.UNSUPPORTED_AUDIO_FILE, StringResources.GROUP_WISE_NOTIFY, 0);
            }
            catch (IOException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
                String message = e.getMessage();
                if (Utils.isNullOrEmpty(message)) {
                    message = StringResources.UNSUPPORTED_AUDIO_FILE;
                }
                JOptionPane.showMessageDialog(null, message, StringResources.GROUP_WISE_NOTIFY, 0);
            }
        }
        return false;
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isPlaying() {
        return this.ready && this.sourceDataLine != null && this.sourceDataLine.isRunning();
    }

    public void play() throws IllegalStateException {
        if (!this.ready) {
            throw new IllegalStateException("not ready to play audiofile");
        }
        this.sourceDataLine.start();
        byte[] tempBuffer = new byte[10000];
        try {
            int cnt;
            while ((cnt = this.audioInputStream.read(tempBuffer, 0, tempBuffer.length)) != -1) {
                if (cnt <= 0) continue;
                this.sourceDataLine.write(tempBuffer, 0, cnt);
            }
            Thread t = new Thread(){

                public void run() {
                    AudioPlayer.this.sourceDataLine.drain();
                    AudioPlayer.this.stop();
                }
            };
            t.start();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    public void stop() {
        if (!this.ready) {
            throw new IllegalStateException("sourceDataLine is not initialized");
        }
        if (this.sourceDataLine.isRunning()) {
            this.sourceDataLine.stop();
        } else {
            this.release();
        }
        logger.debug((Object)"stopped");
    }

    private void release() {
        if (this.sourceDataLine != null) {
            this.sourceDataLine.close();
            logger.debug((Object)"sourceDataLine closed");
        }
        logger.debug((Object)"released");
    }

    public void terminate() {
        if (this.notificationItem != null) {
            if (this.isPlaying()) {
                this.stop();
            } else {
                this.release();
            }
        }
    }

    protected void finalize() throws Throwable {
        logger.debug((Object)"finalizing...");
    }

    private class StopLineListener
    implements LineListener {
        private StopLineListener() {
        }

        public void update(LineEvent event) {
            if (event.getType().equals(LineEvent.Type.STOP)) {
                AudioPlayer.this.release();
            }
        }
    }
}

