/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify;

import com.novell.gw.jclient.application.resources.StringResources;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FileChooserUtils {
    private static Logger logger = Logger.getLogger(FileChooserUtils.class);
    private static JFileChooser fcSounds = new JFileChooser();
    private static JFileChooser fcPrograms = new JFileChooser();

    public static String getFileExtension(File file) {
        String ext = null;
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0 && i < name.length() - 1) {
            ext = name.substring(i + 1);
        }
        return ext;
    }

    public static JFileChooser getSoundFileChooser() {
        return fcSounds;
    }

    public static JFileChooser getProgramFileChooser() {
        return fcPrograms;
    }

    public static String checkProgramFile(String pathToFile) {
        File file = new File(pathToFile);
        if (file.exists()) {
            return null;
        }
        return StringResources.formatString(StringResources.FILE_DOES_NOT_EXIST, pathToFile);
    }

    public static String checkSoundFile(String pathToFile) {
        if ("<BEEP>".equals(pathToFile)) {
            return null;
        }
        File file = new File(pathToFile);
        if (file.exists()) {
            try {
                AudioSystem.getAudioFileFormat(file);
            }
            catch (UnsupportedAudioFileException e) {
                return StringResources.UNSUPPORTED_AUDIO_FILE;
            }
            catch (IOException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
                return e.getMessage();
            }
            return null;
        }
        return StringResources.formatString(StringResources.FILE_DOES_NOT_EXIST, pathToFile);
    }

    static {
        fcSounds.setFileFilter(new SoundFileFilter());
        fcSounds.setAcceptAllFileFilterUsed(false);
        fcPrograms.setFileFilter(new ProgramFileFilter());
        fcPrograms.setAcceptAllFileFilterUsed(false);
    }

    private static class ProgramFileFilter
    extends FileFilter {
        private ProgramFileFilter() {
        }

        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            return true;
        }

        public String getDescription() {
            return StringResources.PROGRAMS;
        }
    }

    private static class SoundFileFilter
    extends FileFilter {
        private static String[] SUPPORTED_AUDIO_EXTENSIONS = new String[]{"wav", "au"};

        private SoundFileFilter() {
        }

        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            for (String extension : SUPPORTED_AUDIO_EXTENSIONS) {
                if (!extension.equalsIgnoreCase(FileChooserUtils.getFileExtension(pathname))) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            StringBuilder builder = new StringBuilder(StringResources.SOUND_FILES);
            builder.append(" (");
            int length = SUPPORTED_AUDIO_EXTENSIONS.length;
            for (int i = 0; i < length; ++i) {
                builder.append(SUPPORTED_AUDIO_EXTENSIONS[i]);
                if (i == length - 1) continue;
                builder.append(",");
            }
            builder.append(")");
            return builder.toString();
        }
    }
}

