/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.ControllerManager;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.notify.FakeSystemTrayFrame;
import com.novell.gw.jclient.application.notify.NotificationProcessor;
import com.novell.gw.jclient.application.notify.NotifyActionList;
import com.novell.gw.jclient.application.notify.NotifyTrayIcon;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWNotify;
import com.novell.gw.jclient.bl.om.items.NotificationItem;
import com.novell.gw.notification.NotifyEvent;
import com.novell.gw.notification.NotifyListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class NotifyController
extends MVCController
implements NotifyListener {
    private static Logger logger = Logger.getLogger(NotifyController.class);
    private NotificationProcessor notificationProcessor;

    public NotifyController(Level parentLevel) {
        super(parentLevel);
        logger.debug((Object)("level: " + this.getLevel()));
        this.notificationProcessor = new NotificationProcessor();
        this.buildUI();
        NotifyActionList actionList = this.getNotifyActionList();
        if (actionList != null) {
            actionList.updateViewVisibility();
        }
        logger.debug((Object)("adding NotifyListener: " + this));
        GWNotify.getInstance().addNotifyListener(this);
        int numberOfNotifications = GWNotify.getInstance().getNotificationItems().size();
        GlobalCommand commandSize = new GlobalCommand(1520, numberOfNotifications);
        this.processCommand(commandSize);
    }

    private void buildUI() {
        logger.debug((Object)"Checking support for System Tray...");
        boolean systemTraySupported = OS.isTrayIconSupported();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Tray icon is " + (systemTraySupported ? "" : "NOT ") + "supported for: java vendor (" + (Object)((Object)OS.getJavaVendor()) + ") / version (" + System.getProperty("java.version") + ")"));
        }
        if (systemTraySupported) {
            try {
                systemTraySupported = false;
                Class<?> systemTrayClass = Class.forName("java.awt.SystemTray");
                systemTraySupported = (Boolean)systemTrayClass.getMethod("isSupported", null).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        }
        logger.debug((Object)("System Tray is " + (systemTraySupported ? "IS" : "IS NOT") + " supported"));
        if (systemTraySupported) {
            systemTraySupported = this.buildTrayIcon();
            logger.debug((Object)("building tray icon " + (systemTraySupported ? "succeeded" : "failed")));
        }
        if (!systemTraySupported) {
            logger.warn((Object)"Substituting tray icon with frame");
            FakeSystemTrayFrame frame = new FakeSystemTrayFrame(this);
            frame.pack();
        }
    }

    private boolean buildTrayIcon() {
        logger.debug((Object)"Trying to build Tray icon...");
        boolean methodSucceded = false;
        try {
            new NotifyTrayIcon(this);
            methodSucceded = true;
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return methodSucceded;
    }

    protected void initListeners() {
        super.initListeners();
        Level level = this.getLevel();
        EXIT_NOTIFY_Listener listener = new EXIT_NOTIFY_Listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 1480, listener);
        this.addListenerDescriptor(descriptor);
    }

    public String getUserGuid() {
        return EngineCommandManager.getUserGuid();
    }

    public void notification(NotifyEvent e) {
        if (logger.isDebugEnabled()) {
            switch (e.getType()) {
                case 0: {
                    String type = "NEW_ALARM";
                    break;
                }
                case 1: {
                    String type = "NEW_ITEM";
                    break;
                }
                case 2: {
                    String type = "LIST_CHANGED";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected event type: " + e.getType());
                }
            }
        }
        if (e.getType() == 0 || e.getType() == 1) {
            NotificationItem item = new NotificationItem(e.getNotifyItem());
            this.notificationProcessor.offer(item);
        }
        if (e.getType() == 2) {
            int numberOfNotifications = GWNotify.getInstance().getNotificationItems().size();
            GlobalCommand commandSize = new GlobalCommand(1520, numberOfNotifications);
            this.processCommand(commandSize);
        }
    }

    public NotifyActionList getNotifyActionList() {
        List<Level> childLevels = this.getLevel().getChildren();
        for (Level level : childLevels) {
            MVCController childController = ControllerManager.getInstance().get(level);
            if (!(childController instanceof NotifyActionList)) continue;
            return (NotifyActionList)childController;
        }
        logger.warn((Object)"Child NotifyActionList was not found!");
        return null;
    }

    public void closeAllNotificationDialogs() {
        this.notificationProcessor.clear();
    }

    public void notificationDialogClosed(NotificationItem item, boolean byUser) {
        logger.debug((Object)("dialog closed, byUser: " + byUser));
        if (this.notificationProcessor.isDead()) {
            logger.debug((Object)"notificationProcessor is dead");
            return;
        }
        this.notificationProcessor.updatePricessingNotificationStatus(item, byUser, null);
    }

    private class EXIT_NOTIFY_Listener
    extends AppEventListener {
        private EXIT_NOTIFY_Listener() {
        }

        public void handle(AppEvent theEvent) {
            logger.debug((Object)("Exit notify in notify controller (" + (SwingUtilities.isEventDispatchThread() ? "" : "not ") + "EDT)"));
            NotifyController.this.notificationProcessor.die();
            logger.debug((Object)("removing NotifyListener: " + NotifyController.this));
            GWNotify.getInstance().removeNotifyListener(NotifyController.this);
            GWNotify.getInstance().clearInstance();
        }
    }
}

