/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.dialogs.options;

import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.notify.dialogs.options.NotifyOptionsDialog;
import com.novell.gw.jclient.application.notify.dialogs.options.NotifyOptionsDialogTabPane;
import com.novell.gw.jclient.application.notify.dialogs.options.SettingsPanel;
import com.novell.gw.jclient.application.notify.dialogs.options.SettingsPanelModel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWNotify;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import org.apache.log4j.Logger;

public class AlarmsPane
extends OrientablePanel
implements NotifyOptionsDialogTabPane {
    private static Logger logger = Logger.getLogger(AlarmsPane.class);
    private NotifyOptionsDialog dialog;
    private SettingsPanel pnlAlarmsSettings;
    private SettingsPanelModel panelModel;

    public AlarmsPane(NotifyOptionsDialog dialog) {
        this.dialog = dialog;
    }

    public void applyOptions() {
        logger.debug((Object)"applying options...");
        this.pnlAlarmsSettings.updateModel();
        if (this.panelModel.isModified()) {
            GWNotify.getInstance().setAlarmSettingsPanelModel(this.panelModel);
            this.panelModel.reset();
        }
    }

    public void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panelModel = GWNotify.getInstance().getAlarmSettingsPanelModel();
        this.pnlAlarmsSettings = new SettingsPanel(StringResources.ALARM_SETTINGS);
        this.pnlAlarmsSettings.buildUI();
        this.pnlAlarmsSettings.buildDefaultBorder();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 19;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.pnlAlarmsSettings, c);
    }

    public String getTitle() {
        return StringResources.ALARMS;
    }

    public void init() {
        this.pnlAlarmsSettings.setModel(this.panelModel);
    }

    public void resetToDefaults() {
        this.panelModel = GWNotify.getInstance().getDefaultAlarmSettingsPanelModel();
    }
}

