/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.frames;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.GWTable;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.notify.frames.NotificationTableController;
import com.novell.gw.jclient.application.notify.frames.NotificationTableModel;
import com.novell.gw.jclient.bl.om.items.NotificationItem;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public class NotificationTable
extends GWTable
implements MVCView {
    private static Logger logger = Logger.getLogger(NotificationTable.class);
    private MVCController controller;
    private NotificationCellRenderer notificationCellRenderer = new NotificationCellRenderer();

    public NotificationTable(MVCController parentController) {
        this.showHorizontalLines = false;
        this.showVerticalLines = false;
        this.getTableHeader().setReorderingAllowed(false);
        this.controller = new NotificationTableController(this, parentController);
    }

    public MVCController getController() {
        return this.controller;
    }

    public Object getMVCModel() {
        return this.getModel();
    }

    public void setController(MVCController controller) {
        this.controller = controller;
    }

    public void setMVCModel(Object theModel) {
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (!e.getValueIsAdjusting()) {
            List<NotificationItem> selectedItems = ((NotificationTableModel)this.getModel()).getItemsByIndices(this.getSelectedRows());
            GlobalCommand command = new GlobalCommand(1510, selectedItems);
            this.controller.processCommand(command);
        }
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0) {
            return this.notificationCellRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    private class NotificationCellRenderer
    extends OrientableLabel
    implements TableCellRenderer {
        private NotificationCellRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!(value instanceof NotificationItem)) {
                throw new IllegalArgumentException("illegal value class: " + (value == null ? "null" : value.getClass().getName()));
            }
            if (column != 0) {
                throw new IllegalArgumentException("illegal column index: " + column);
            }
            NotificationItem item = (NotificationItem)value;
            this.setText(item.getFrom());
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setIcon(item.getSmallIcon());
            return this;
        }
    }
}

