/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.options;

import com.novell.gw.jclient.application.options.OptionsStore;
import com.novell.gw.jclient.bl.om.PathManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NixOptionStore
implements OptionsStore,
Serializable {
    private static Logger logger = Logger.getLogger(NixOptionStore.class);
    private String PROPS_FILE_NAME;
    private Hashtable<String, Object> table = null;

    public NixOptionStore() {
        String path = PathManager.getUserOptionsPath();
        this.PROPS_FILE_NAME = path + "display.options";
        this.table = new Hashtable();
        this.load(this.PROPS_FILE_NAME);
    }

    @Override
    public String getString(String theOptionKey, String defaultValue) {
        if (this.table.containsKey(theOptionKey)) {
            return (String)this.table.get(theOptionKey);
        }
        return defaultValue;
    }

    @Override
    public boolean getBoolean(String theOptionKey, boolean defaultValue) {
        if (this.table.containsKey(theOptionKey)) {
            Boolean b = (Boolean)this.table.get(theOptionKey);
            return b;
        }
        return defaultValue;
    }

    public Integer getInteger(String theOptionKey) {
        return (Integer)this.table.get(theOptionKey);
    }

    @Override
    public int getInteger(String theOptionKey, int defaultValue) {
        if (this.table.containsKey(theOptionKey)) {
            Integer i = (Integer)this.table.get(theOptionKey);
            return i;
        }
        return defaultValue;
    }

    public List getList(String theKey) {
        return (List)this.table.get(theKey);
    }

    public void put(String theOptionKey, List theValue) {
        this.table.put(theOptionKey, theValue);
    }

    @Override
    public void put(String theOptionKey, String theValue) {
        this.table.put(theOptionKey, theValue);
    }

    @Override
    public void put(String theOptionKey, boolean theValue) {
        this.table.put(theOptionKey, theValue);
    }

    @Override
    public void put(String theOptionKey, int theValue) {
        this.table.put(theOptionKey, new Integer(theValue));
    }

    public Object remove(String theOptionKey) {
        return this.table.remove(theOptionKey);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.table);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.table = (Hashtable)s.readObject();
    }

    public void save() {
        try {
            File f = new File(this.PROPS_FILE_NAME);
            f.createNewFile();
            FileOutputStream fo = new FileOutputStream(f);
            ObjectOutputStream oo = new ObjectOutputStream(fo);
            this.writeObject(oo);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void load(String theFileName) {
        try {
            FileInputStream fi = new FileInputStream(theFileName);
            ObjectInputStream oi = new ObjectInputStream(fi);
            this.readObject(oi);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public Set<String> keySet() {
        return this.table.keySet();
    }
}

