/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.options.mailto;

import com.appframework.utils.OS;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineOptions {
    private static Logger logger = Logger.getLogger(CommandLineOptions.class);
    private static final CommandLineOptions instance = new CommandLineOptions();
    private List<File> files = new LinkedList<File>();
    private static final boolean DEFAULT_AAFONTS_ENABLED = true;
    private static final boolean DEFAULT_RMI_ENABLED = true;
    private static final boolean DEFAULT_WR_ENABLED = true;
    private boolean aafontsEnabled = true;
    private boolean rmiEnabled = true;
    private boolean wrEnabled = true;
    private boolean help = false;
    private boolean notifier = false;
    private String mailTo = "";

    private CommandLineOptions() {
    }

    public static CommandLineOptions getOptions() {
        return instance;
    }

    public void addFileToOpen(File file) {
        if (file != null && file.exists() && !this.files.contains(file)) {
            this.files.add(file);
        }
    }

    public List<File> getFilesToOpen() {
        return this.files;
    }

    public boolean isAAFontsEnabled() {
        return this.aafontsEnabled;
    }

    public void setAAFontsEnabled(boolean aafontsEnabled) {
        this.aafontsEnabled = aafontsEnabled;
    }

    public void setAAFontsEnabled(String theAAFontsEnabled) {
        this.aafontsEnabled = CommandLineOptions.isTrue(theAAFontsEnabled, true);
    }

    public boolean isRmiEnabled() {
        return this.rmiEnabled;
    }

    public void setRmiEnabled(boolean rmiEnabled) {
        this.rmiEnabled = rmiEnabled;
    }

    public void setRmiEnabled(String theRmiEnabled) {
        this.rmiEnabled = CommandLineOptions.isTrue(theRmiEnabled, true);
    }

    public boolean isWREnabled() {
        return this.wrEnabled;
    }

    public void setWREnabled(boolean wrEnabled) {
        this.wrEnabled = wrEnabled;
    }

    public void setWREnabled(String theWREnabled) {
        this.wrEnabled = CommandLineOptions.isTrue(theWREnabled, true);
    }

    public boolean isHelp() {
        return this.help;
    }

    public void setHelp(boolean theHelp) {
        this.help = theHelp;
    }

    public String getMailTo() {
        return this.mailTo;
    }

    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    public boolean isNotifier() {
        return this.notifier;
    }

    public void setNotifier(boolean notifier) {
        this.notifier = notifier;
    }

    private static boolean isTrue(String s, boolean defVal) {
        if (s == null) {
            return defVal;
        }
        return (s = s.toLowerCase().trim()).equalsIgnoreCase("on") || s.equalsIgnoreCase("yes") || s.equals("1") || s.equalsIgnoreCase("true");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String PLATFORM = OS.isLinuxOS() ? "Linux" : (OS.isMacOS() ? "Mac" : (OS.isWinOS() ? "WinX" : "Cross Platform"));
        String NAME = "groupwise";
        sb.append("NAME:\n\t").append("groupwise").append("\n\n").append("DESCRIPTION:\n\t").append("Novell GroupWise ").append(PLATFORM).append(" Client.\n\n").append("SYNOPSIS:\n\t").append("groupwise").append(" [OPTIONS]\n\n").append("\t-@u=?\n\t\t - Displays a login dialog box whenever you open GroupWise, allowing you to supply any necessary login information.\n\n").append("\t-@u=<user_ID>\n\t\t - Lets you use your GroupWise user ID to open GroupWise as yourself on another users computer. The other user remains logged on to the network.\n\n").append("\t-aa={{on|off},{yes|no},{1|0}}\n\t\t - switch anti aliased fonts on/off (on by default)\n\n").append("\t-h,--help\n\t\t - display this help without starting ").append("groupwise").append("\n\n").append("\t-ipa=<ip_address_or_hostname>\n\t\t - Lets you specify the IP address (x.x.x.x) or the name of the IP address when you are running in client/server mode.\n\n").append("\t-ipp=<port_number>\n\t\t - Lets you specify the IP port when you are running in client/server mode. \n\n").append("\t-l=xx\n\t\t - Applies only if you have two or more language versions or language modules. This option instructs GroupWise to override the default environment language (under General Environment in Options) with the language specified by the language code (xx). See the User Guide for valid language codes.\n\n").append("\tmailto:<url_parameters>\n\t\t - start ").append("groupwise").append(" and compose a new mail with the parameters from the mailto URL as defined in RFC 822:\n").append("\t\t\tto=<to_email>[,<to_email>] - list of TO: recipients\n").append("\t\t\tcc=<cc_email>[,<cc_email>] - list of CC: recipients\n").append("\t\t\tbcc=<bcc_email>[,<bcc_email>] - list of BCC: recipients\n").append("\t\t\tsubject=<url_encoded_subject> - mail subject with encoded spaces and separators (&, =, /, etc.)\n").append("\t\t\tbody=<url_encoded_body> - mail body with encoded spaces and separators (&, =, /, etc.)\n\n").append("\t\t - other supported parameter(s):\n").append("\t\t\t{attach|attachment|attachments}=<path to file> - file attachment (multiple tokens allowed)\n").append("\t-notify\n\t\t - Starts up GroupWise in Notify mode (minimal visual presence).\n\n").append("\t-ph=<pathname>\n\t\t - Lets you specify the path to the post office.\n\n").append("\t-pc=<path_to_caching_mailbox>\n\t\t - Opens GroupWise in Caching mode. GroupWise must be restarted when you change from Online to Caching.\n\n").append("\t-r,--rmi={{on|off},{yes|no},{1|0}}\n\t\t - switch RMI Server on/off (on by default) to enable running of only one instance of ").append("groupwise").append("\n\n").append("\t-safe\n\t\t - Opens GroupWise in Safe Mode. This startup option can be used if you are unable to launch GroupWise.\n\n").append("\t-ui=gtk\n\t\t - Uses the GTK look and feel for the GroupWise client. This only works on Linux using the GNOME* desktop manager.\n\n").append("\t-wr={{on|off},{yes|no},{1|0}}\n\t\t - switch third party HTML viewer on/off (on by default) for use when viewing messages\n\n").append('\n');
        String res = sb.toString();
        return res;
    }
}

