/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.plaf;

import com.appframework.Tested;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.EngineLocale;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.dialogs.availablefontchooser.AvailableFontChooserDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.FoldersTreeInDialogUI;
import com.novell.gw.jclient.application.plaf.FoldersTreeUI;
import com.novell.gw.jclient.application.plaf.SimplifiedColorChooserUI;
import com.novell.gw.jclient.application.resources.StringResources;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Container;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.basic.BasicIconFactory;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.Logger;

public class PLAFChanger {
    private static Logger logger = Logger.getLogger(PLAFChanger.class);
    private static final String DEFAULT_FONT_NAME = "Dialog";
    private static final int DEFAULT_FONT_SIZE = 12;
    public static final int ICON_HEIGHT = 16;
    private static String defaultFont = null;
    private static Integer defaultFontSize = null;
    private static boolean isAsianLang = false;

    public static void changePlafWithSettingsFonts() {
        if (PLAFChanger.isGTKLAF()) {
            PLAFChanger.setTreeRowHeight();
            return;
        }
        defaultFont = OptionManager.getInstance().getInterfaceOptions().getFontName();
        defaultFontSize = OptionManager.getInstance().getInterfaceOptions().getFontSize();
        PLAFChanger.changePlaf();
    }

    public static void changePlaf() {
        PLAFChanger.debug();
        UIDefaults defaults = UIManager.getDefaults();
        try {
            PLAFChanger.assignDefaultFonts(defaults);
            if (OS.getJavaVersionMajor() == 1 && OS.getJavaVersionMinor() <= 6) {
                UIManager.put("ColorChooserUI", SimplifiedColorChooserUI.class.getName());
            }
            if (PLAFChanger.isCustomFolderTreeUIUsed()) {
                defaults.put("FoldersTreeUI", FoldersTreeUI.class.getName());
                defaults.put("FoldersTreeInDialogUI", FoldersTreeInDialogUI.class.getName());
            }
            if (OS.isMetalLAF()) {
                UIManager.getDefaults().put("CheckBoxMenuItem.checkIcon", BasicIconFactory.getCheckBoxMenuItemIcon());
            }
            InputMapUIResource tableAncestorInputMap = (InputMapUIResource)defaults.get("Table.ancestorInputMap");
            tableAncestorInputMap.remove(KeyStroke.getKeyStroke("ENTER"));
            tableAncestorInputMap.put(KeyStroke.getKeyStroke("ENTER"), "cancel");
            InputMap tabInputMap = (InputMap)defaults.get("TabbedPane.focusInputMap");
            tabInputMap.put(KeyStroke.getKeyStroke(9, 128), "navigateRight");
            tabInputMap.put(KeyStroke.getKeyStroke(9, 192), "navigateLeft");
            InputMapUIResource tableUIResource = (InputMapUIResource)defaults.get("Tree.focusInputMap");
            tableUIResource.remove(KeyStroke.getKeyStroke("ctrl A"));
            tableUIResource.remove(KeyStroke.getKeyStroke("SPACE"));
            tableUIResource.remove(KeyStroke.getKeyStroke("ctrl SPACE"));
            tableUIResource.remove(KeyStroke.getKeyStroke("ctrl DOWN"));
            tableUIResource.remove(KeyStroke.getKeyStroke("ctrl UP"));
            tableUIResource.remove(KeyStroke.getKeyStroke("shift SPACE"));
            tableUIResource.remove(KeyStroke.getKeyStroke("ESCAPE"));
            UIManager.put("Table.background", Color.WHITE);
            InputMapUIResource splitPaneInputMap = (InputMapUIResource)defaults.get("SplitPane.ancestorInputMap");
            splitPaneInputMap.remove(KeyStroke.getKeyStroke(119, 0));
            PLAFChanger.setTreeRowHeight();
            InputMap inputMap = (InputMap)defaults.get("Button.focusInputMap");
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), "pressed");
            inputMap.put(KeyStroke.getKeyStroke("released ENTER"), "released");
            Container parent = new JDialog().getParent();
            if (parent != null) {
                parent.setComponentOrientation(UIUtils.getComponentOrientation());
            }
        }
        catch (Exception ee) {
            logger.debug((Object)ee);
        }
    }

    private static void setTreeRowHeight() {
        int treeRowHeight;
        int fontSize = PLAFChanger.getFontSize();
        int n = treeRowHeight = OS.isMacOS() ? fontSize + 7 : fontSize + 4;
        if (treeRowHeight < 16) {
            treeRowHeight = OS.isMacOS() ? 19 : 16;
        }
        UIManager.put("Tree.rowHeight", treeRowHeight);
    }

    public static String getFontName() {
        AvailableFontChooserDialog dialog;
        if (defaultFont == null) {
            String fontName = null;
            if (OS.isLinuxOS()) {
                fontName = StringResources.DEFAULT_FONT_LINUX;
            } else if (OS.isMacOS()) {
                fontName = StringResources.DEFAULT_FONT_MAC;
            } else if (OS.isWinOS()) {
                fontName = StringResources.DEFAULT_FONT_WINDOWS;
            }
            if (fontName == null || fontName.equals(StringResources.getUNDEFINED_RESOURCE())) {
                fontName = DEFAULT_FONT_NAME;
            }
            defaultFont = fontName;
        }
        if (!Arrays.asList(UIUtils.getSystemFonts()).contains(defaultFont) && (dialog = AvailableFontChooserDialog.showMe(defaultFont)).isOkActionProcessed()) {
            defaultFont = dialog.getSelectedFontName();
            OptionManager.getInstance().getInterfaceOptions().setFontName(defaultFont);
        }
        return defaultFont;
    }

    public static int getFontSize() {
        if (defaultFontSize == null) {
            String fontSize = null;
            if (PLAFChanger.isGTKLAF()) {
                fontSize = String.valueOf(UIManager.getDefaults().getFont("Label.font").getSize());
            } else if (OS.isLinuxOS()) {
                fontSize = StringResources.DEFAULT_FONT_SIZE_LINUX;
            } else if (OS.isMacOS()) {
                fontSize = StringResources.DEFAULT_FONT_SIZE_MAC;
            } else if (OS.isWinOS()) {
                fontSize = StringResources.DEFAULT_FONT_SIZE_WINDOWS;
            }
            if (fontSize == null || fontSize.equals(StringResources.getUNDEFINED_RESOURCE())) {
                fontSize = String.valueOf(12);
            }
            defaultFontSize = new Integer(fontSize);
        }
        return defaultFontSize;
    }

    public static boolean isAsianLang() {
        return isAsianLang;
    }

    private static void assignDefaultFonts(UIDefaults defaults) {
        if (!OS.isMacOS() || defaultFont != null || defaultFontSize != null) {
            FontUIResource acceleratorFont;
            FontUIResource commonFont;
            String lang;
            EngineLocale locale = EngineLocale.getCurrent();
            if (locale != null && ("zh".equals(lang = locale.getLocale().getLanguage()) || "ja".equals(lang) || "ko".equals(lang) || "th".equals(lang))) {
                isAsianLang = true;
            }
            String fontName = PLAFChanger.getFontName();
            if (PLAFChanger.isGTKLAF()) {
                commonFont = new FontUIResource(fontName, 0, PLAFChanger.getFontSize() - 1);
                acceleratorFont = new FontUIResource(fontName, 0, PLAFChanger.getFontSize());
            } else {
                commonFont = new FontUIResource(fontName, 0, PLAFChanger.getFontSize());
                acceleratorFont = new FontUIResource(fontName, 0, PLAFChanger.getFontSize() - 2);
            }
            Enumeration keys = defaults.keys();
            while (keys.hasMoreElements()) {
                String stringKey = keys.nextElement().toString();
                if (stringKey.endsWith("acceleratorFont")) {
                    defaults.put(stringKey, acceleratorFont);
                    continue;
                }
                if (!stringKey.endsWith("font") || PLAFChanger.isGTKLAF() && (stringKey.equals("TitledBorder.font") || stringKey.equals("ToolTip.font"))) continue;
                defaults.put(stringKey, commonFont);
            }
            defaults.put("TextPane.font", new FontUIResource(fontName, 0, PLAFChanger.getFontSize()));
        }
    }

    private static void debug() {
        UIManager.LookAndFeelInfo[] installed;
        for (UIManager.LookAndFeelInfo anInstalled : installed = UIManager.getInstalledLookAndFeels()) {
            logger.debug((Object)anInstalled.getName());
        }
        logger.debug((Object)("The current look and feel is " + UIManager.getLookAndFeel().getName()));
    }

    public static void bindOptionPaneStrings() {
        UIManager.put("OptionPane.yesButtonText", StringResources.YES);
        UIManager.put("OptionPane.noButtonText", StringResources.NO);
        UIManager.put("OptionPane.okButtonText", StringResources.OK);
        UIManager.put("OptionPane.cancelButtonText", StringResources.CANCEL);
        UIManager.put("OptionPane.messageDialogTitle", StringResources.MESSAGE);
        if (!OS.isMacOS()) {
            UIManager.put("OptionPane.yesButtonMnemonic", String.valueOf((int)StringResources.getMnemonic(StringResources.YES)));
            UIManager.put("OptionPane.noButtonMnemonic", String.valueOf((int)StringResources.getMnemonic(StringResources.NO)));
            UIManager.put("OptionPane.okButtonMnemonic", String.valueOf((int)StringResources.getMnemonic(StringResources.OK)));
            UIManager.put("OptionPane.cancelButtonMnemonic", String.valueOf((int)StringResources.getMnemonic(StringResources.CANCEL)));
        }
    }

    public static void bindColorChooserStrings() {
        UIManager.put("ColorChooser.okText", StringResources.OK);
        UIManager.put("ColorChooser.cancelText", StringResources.CANCEL);
        UIManager.put("ColorChooser.resetText", StringResources.RESET);
        UIManager.put("ColorChooser.hsbRedText", StringResources.HSB_RED_TEXT);
        UIManager.put("ColorChooser.hsbGreenText", StringResources.HSB_GREEN_TEXT);
        UIManager.put("ColorChooser.hsbBlueText", StringResources.HSB_BLUE_TEXT);
        UIManager.put("ColorChooser.hsbHueText", StringResources.HSB_HUE_TEXT);
        UIManager.put("ColorChooser.hsbSaturationText", StringResources.HSB_SATURATION_TEXT);
        UIManager.put("ColorChooser.hsbBrightnessText", StringResources.HSB_BRIGHTNESS_TEXT);
        UIManager.put("ColorChooser.hsbNameText", StringResources.HSB_NAME_TEXT);
        UIManager.put("ColorChooser.sampleText", StringResources.SAMPLE_TEXT);
        UIManager.put("ColorChooser.rgbNameText", StringResources.RGB_NAME_TEXT);
        UIManager.put("ColorChooser.rgbRedText", StringResources.RGB_RED_TEXT);
        UIManager.put("ColorChooser.rgbGreenText", StringResources.RGB_GREEN_TEXT);
        UIManager.put("ColorChooser.rgbBlueText", StringResources.RGB_BLUE_TEXT);
        UIManager.put("ColorChooser.swatchesRecentText", StringResources.SWATCHES_RECENT_TEXT_C);
        UIManager.put("ColorChooser.swatchesNameText", StringResources.SWATCHES_NAME_TEXT);
        UIManager.put("ColorChooser.previewText", StringResources.PREVIEW_TEXT);
        UIManager.put("GTKColorChooserPanel.saturationText", StringResources.SATURATION_TEXT_C);
        UIManager.put("GTKColorChooserPanel.valueText", StringResources.VALUE_TEXT_C);
        UIManager.put("GTKColorChooserPanel.hueText", StringResources.HUE_TEXT_C);
        UIManager.put("GTKColorChooserPanel.blueText", StringResources.BLUE_TEXT_C);
        UIManager.put("GTKColorChooserPanel.redText", StringResources.RED_TEXT_C);
        UIManager.put("GTKColorChooserPanel.greenText", StringResources.GREEN_TEXT_C);
        UIManager.put("GTKColorChooserPanel.colorNameText", StringResources.COLOR_NAME_TEXT_C);
        UIManager.put("ColorChooser.rgbBlueMnemonic", StringResources.getMnemonic(StringResources.RGB_BLUE_TEXT));
        UIManager.put("ColorChooser.rgbRedMnemonic", StringResources.getMnemonic(StringResources.RGB_RED_TEXT));
        UIManager.put("ColorChooser.rgbGreenMnemonic", StringResources.getMnemonic(StringResources.RGB_GREEN_TEXT));
        UIManager.put("ColorChooser.swatchesMnemonic", StringResources.getMnemonic(StringResources.SWATCHES_NAME_TEXT));
        UIManager.put("ColorChooser.hsbMnemonic", StringResources.getMnemonic(StringResources.HSB_NAME_TEXT));
        UIManager.put("ColorChooser.rgbMnemonic", StringResources.getMnemonic(StringResources.RGB_NAME_TEXT));
        UIManager.put("ColorChooser.swatchesDisplayedMnemonicIndex", StringResources.getDisplayedMnemonicIndex(StringResources.SWATCHES_NAME_TEXT));
        UIManager.put("ColorChooser.hsbDisplayedMnemonicIndex", StringResources.getDisplayedMnemonicIndex(StringResources.HSB_NAME_TEXT));
        UIManager.put("ColorChooser.rgbDisplayedMnemonicIndex", StringResources.getDisplayedMnemonicIndex(StringResources.RGB_NAME_TEXT));
        UIManager.put("GTKColorChooserPanel.blueMnemonic", String.valueOf((int)StringResources.getMnemonic(StringResources.BLUE_TEXT_C)));
        UIManager.put("GTKColorChooserPanel.redMnemonic", String.valueOf((int)StringResources.getMnemonic(StringResources.RED_TEXT_C)));
        UIManager.put("GTKColorChooserPanel.greenMnemonic", String.valueOf((int)StringResources.getMnemonic(StringResources.GREEN_TEXT_C)));
        UIManager.put("GTKColorChooserPanel.hueMnemonic", String.valueOf((int)StringResources.getMnemonic(StringResources.HUE_TEXT_C)));
        UIManager.put("GTKColorChooserPanel.saturationMnemonic", String.valueOf((int)StringResources.getMnemonic(StringResources.SATURATION_TEXT_C)));
        UIManager.put("GTKColorChooserPanel.valueMnemonic", String.valueOf((int)StringResources.getMnemonic(StringResources.VALUE_TEXT_C)));
        UIManager.put("GTKColorChooserPanel.colorNameMnemonic", String.valueOf((int)StringResources.getMnemonic(StringResources.COLOR_NAME_TEXT_C)));
    }

    public static void bindFileChooserStrings() {
        UIManager.put("FileChooser.lookInLabelText", StringResources.FILE_CHOOSER_LOOK_IN);
        UIManager.put("FileChooser.fileNameLabelText", StringResources.FILE_CHOOSER_FILE_NAME_C);
        UIManager.put("FileChooser.filesOfTypeLabelText", StringResources.FILE_CHOOSER_FILES_OF_TYPE_C);
        UIManager.put("FileChooser.upFolderToolTipText", StringResources.FILE_CHOOSER_UP_FOLDER_TOOLTIP);
        UIManager.put("FileChooser.homeFolderToolTipText", StringResources.FILE_CHOOSER_HOME_FOLDER_TOOLTIP);
        UIManager.put("FileChooser.newFolderToolTipText", StringResources.FILE_CHOOSER_NEW_FOLDER_TOOLTIP);
        UIManager.put("FileChooser.listViewButtonToolTipText", StringResources.FILE_CHOOSER_LIST_VIEW_TOOLTIP);
        UIManager.put("FileChooser.detailsViewButtonToolTipText", StringResources.FILE_CHOOSER_DETAILS_VIEW_TOOLTIP);
        UIManager.put("FileChooser.saveButtonToolTipText", StringResources.FILE_CHOOSER_SAVE_BUTTON_TOOLTIP);
        UIManager.put("FileChooser.openButtonToolTipText", StringResources.FILE_CHOOSER_OPEN_BUTTON_TOOLTIP);
        UIManager.put("FileChooser.cancelButtonToolTipText", StringResources.FILE_CHOOSER_CANCEL_BUTTON_TOOLTIP);
        UIManager.put("FileChooser.saveButtonText", StringResources.SAVE);
        UIManager.put("FileChooser.openButtonText", StringResources.OPEN);
        UIManager.put("FileChooser.cancelButtonText", StringResources.CANCEL);
        UIManager.put("FileChooser.acceptAllFileFilterText", StringResources.FILE_CHOOSER_ALL_FILES);
        UIManager.put("FileChooser.deleteFileButtonText", StringResources.FILE_CHOOSER_DELETE_FILE);
        UIManager.put("FileChooser.filesLabelText", StringResources.FILE_CHOOSER_FILES);
        UIManager.put("FileChooser.filterLabelText", StringResources.FILE_CHOOSER_FILTER_C);
        UIManager.put("FileChooser.foldersLabelText", StringResources.FILE_CHOOSER_FOLDERS);
        UIManager.put("FileChooser.newFolderButtonText", StringResources.FILE_CHOOSER_NEW_FOLDER);
        UIManager.put("FileChooser.newFolderDialogText", StringResources.FILE_CHOOSER_FOLDER_NAME_C);
        UIManager.put("FileChooser.openDialogTitleText", StringResources.FILE_CHOOSER_OPEN);
        UIManager.put("FileChooser.pathLabelText", StringResources.FILE_CHOOSER_SELECTION_C);
        UIManager.put("FileChooser.renameFileButtonText", StringResources.FILE_CHOOSER_RENAME_FILE);
        UIManager.put("FileChooser.renameFileDialogText", StringResources.FILE_CHOOSER_RENAME_FILE_TO);
        UIManager.put("FileChooser.renameFileErrorText", StringResources.FILE_CHOOSER_RENAME_ERROR_TEXT);
        UIManager.put("FileChooser.renameFileErrorTitle", StringResources.ERROR);
        UIManager.put("FileChooser.saveDialogTitleText", StringResources.SAVE);
        UIManager.put("FileChooser.saveInLabelText", StringResources.FILE_CHOOSER_SAVE_IN_C);
        UIManager.put("FileChooser.fileNameHeaderText", StringResources.FILE_CHOOSER_FILE_NAME_HEADER_TEXT);
        UIManager.put("FileChooser.fileSizeHeaderText", StringResources.FILE_CHOOSER_FILE_SIZE_HEADER_TEXT);
        UIManager.put("FileChooser.fileTypeHeaderText", StringResources.FILE_CHOOSER_FILE_TYPE_HEADER_TEXT);
        UIManager.put("FileChooser.fileDateHeaderText", StringResources.FILE_CHOOSER_FILE_DATE_HEADER_TEXT);
        UIManager.put("FileChooser.fileAttrHeaderText", StringResources.FILE_CHOOSER_FILE_ATTR_HEADER_TEXT);
        if (!OS.isMacOS()) {
            UIManager.put("FileChooser.saveInLabelMnemonic", StringResources.getMnemonic(StringResources.FILE_CHOOSER_SAVE_IN_C));
            UIManager.put("FileChooser.lookInLabelMnemonic", StringResources.getMnemonic(StringResources.FILE_CHOOSER_LOOK_IN));
            UIManager.put("FileChooser.fileNameLabelMnemonic", StringResources.getMnemonic(StringResources.FILE_CHOOSER_FILE_NAME_C));
            UIManager.put("FileChooser.filesOfTypeLabelMnemonic", StringResources.getMnemonic(StringResources.FILE_CHOOSER_FILES_OF_TYPE_C));
            UIManager.put("FileChooser.saveButtonMnemonic", StringResources.getMnemonic(StringResources.SAVE));
            UIManager.put("FileChooser.openButtonMnemonic", StringResources.getMnemonic(StringResources.OPEN));
            UIManager.put("FileChooser.cancelButtonMnemonic", StringResources.getMnemonic(StringResources.CANCEL));
        }
    }

    public static boolean isGTKLAF() {
        return LookAndFeelManager.isGtkLookAndFeel();
    }

    public static boolean isCustomFolderTreeUIUsed() {
        return PLAFChanger.isMetalLAF() || PLAFChanger.isAquaLAF() || PLAFChanger.isWindowsLAF();
    }

    public static boolean isAquaLAF() {
        return LookAndFeelManager.isAquaLookAndFeel();
    }

    public static boolean isMetalLAF() {
        return UIManager.getLookAndFeel() instanceof MetalLookAndFeel;
    }

    public static boolean isWindowsLAF() {
        return UIManager.getLookAndFeel() instanceof WindowsLookAndFeel;
    }

    @Tested
    public static int getTreeRowHeight() {
        return (Integer)UIManager.getDefaults().get("Tree.rowHeight");
    }

    static {
        PLAFChanger.setTreeRowHeight();
    }
}

