/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.BasicPrintManager;
import com.novell.gw.jclient.application.printing.PrintInformation;
import com.novell.gw.jclient.application.printing.PrintManagerDialogActionList;
import com.novell.gw.jclient.application.printing.preview.PrintPreviewDialog;
import com.novell.gw.jclient.application.printing.preview.PrintUtils;
import com.novell.gw.jclient.application.printing.printingaddressbook.AddressBookPrintManager;
import com.novell.gw.jclient.application.printing.printingcalendar.CalendarPrintManager;
import com.novell.gw.jclient.application.printing.printingitem.ItemPrintManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintManagerDialog
extends ApplicationDialog<PrintManagerDialogActionList> {
    private static Logger logger = Logger.getLogger(PrintManagerDialog.class);
    private JButton btnPrint;
    private JButton btnPreview;
    private JButton btnPageSetup;
    private JButton btnConfigurePrinter;
    private JComboBox cbPrintServices;
    private boolean actionCompleteSuccessfully = false;
    private BasicPrintManager printManager;
    private PrinterJob printerJob;
    private PrintRequestAttributeSet printAttributes;
    private Object printedElement;

    public PrintManagerDialog(ApplicationFrame parent, Object theObject, Object theSelectedAttachment, boolean propertiesSelected) {
        super((Frame)parent, parent.getController(), true);
        this.setTitle(StringResources.PRINTING_D);
        this.printedElement = theObject;
        this.printerJob = PrinterJob.getPrinterJob();
        this.printAttributes = new HashPrintRequestAttributeSet(OptionManager.getInstance().getPrintingOptions().getPrintAttributeSet());
        if (this.printAttributes == null) {
            this.printAttributes = new HashPrintRequestAttributeSet();
        }
        this.buildUI(theSelectedAttachment, propertiesSelected);
    }

    public PrintManagerDialog(ApplicationFrame parent, Object theObject) {
        this(parent, theObject, null, false);
    }

    public PrintManagerDialog(ApplicationFrame parent) {
        this(parent, null);
    }

    @Override
    protected PrintManagerDialogActionList createController(MVCController parentController) {
        return new PrintManagerDialogActionList(this, parentController);
    }

    public PrintInformation getPrintInformation() {
        return new PrintInformation(this.printManager.getSelectedForm(), this.printedElement, this.printerJob, this.printAttributes);
    }

    private void buildUI(Object theSelectedAttachment, boolean propertiesSelected) {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.removeAll();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 19;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        contentPane.add((Component)this.buildPrintManager(theSelectedAttachment, propertiesSelected), constraints);
        if (!OS.isMacOS()) {
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            contentPane.add((Component)this.buildPrinterConfigPanel(), constraints);
        }
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        contentPane.add((Component)this.buildButtonsPanel(), constraints);
        this.getRootPane().setDefaultButton(this.btnPrint);
        this.pack();
    }

    private BasicPrintManager buildPrintManager(Object theSelectedAttachment, boolean propertiesSelected) {
        if (this.printedElement == null) {
            this.printManager = new CalendarPrintManager((MVCController)this.getController());
            this.printedElement = GWCalendarUtils.getToday();
            this.setTitle(StringResources.PRINTING_CALENDAR);
        } else if (this.printedElement instanceof AbstractItem) {
            this.printManager = new ItemPrintManager((MVCController)this.getController(), theSelectedAttachment, propertiesSelected);
            this.setTitle(StringResources.PRINTING_ITEM);
        } else if (this.printedElement instanceof List) {
            this.printManager = new AddressBookPrintManager((MVCController)this.getController());
            this.setTitle(StringResources.PRINTING_ADDRESS_BOOK);
        }
        this.printManager.setMVCModel(this.printedElement);
        return this.printManager;
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel content = new OrientablePanel();
        ((PrintManagerDialogActionList)this.getController()).getActionList().getAction(ActionKey.PRINT_FORM).setMVCModel(this.getPrintInformation());
        this.btnPrint = new JButton(((PrintManagerDialogActionList)this.getController()).getActionList().getAction(ActionKey.PRINT_FORM));
        this.btnPreview = new JButton(new BtnPreviewAction());
        this.btnPageSetup = new JButton(new BtnPageSetupAction());
        this.getBtnCancel().setText(StringResources.CLOSE);
        if (OS.isMacOS()) {
            this.btnPrint.setText(StringResources.PRINT_D);
            content.add(this.btnPreview);
            content.add(this.getBtnCancel());
            content.add(this.btnPrint);
        } else {
            content.add(this.btnPrint);
            content.add(this.btnPreview);
            content.add(this.btnPageSetup);
            content.add(this.getBtnCancel());
        }
        return content;
    }

    private JPanel buildPrinterConfigPanel() {
        this.cbPrintServices = new OrientableComboBox(PrintServiceLookup.lookupPrintServices(null, null));
        this.cbPrintServices.addItemListener(new CbPrintServicesItemListener());
        this.cbPrintServices.setSelectedItem(PrintUtils.getDefaultPrintService());
        OrientableLabel lbPrinterName = new OrientableLabel(StringResources.PRINTER_NAME + ": ");
        this.btnConfigurePrinter = new JButton(new BtnConfigurePrinterAction());
        OrientablePanel pnlPrinterProperties = new OrientablePanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), StringResources.PRINTER_GROUP_CAPTION);
        pnlPrinterProperties.setBorder(titledBorder);
        pnlPrinterProperties.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 10;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.insets = new Insets(3, 5, 5, 5);
        pnlPrinterProperties.add((Component)lbPrinterName, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(3, 5, 5, 5);
        pnlPrinterProperties.add((Component)this.cbPrintServices, constraints);
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(3, 5, 7, 5);
        pnlPrinterProperties.add((Component)this.btnConfigurePrinter, constraints);
        return pnlPrinterProperties;
    }

    @Override
    protected void doBeforeDispose() {
        super.doBeforeDispose();
        if (this.printManager instanceof CalendarPrintManager) {
            ((CalendarPrintManager)this.printManager).saveOptions();
        }
    }

    @Override
    protected void processCancelAction(ActionEvent event) {
        super.processCancelAction(event);
        this.dispose();
    }

    @Override
    protected void processCloseAction(WindowEvent event) {
        super.processCloseAction(event);
        this.dispose();
    }

    public boolean isActionCompleteSuccessfully() {
        return this.actionCompleteSuccessfully;
    }

    public void release() {
        this.btnPrint = null;
        this.btnPreview = null;
        this.btnPageSetup = null;
        this.btnConfigurePrinter = null;
        this.cbPrintServices = null;
        this.printManager = null;
        this.printerJob = null;
        this.printAttributes = null;
        this.printedElement = null;
    }

    @Override
    public void setMVCModel(Object theModel) {
        super.setMVCModel(theModel);
        if (this.printManager != null) {
            this.printManager.setMVCModel(theModel);
        }
    }

    public void setPropertiesSelected(boolean propertiesSelected) {
        this.printManager.setPropertiesSelected(propertiesSelected);
    }

    class CbPrintServicesItemListener
    implements ItemListener {
        CbPrintServicesItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && e.getItem() instanceof PrintService) {
                try {
                    PrintService service = (PrintService)e.getItem();
                    PrintManagerDialog.this.printerJob.setPrintService(service);
                }
                catch (PrinterException e1) {
                    logger.error((Object)e1);
                    logger.debug((Object)e1, (Throwable)e1);
                    JOptionPane.showMessageDialog(PrintManagerDialog.this, StringResources.INVALID_PRINTER, PrintManagerDialog.this.getTitle(), 0);
                }
            }
        }
    }

    class BtnConfigurePrinterAction
    extends AbstractAction {
        public BtnConfigurePrinterAction() {
            super(StringResources.PRINTER_PROPERTIES);
        }

        public void actionPerformed(ActionEvent e) {
            if (PrintUtils.showPrintDialog(PrintManagerDialog.this.printerJob, PrintManagerDialog.this.printAttributes, true)) {
                ((PrintManagerDialogActionList)PrintManagerDialog.this.getController()).getActionList().performAction(ActionKey.PRINT_FORM);
            }
        }
    }

    class BtnPageSetupAction
    extends AbstractAction {
        public BtnPageSetupAction() {
            super(StringResources.PAGE_SETUP);
        }

        public void actionPerformed(ActionEvent e) {
            PrintManagerDialog manager = PrintManagerDialog.this;
            if (PrinterJob.lookupPrintServices().length == 0) {
                JOptionPane.showMessageDialog(manager, StringResources.PROBLEM_WITH_PRINTERK__PRINTING_FAI);
                return;
            }
            PageFormat pf = PrintManagerDialog.this.printerJob.pageDialog(PrintManagerDialog.this.printAttributes);
            if (pf == null) {
                return;
            }
        }
    }

    class BtnPreviewAction
    extends AbstractAction {
        public BtnPreviewAction() {
            super(StringResources.PREVIEW);
        }

        public void actionPerformed(ActionEvent e) {
            PrintPreviewDialog printPreviewDialog = new PrintPreviewDialog(PrintManagerDialog.this, (MVCController)PrintManagerDialog.this.getController(), PrintManagerDialog.this.getPrintInformation());
            printPreviewDialog.setVisible(true);
            System.gc();
        }
    }
}

