/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.preview;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import org.apache.log4j.Logger;

public class RtfPreview
extends BoxView {
    private static Logger logger = Logger.getLogger(RtfPreview.class);
    private int firstOnPage = 0;
    private int lastOnPage = 0;
    private int pageIndex = 0;
    private int height = 0;
    private boolean isPrintingFinished = false;

    public RtfPreview(Element elem, View root, int w, int h) {
        super(elem, 1);
        this.setParent(root);
        this.setSize(w, h);
        this.layout(w, h);
    }

    public boolean paintPage(Graphics g, int hPage, int pageIndex) {
        if (pageIndex > this.pageIndex) {
            this.firstOnPage = this.lastOnPage + 1;
            if (this.firstOnPage >= this.getViewCount()) {
                this.isPrintingFinished = true;
                return false;
            }
            this.pageIndex = pageIndex;
        }
        int yMin = this.getOffset(1, this.firstOnPage);
        int yMax = yMin + hPage;
        Rectangle rc = new Rectangle();
        int nCount = this.getViewCount();
        for (int k = this.firstOnPage; k < nCount; ++k) {
            rc.x = this.getOffset(0, k);
            rc.y = this.getOffset(1, k);
            rc.width = this.getSpan(0, k);
            rc.height = this.getSpan(1, k);
            if (rc.y + rc.height > yMax) break;
            this.lastOnPage = k;
            rc.y -= yMin;
            this.paintChild(g, rc, k);
            this.height = rc.y + rc.height;
        }
        if (this.lastOnPage == nCount - 1) {
            this.isPrintingFinished = true;
        }
        return true;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isPrintingFinished() {
        return this.isPrintingFinished;
    }
}

