/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DayCell;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingCalendarPanel;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.preview.PrintUtils;
import com.novell.gw.jclient.application.printing.printingcalendar.CalendarOptionsPanel;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.DayOrganizerForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.PrintCalendarUtils;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalendarForm
extends PrintForm
implements MVCView {
    private static char FILLED_CIRCLE_SYMBOL = (char)9679;
    private static char EMPTY_SQUARE_SYMBOL = (char)9633;
    protected static long DAY_IN_MILLISECONS = 86400000L;
    protected static long WEEK_IN_MILLISECONDS = 7L * DAY_IN_MILLISECONS;
    protected static long MONTH_IN_MILLISECONDS = 4L * WEEK_IN_MILLISECONDS;
    private static final Font DEFAULT_CALENDAR_FONT = new Font(PrintForm.FNT_PLAIN.getFontName(), 0, 10);
    protected static final BasicStroke HALF_HOUR_LINE = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{20.0f, 5.0f}, 0.0f);
    protected static final BasicStroke QUARTER_HOUR_LINE = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{10.0f, 5.0f}, 0.0f);
    private static Logger logger = Logger.getLogger(CalendarForm.class);
    protected MVCController controller;
    protected static PrintingCalendarPanel printingCalendarPanel;
    protected CalendarOptionsPanel calendarOptionsPanel;
    protected int translateX;
    protected int translateY;
    protected Calendar startingDay = GWCalendarUtils.getToday();
    protected static FontCalendarDisplayAttributes monthlyCalendarFontAttributes;
    protected static Font chosenFont;
    protected static int chosenFontCellHeight;
    protected static int RTLOffset;
    protected static final Insets cellInsets;
    protected String dateMonth;
    protected String dateYear;
    protected static final Color BORDER_COLOR;
    protected static final Color FILL_COLOR;
    protected Calendar currPrintDay = GWCalendarUtils.getToday();
    public static final int MESSAGE_TEXT_LENGTH = 50;
    protected int footerHeight;
    private Color oldColor;
    protected List<IItemList> listOfItems = new ArrayList<IItemList>();

    public CalendarForm() {
    }

    public CalendarForm(MVCController parentController) {
        this();
        this.setController(parentController);
    }

    public AbstractFolder getSelectedCalendarFolder() {
        GWMainAppFrame frame = GWClient.getGWMainAppFrame();
        AbstractFolder selectedFolder = frame.getFoldersTree().getSelectedFolder();
        return selectedFolder;
    }

    private void constructFontDependencies(Graphics canvas) {
        chosenFont = OptionManager.getInstance().getPrintingOptions().getCalendarContentFont();
        chosenFontCellHeight = PrintUtils.getPrintCellHeight(canvas, chosenFont);
        monthlyCalendarFontAttributes = new FontCalendarDisplayAttributes(DEFAULT_CALENDAR_FONT);
    }

    protected void getItems() {
        this.listOfItems.clear();
        if (this.isSelectedFolderPrintSelected()) {
            AbstractFolder selectedFolder = this.getSelectedCalendarFolder();
            this.listOfItems.add(selectedFolder.getItemList());
        }
        if (this.isAllItemsPrintSelected()) {
            try {
                CalendarFolder folder = EngineCommandManager.getCalendarFolder(ControlsUtils.getUserGuid(this.getController()));
                this.listOfItems.add(folder.getItemList());
                List<AbstractFolder> listOfChildren = folder.getChildFolders();
                for (AbstractFolder f : listOfChildren) {
                    if (f.isSubCalendarShown()) continue;
                    this.listOfItems.add(f.getItemList());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void changeDateValues(Calendar day) {
    }

    protected String composeNoteSubject(String subject) {
        String composedNoteSubject = isLeftToRight ? String.format("%c %s", Character.valueOf(FILLED_CIRCLE_SYMBOL), subject) : String.format("%s %c", subject, Character.valueOf(FILLED_CIRCLE_SYMBOL));
        return composedNoteSubject;
    }

    protected String composeTaskSubject(String subject) {
        String composedTaskSubject = isLeftToRight ? String.format("%c %s", Character.valueOf(EMPTY_SQUARE_SYMBOL), subject) : String.format("%s %c", subject, Character.valueOf(EMPTY_SQUARE_SYMBOL));
        return composedTaskSubject;
    }

    void setColorItem(Graphics pg, AbstractItem item) {
        this.oldColor = pg.getColor();
        if (this.calendarOptionsPanel.isUseCategoryColor()) {
            pg.setColor(CategoryUtils.getPrimaryTextColor(item.getCategories()));
        }
    }

    private void drawString(Graphics pg, String string, int x, int y, Color foregroundColor) {
        if (this.calendarOptionsPanel.isUseCategoryColor()) {
            Color previousColor = pg.getColor();
            pg.setColor(foregroundColor);
            pg.drawString(string, x, y);
            pg.setColor(previousColor);
        } else {
            pg.drawString(string, x, y);
        }
    }

    public void fillFramedRectangle(Graphics pg, Color backgroundColor, Rectangle rectangle) {
        int lineWidth = (int)PrintCalendarUtils.getBasicStrokeLineWidth(pg);
        if (lineWidth >= 1) {
            pg.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.fillRectangle(pg, backgroundColor, new Rectangle(rectangle.x + lineWidth, rectangle.y + lineWidth, rectangle.width - lineWidth, rectangle.height - lineWidth));
    }

    private void fillRectangle(Graphics pg, Color backgroundColor, Rectangle rectangle) {
        Color prevColor = pg.getColor();
        if (this.calendarOptionsPanel.isUseCategoryColor()) {
            pg.setColor(backgroundColor);
            pg.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            pg.setColor(this.calendarOptionsPanel.isUseShading() ? FILL_COLOR : Color.WHITE);
            pg.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        pg.setColor(prevColor);
    }

    void setOldColor(Graphics pg) {
        pg.setColor(this.oldColor);
    }

    void setColorFill(Graphics pg) {
        this.oldColor = pg.getColor();
        if (this.calendarOptionsPanel.isUseShading()) {
            pg.setColor(FILL_COLOR);
        } else {
            pg.setColor(Color.WHITE);
        }
    }

    abstract boolean pageExists(int var1);

    public boolean isReplaceExtraText() {
        return this.calendarOptionsPanel.isUseExtraTextToNextPage();
    }

    public boolean isAllItemsPrintSelected() {
        return this.calendarOptionsPanel != null ? this.calendarOptionsPanel.isAllItemsPrint() : true;
    }

    public boolean isSelectedFolderPrintSelected() {
        return this.calendarOptionsPanel != null ? this.calendarOptionsPanel.isSelectedFolderPrint() : false;
    }

    @Override
    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.prepareToPrint(pg, pageFormat);
        this.printCommonFooter(pg, pageIndex, this.pageWidth);
        if (ApplicationOptions.getInstance().getBoolean("PRINT_HEADER", true)) {
            this.commonHeaderH = this.printCommonHeader(pg, pageIndex, this.pageWidth);
            pg.translate(0, this.commonHeaderH);
            this.translateY += this.commonHeaderH;
        }
        return 0;
    }

    private void prepareToPrint(Graphics graphics, PageFormat pageFormat) {
        Graphics2D canvas = (Graphics2D)graphics;
        canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        canvas.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.translateX = 0;
        if (this.isPreview) {
            this.translateY = (int)pageFormat.getImageableY();
            this.pageWidth = (int)pageFormat.getImageableWidth();
            this.pageHeight = (int)pageFormat.getImageableHeight();
            this.isPreview = false;
        } else {
            canvas.scale(1.0 / SCALE_FACTOR, 1.0 / SCALE_FACTOR);
            this.translateY = (int)(SCALE_FACTOR * pageFormat.getImageableY());
            this.pageWidth = (int)(SCALE_FACTOR * pageFormat.getImageableWidth());
            this.pageHeight = (int)(SCALE_FACTOR * pageFormat.getImageableHeight());
        }
        graphics.setColor(Color.black);
        graphics.setClip(0, 0, this.pageWidth, this.pageHeight);
        this.constructFontDependencies(graphics);
    }

    private int drawCommonHeader(Graphics2D g2, double pageWidth) {
        String header = this.calendarOptionsPanel.getCalendarHeader();
        int commonHeaderLineHeight = g2.getFontMetrics(FNT_PLAIN).getHeight();
        if (!Utils.isNullOrEmpty(header)) {
            FontRenderContext frc = g2.getFontRenderContext();
            GlyphVector glyphs = FNT_PLAIN.createGlyphVector(frc, header);
            while (glyphs.getOutline().getBounds().getWidth() > pageWidth) {
                header = String.format("%s...", header.substring(0, header.length() - 4));
                glyphs = FNT_PLAIN.createGlyphVector(frc, header);
            }
            AttributedString as = new AttributedString(header);
            as.addAttribute(TextAttribute.FONT, FNT_PLAIN);
            AttributedCharacterIterator aci = as.getIterator();
            LineMetrics lineMetrics = FNT_PLAIN.getLineMetrics(header, g2.getFontRenderContext());
            g2.drawString(aci, 0.0f, lineMetrics.getAscent());
            commonHeaderLineHeight = (int)(2.0f * lineMetrics.getHeight());
        }
        return commonHeaderLineHeight;
    }

    @Override
    protected int printCommonHeader(Graphics pg, int pageIndex, int wPage) {
        return this.drawCommonHeader((Graphics2D)pg, wPage);
    }

    protected final int printBoxedString(Graphics pg, String string, Font font, int x, int y, int width, int height, Color foregroundColor, Color backgroundColor) {
        Font previousFont = pg.getFont();
        pg.setFont(font);
        int FONT_HEIGHT = pg.getFontMetrics().getHeight();
        int FONT_DESCENT = pg.getFontMetrics().getDescent();
        int lineY = y;
        int doubleSpaceWidth = SwingUtilities.computeStringWidth(pg.getFontMetrics(), "  ");
        List<String> subStrings = UIUtils.breakStringIntoSubstrings(string, pg.getFontMetrics(), width - doubleSpaceWidth);
        Rectangle rectangle = new Rectangle(x, lineY, width, height);
        this.fillFramedRectangle(pg, backgroundColor, rectangle);
        for (int index = 0; index < subStrings.size() && (index + 1) * FONT_HEIGHT <= height; ++index) {
            String text = String.format(" %s ", subStrings.get(index));
            int stringWidth = SwingUtilities.computeStringWidth(pg.getFontMetrics(), text);
            this.drawString(pg, text, isLeftToRight ? x : x + width - stringWidth, lineY + FONT_HEIGHT - FONT_DESCENT, foregroundColor);
            lineY += FONT_HEIGHT;
        }
        pg.setFont(previousFont);
        return lineY;
    }

    protected int printStringLineByLine(Graphics pg, String string, int x, int y, int width, Color foregroundColor, Color backgroundColor) {
        List<String> subStrings = UIUtils.breakStringIntoSubstrings(string, pg.getFontMetrics(), width);
        return this.printBoxedString(pg, string, chosenFont, x, y, width, subStrings.size() * chosenFontCellHeight, foregroundColor, backgroundColor);
    }

    @Override
    protected void printCommonFooter(Graphics pg, int pageIndex, int wPage) {
        pg.setFont(FNT_PLAIN);
        FontMetrics fm = pg.getFontMetrics();
        this.footerHeight = 3 * fm.getAscent() / 2;
        String date = OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(GWCalendarUtils.getToday().getTime());
        int dateWidth = SwingUtilities.computeStringWidth(fm, date);
        String pageNumber = String.valueOf(pageIndex + 1);
        int footerY = this.pageHeight - this.footerHeight / 4;
        if (this.calendarOptionsPanel.hasFooterPageNumber()) {
            int pageNumberWidth = SwingUtilities.computeStringWidth(fm, pageNumber);
            pg.drawString(pageNumber, this.pageWidth / 2 - pageNumberWidth / 2, footerY);
        }
        String userGuid = EngineCommandManager.getUserGuid();
        String name = GWCommandManager.getInstance(userGuid).getCurrentUserInfo().getName();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            if (this.calendarOptionsPanel.hasFooterName()) {
                pg.drawString(GWCommandManager.getInstance(userGuid).getCurrentUserInfo().getName(), 1, footerY);
            }
            if (this.calendarOptionsPanel.hasFooterDateAndTime()) {
                pg.drawString(date, this.pageWidth - dateWidth, footerY);
            }
        } else {
            if (this.calendarOptionsPanel.hasFooterName()) {
                int nameWidth = SwingUtilities.computeStringWidth(fm, name);
                pg.drawString(name, this.pageWidth - nameWidth - 1, footerY);
            }
            if (this.calendarOptionsPanel.hasFooterDateAndTime()) {
                pg.drawString(date, 1, footerY);
            }
        }
    }

    public void setController(MVCController theController) {
        this.controller = theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object model) {
        if (model instanceof Map) {
            Map map = (Map)model;
            printingCalendarPanel = (PrintingCalendarPanel)map.get(PrintingCalendarPanel.class);
            this.calendarOptionsPanel = (CalendarOptionsPanel)map.get(CalendarOptionsPanel.class);
            this.startingDay = printingCalendarPanel.getCurrentDay();
        }
    }

    public Object getMVCModel() {
        logger.warn((Object)"retirnung wrong model");
        return null;
    }

    void printItemIcon(AbstractItem item, Graphics pg, int startX, int startY, int endX, int endY) {
        if (item instanceof ReminderNote) {
            pg.fillOval(startX, startY, endX - startX, endY - startY);
        } else if (item instanceof TaskItem) {
            if (item.isStatusCompleted()) {
                pg.drawLine(startX, startY, endX, endY);
                pg.drawLine(startX, endY, endX, startY);
            }
            pg.drawRect(startX, startY, endX - startX, endY - startY);
        } else if (item instanceof AppointmentItem) {
            logger.warn((Object)"icon for appointment is not printed");
        }
    }

    protected int getFirstDayOfWeekIndex() {
        String userGuid = ControlsUtils.getUserGuid(this.controller);
        int index = (Integer)GWCommandManager.getInstance(userGuid).getCurrentDataStore().getSettings().getMonthCalendarFirstDay().getValue();
        return ++index;
    }

    public PrintingCalendarPanel getPrintingCalendarPanel() {
        return printingCalendarPanel;
    }

    public void setStartingDay(Calendar day) {
        this.startingDay = day;
    }

    public Calendar getStartingDay() {
        return this.startingDay;
    }

    protected void drawMonthlyCalendarCell(Graphics pg, DayCell dayCell, int remX) {
        Rectangle bounds = dayCell.getBounds();
        Calendar calendar = dayCell.getTime();
        if (calendar != null) {
            if (this.currPrintDay.get(5) == calendar.get(5) && this instanceof DayOrganizerForm) {
                int cellX = isLeftToRight ? bounds.x : bounds.x + remX - monthlyCalendarFontAttributes.calculateCellWidth() + monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth();
                this.setColorFill(pg);
                pg.fillRect(cellX, bounds.y, bounds.width, bounds.height);
                pg.setColor(BORDER_COLOR);
                pg.drawRect(cellX, bounds.y, bounds.width, bounds.height);
            }
            this.drawMonthlyCalendarString(pg, dayCell.getText(), dayCell.getBounds(), dayCell.getForeground(), monthlyCalendarFontAttributes.getFont(), remX);
        }
    }

    protected void drawMonthlyCalendarString(Graphics g, String text, Rectangle bounds, Color textColor, Font textFont, int remX) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle textRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        g.setFont(textFont);
        SwingUtilities.layoutCompoundLabel(fm, text, null, 0, 0, 0, 0, bounds, iconRect, textRect, 0);
        int textX = isLeftToRight ? textRect.x + remX : textRect.x + remX - monthlyCalendarFontAttributes.calculateCellWidth() + monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth();
        int textY = textRect.y + fm.getAscent();
        g.setColor(textColor);
        g.drawString(text, textX, textY);
    }

    protected static void initMonthlyCalendarLabelCells(DayCell[] labelCells, Calendar currPrintDay) {
        int first = currPrintDay.getFirstDayOfWeek();
        int nSize = labelCells.length;
        for (int i = 0; i < nSize; ++i) {
            int x = i + first - 1;
            if (x >= 7) {
                x %= 7;
            }
            DayCell cell = new DayCell();
            cell.setIndex(i);
            cell.setText(GWCalendarUtils.dayShortestNames[x]);
            cell.setForeground(ColorConstants.clrDaysWork);
            labelCells[i] = cell;
        }
    }

    protected static void initMonthlyCalendarDayCells(DayCell[] dayCells, DayCell[] labelCells, Calendar currPrintDay) {
        Calendar month = GWCalendarUtils.initCalendar(currPrintDay);
        int nSize = dayCells.length;
        for (int i = 0; i < nSize; ++i) {
            DayCell cell = new DayCell();
            cell.setIndex(i);
            dayCells[i] = cell;
            month.add(5, 1);
            if (month.get(2) != currPrintDay.get(2)) continue;
            String title = String.valueOf(month.get(5));
            cell.setText(title);
            cell.setTime(month);
        }
        int dx = 0;
        int dy = CalendarForm.cellInsets.top + monthlyCalendarFontAttributes.calculateLabelsHeight();
        for (int i = 0; i < nSize; ++i) {
            dx = CalendarForm.incDx(i, dx, monthlyCalendarFontAttributes.calculateFullWidth());
            if (i / 7 == 0) {
                labelCells[i].setBounds(dx, 0, monthlyCalendarFontAttributes.calculateCellWidth(), monthlyCalendarFontAttributes.calculateCellHeight());
            }
            if (i % 6 != 0 && i % 7 == 0) {
                dy += monthlyCalendarFontAttributes.calculateFullHeight();
            }
            dayCells[i].setBounds(dx, dy, monthlyCalendarFontAttributes.calculateCellWidth(), monthlyCalendarFontAttributes.calculateCellHeight());
        }
    }

    private static int incDx(int index, int theDx, int width) {
        theDx = index % 7 == 0 ? (PrintForm.isLeftToRight ? CalendarForm.cellInsets.right : RTLOffset) : (theDx += PrintForm.isLeftToRight ? width : -width);
        return theDx;
    }

    public Calendar getCurrentPrintDay() {
        Calendar currentPrintDay = Calendar.getInstance();
        currentPrintDay.setFirstDayOfWeek(CalendarUtils.getFirstDayOfWeek() + 1);
        currentPrintDay.set(1, this.startingDay.get(1));
        currentPrintDay.set(2, this.startingDay.get(2));
        currentPrintDay.set(5, this.startingDay.get(5));
        return currentPrintDay;
    }

    protected void drawMonth(Graphics pg, String monthYear, int remX, DayCell[] labelCells, DayCell[] dayCells, Calendar currPrintDay) {
        int monthYearLength = SwingUtilities.computeStringWidth(pg.getFontMetrics(), monthYear);
        int monthYearStringX = monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth() / 2 - monthYearLength / 2 + remX;
        pg.drawString(monthYear, monthYearStringX, -3);
        CalendarForm.initMonthlyCalendarLabelCells(labelCells, currPrintDay);
        CalendarForm.initMonthlyCalendarDayCells(dayCells, labelCells, currPrintDay);
        this.setColorFill(pg);
        pg.fillRect(1 + remX, 1, monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth() - 2, monthlyCalendarFontAttributes.calculateLabelsHeight() - 1);
        pg.setColor(BORDER_COLOR);
        pg.drawRect(1 + remX, 1, monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth() - 2, monthlyCalendarFontAttributes.calculateMonthlyCalendarHeight() - 1);
        pg.drawLine(1 + remX, monthlyCalendarFontAttributes.calculateLabelsHeight() - 1, monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth() - 2 + remX, monthlyCalendarFontAttributes.calculateLabelsHeight() - 1);
        for (int j = 0; j < 7; ++j) {
            DayCell cell = labelCells[j];
            this.drawMonthlyCalendarString(pg, cell.getText(), cell.getBounds(), cell.getForeground(), monthlyCalendarFontAttributes.getFont(), remX);
        }
        int nSize = dayCells.length;
        for (int i = 0; i < nSize; ++i) {
            this.drawMonthlyCalendarCell(pg, dayCells[i], remX);
        }
    }

    public List<IItemList> getListOfItems() {
        return this.listOfItems;
    }

    static {
        cellInsets = new Insets(1, 1, 1, 1);
        BORDER_COLOR = Color.BLACK;
        FILL_COLOR = Color.LIGHT_GRAY;
    }

    protected static class FontCalendarDisplayAttributes {
        private Font font;

        public FontCalendarDisplayAttributes(Font theFont) {
            this.font = theFont;
        }

        public int calculateCellHeight() {
            return this.font.getSize() + 2;
        }

        public int calculateCellWidth() {
            return this.font.getSize() * 2 - 2;
        }

        public int calculateFullHeight() {
            return CalendarForm.cellInsets.top + this.calculateCellHeight() + CalendarForm.cellInsets.bottom;
        }

        public int calculateFullWidth() {
            return CalendarForm.cellInsets.right + this.calculateCellWidth() + CalendarForm.cellInsets.left;
        }

        public int calculateLabelsHeight() {
            return this.font.getSize() + 4;
        }

        public Font getFont() {
            return this.font;
        }

        public int calculateMonthlyCalendarHeight() {
            return this.calculateLabelsHeight() + (CalendarForm.cellInsets.top + this.calculateCellHeight() + CalendarForm.cellInsets.bottom) * 6 + 1;
        }

        public int calculateMonthlyCalendarWidth() {
            return (CalendarForm.cellInsets.right + this.calculateCellWidth() + CalendarForm.cellInsets.left) * 7 + 1;
        }
    }
}

