/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.OrientableStringBuilder;
import com.appframework.mvc.MVCController;
import com.appframework.utils.Day;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarUtils;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingCalendarPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.AbstarctItemBean;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.RollingMonthForm;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageModel {
    private static Logger logger = Logger.getLogger(RollingMonthForm.class);
    private Calendar firstDay;
    private PrintingCalendarPanel printingCalendarPanel;
    private int pageWidth;
    MVCController controller;
    private List<IItemList> listOfItems;
    private CalendarForm form;
    private int[] dayIndices;
    private int numberOfDaysInRow;
    private int firstDayInWeek = 0;

    public PageModel(Calendar pageFirstDay, CalendarForm form) {
        this.firstDay = pageFirstDay;
        this.form = form;
        this.printingCalendarPanel = form.getPrintingCalendarPanel();
        this.listOfItems = form.getListOfItems();
        this.pageWidth = form.getPageWidth();
        this.controller = form.getController();
        this.init();
    }

    private void init() {
        logger.debug((Object)("firstDay: " + DateFormat.getDateInstance(0).format(this.firstDay.getTime())));
        this.numberOfDaysInRow = this.printingCalendarPanel.hasWeekendDays() ? 7 : 5;
        this.dayIndices = new int[this.numberOfDaysInRow];
        int firstDayIndex = CalendarUtils.getFirstDayOfWeek() + 1;
        Calendar temporaryDay = Calendar.getInstance();
        temporaryDay.set(7, firstDayIndex);
        int i = 0;
        while (i < this.dayIndices.length) {
            if (this.numberOfDaysInRow != 5 || temporaryDay.get(7) != 1 && temporaryDay.get(7) != 7) {
                this.dayIndices[CalendarForm.isLeftToRight ? i : this.numberOfDaysInRow - i - 1] = temporaryDay.get(7);
                ++i;
            }
            temporaryDay.roll(7, true);
        }
        if (logger.isDebugEnabled()) {
            for (i = 0; i < this.dayIndices.length; ++i) {
                logger.debug((Object)("dayIndices[" + i + "]: " + this.dayIndices[i]));
            }
        }
        this.form.getItems();
    }

    public int getNumberOfDaysInRow() {
        return this.numberOfDaysInRow;
    }

    public int getWeekDayIndexForColumn(int columnIndex) {
        if (columnIndex < 0 && columnIndex > 6) {
            throw new IllegalArgumentException("illegal columnIndex: " + columnIndex);
        }
        return this.dayIndices[columnIndex];
    }

    public boolean isWeekLabeled(int weekIndex) {
        if (weekIndex < 0 || weekIndex > 3) {
            throw new IllegalArgumentException("illegal weekIndex: " + weekIndex);
        }
        boolean result = false;
        if (weekIndex == 0) {
            result = true;
        } else {
            Calendar[] days = this.getAllWeekDays(weekIndex);
            if (this.numberOfDaysInRow == 5) {
                for (Calendar day : days) {
                    if (this.isWeekendDay(day.get(7))) continue;
                    if (day.get(5) == 1) {
                        result = true;
                        this.firstDayInWeek = 1;
                        break;
                    }
                    if (day.get(5) != 3) continue;
                    result = true;
                    this.firstDayInWeek = 3;
                    break;
                }
            }
            if (this.numberOfDaysInRow == 7) {
                for (Calendar day : days) {
                    if (day.get(5) != 1) continue;
                    result = true;
                    this.firstDayInWeek = 1;
                    break;
                }
            }
        }
        return result;
    }

    public String getMonthLabel(int weekIndex) {
        if (weekIndex < 0 || weekIndex > 3) {
            throw new IllegalArgumentException("illegal weekIndex: " + weekIndex);
        }
        String label = null;
        if (this.isWeekLabeled(weekIndex)) {
            int i;
            ArrayList<Calendar> days = new ArrayList<Calendar>();
            days.addAll(Arrays.asList(this.getAllWeekDays(weekIndex)));
            String month = "";
            int year = 0;
            boolean found = false;
            for (i = 6; i >= 0; --i) {
                int dayOfMonth = ((Calendar)days.get(i)).get(5);
                if (dayOfMonth != this.firstDayInWeek) continue;
                month = GWCalendarUtils.monthNames[((Calendar)days.get(i)).get(2)];
                year = ((Calendar)days.get(i)).get(1);
                found = true;
                break;
            }
            if (this.numberOfDaysInRow == 5) {
                for (i = 6; i >= 0; --i) {
                    int dayOfWeek = ((Calendar)days.get(i)).get(7);
                    if (dayOfWeek != 7 && dayOfWeek != 1) continue;
                    days.remove(i);
                }
            }
            if (!found) {
                month = GWCalendarUtils.monthNames[((Calendar)days.get(this.numberOfDaysInRow - 1)).get(2)];
                year = ((Calendar)days.get(this.numberOfDaysInRow - 1)).get(1);
            }
            label = month + ' ' + year;
        }
        return label;
    }

    public boolean isWeekendDay(int dayOfWeek) {
        return dayOfWeek == 7 || dayOfWeek == 1;
    }

    private Calendar[] getAllWeekDays(int weekIndex) {
        assert (weekIndex >= 0 && weekIndex < 4) : "illegal weekIndex: " + weekIndex;
        Calendar[] days = new Calendar[7];
        for (int i = 0; i < 7; ++i) {
            days[i] = (Calendar)this.firstDay.clone();
            days[i].add(7, 7 * weekIndex + i);
        }
        return days;
    }

    public Calendar[] getWeekDays(int weekIndex) {
        if (weekIndex < 0 || weekIndex > 3) {
            throw new IllegalArgumentException("illegal weekIndex: " + weekIndex);
        }
        ArrayList<Calendar> days = new ArrayList<Calendar>();
        days.addAll(Arrays.asList(this.getAllWeekDays(weekIndex)));
        if (this.numberOfDaysInRow == 5) {
            for (int i = 6; i >= 0; --i) {
                int dayOfWeek = ((Calendar)days.get(i)).get(7);
                if (dayOfWeek != 7 && dayOfWeek != 1) continue;
                days.remove(i);
            }
            assert (days.size() == 5) : "weekend days not removed";
        }
        if (!CalendarForm.isLeftToRight) {
            Collections.reverse(days);
        }
        return days.toArray(new Calendar[this.numberOfDaysInRow]);
    }

    public int getColumnWidth(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.numberOfDaysInRow) {
            throw new IllegalArgumentException("cilumnIndex out of range [0, " + (this.numberOfDaysInRow - 1) + "]: " + columnIndex);
        }
        int columnWidth = this.pageWidth / this.numberOfDaysInRow;
        if (columnIndex == this.numberOfDaysInRow - 1) {
            columnWidth = this.pageWidth - columnWidth * (this.numberOfDaysInRow - 1);
        }
        return columnWidth;
    }

    public List<AbstarctItemBean> getAppointments(Calendar day) {
        PrintingCalendarPanel optionPanel = this.printingCalendarPanel;
        ArrayList<AbstarctItemBean> appointmentsList = new ArrayList<AbstarctItemBean>();
        if (optionPanel.hasAppointments()) {
            ArrayList<AbstractCalendarItem> appointments = new ArrayList<AbstractCalendarItem>();
            for (IItemList itemList : this.listOfItems) {
                appointments.addAll(GWCalendarUtils.getAppointments(itemList, new Day(day)));
            }
            for (AbstractCalendarItem item : appointments) {
                AppointmentItem appointment = (AppointmentItem)item;
                if (!optionPanel.hasPrivateCalendarItems() && appointment.isPersonal()) continue;
                OrientableStringBuilder builder = new OrientableStringBuilder(CalendarForm.isLeftToRight);
                if (optionPanel.hasAppointmentsStart() || optionPanel.hasAppointmentsEnd()) {
                    builder.append(CalendarForm.isLeftToRight ? (char)'(' : ')');
                    if (optionPanel.hasAppointmentsStart()) {
                        builder.append(OptionManager.getInstance().getDateTimeOptions().getTime(appointment.getStartDate()));
                    }
                    if (optionPanel.hasAppointmentsStart() && optionPanel.hasAppointmentsEnd()) {
                        builder.append(" - ");
                    }
                    if (optionPanel.hasAppointmentsEnd()) {
                        builder.append(OptionManager.getInstance().getDateTimeOptions().getTime(appointment.getEndDate()));
                    }
                    builder.append(CalendarForm.isLeftToRight ? ") " : " (");
                }
                builder.append(appointment.getSubject());
                builder.append(' ');
                if (optionPanel.hasAppointmentsFrom()) {
                    builder.append(StringResources.FROM_C);
                    builder.append(' ');
                    builder.append(appointment.getSenderID());
                    builder.append(' ');
                }
                if (optionPanel.hasAppointmentsPlace()) {
                    builder.append(CalendarForm.isLeftToRight ? (char)'(' : ')');
                    builder.append(appointment.getPlace());
                    builder.append(CalendarForm.isLeftToRight ? ") " : " (");
                }
                if (optionPanel.hasAppointmentsMessage()) {
                    builder.append(UIUtils.getShortCutText(appointment.getMessage().getPlainText(), 50));
                }
                logger.debug((Object)("string: " + builder.toString()));
                appointmentsList.add(new AbstarctItemBean(appointment, builder.toString()));
            }
        }
        return appointmentsList;
    }

    public List<AbstarctItemBean> getTasks(Calendar day) {
        PrintingCalendarPanel optionPanel = this.printingCalendarPanel;
        ArrayList<AbstarctItemBean> tasksList = new ArrayList<AbstarctItemBean>();
        if (optionPanel.hasTasks()) {
            ArrayList<AbstractItem> tasks = new ArrayList<AbstractItem>();
            for (IItemList itemList : this.listOfItems) {
                tasks.addAll(GWCalendarUtils.getTasks(itemList, new Day(day)));
            }
            for (AbstractItem task : tasks) {
                if (!optionPanel.hasPrivateCalendarItems() && task.isPrivate() || !optionPanel.hasCompletedTasks() && task.isStatusCompleted()) continue;
                OrientableStringBuilder builder = new OrientableStringBuilder(CalendarForm.isLeftToRight);
                if (optionPanel.hasTasksPriority()) {
                    if (task.getPriority() == 4) {
                        builder.append(StringResources.HIGH);
                    }
                    if (task.getPriority() == 1) {
                        builder.append(StringResources.LOW);
                    }
                    if (task.getPriority() == 2) {
                        builder.append(StringResources.STANDARD_SHORT);
                    }
                    builder.append(' ');
                }
                builder.append(task.getSubject());
                builder.append(' ');
                if (optionPanel.hasTasksFrom()) {
                    builder.append(StringResources.FROM_C);
                    builder.append(' ');
                    builder.append(task.getSenderID());
                    builder.append(' ');
                }
                if (optionPanel.hasTasksStart()) {
                    builder.append(StringResources.START_C);
                    builder.append(' ');
                    builder.append(OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(task.getDate()));
                    builder.append(' ');
                }
                if (optionPanel.hasTasksDue()) {
                    builder.append(StringResources.DUE_C);
                    builder.append(' ');
                    builder.append(OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(new Date(task.getDueDate())));
                    builder.append(' ');
                }
                if (optionPanel.hasAppointmentsMessage()) {
                    builder.append(UIUtils.getShortCutText(task.getMessage().getPlainText(), 50));
                }
                logger.debug((Object)("string: " + builder.toString()));
                tasksList.add(new AbstarctItemBean(task, builder.toString()));
            }
        }
        return tasksList;
    }

    public List<AbstarctItemBean> getNotes(Calendar day) {
        PrintingCalendarPanel optionPanel = this.printingCalendarPanel;
        ArrayList<AbstarctItemBean> notesList = new ArrayList<AbstarctItemBean>();
        if (optionPanel.hasNotes()) {
            ArrayList<AbstractCalendarItem> notes = new ArrayList<AbstractCalendarItem>();
            for (IItemList itemList : this.listOfItems) {
                notes.addAll(GWCalendarUtils.getNotes(itemList, new Day(day)));
            }
            for (AbstractCalendarItem item : notes) {
                ReminderNote note = (ReminderNote)item;
                if (!optionPanel.hasPrivateCalendarItems() && note.isPrivate()) continue;
                OrientableStringBuilder builder = new OrientableStringBuilder(CalendarForm.isLeftToRight);
                builder.append(note.getSubject());
                builder.append(' ');
                if (optionPanel.hasNotesFrom()) {
                    builder.append(StringResources.FROM_C);
                    builder.append(' ');
                    builder.append(note.getSenderID());
                    builder.append(' ');
                }
                if (optionPanel.hasNotesMessage()) {
                    builder.append(UIUtils.getShortCutText(note.getMessage().getPlainText(), 50));
                }
                logger.debug((Object)("string: " + builder.toString()));
                notesList.add(new AbstarctItemBean(note, builder.toString()));
            }
        }
        return notesList;
    }

    public List<AbstarctItemBean> getAllDayEvents(Calendar day) {
        PrintingCalendarPanel optionPanel = this.printingCalendarPanel;
        ArrayList<AbstarctItemBean> allDayEventsList = new ArrayList<AbstarctItemBean>();
        if (optionPanel.hasAllDayEvents()) {
            ArrayList<AbstractCalendarItem> appointments = new ArrayList<AbstractCalendarItem>();
            for (IItemList itemList : this.listOfItems) {
                appointments.addAll(GWCalendarUtils.getAllDayEvents(itemList, day.getTime()));
            }
            for (AbstractCalendarItem item : appointments) {
                AppointmentItem appointment = (AppointmentItem)item;
                if (!optionPanel.hasPrivateCalendarItems() && appointment.isPrivate()) continue;
                OrientableStringBuilder builder = new OrientableStringBuilder(CalendarForm.isLeftToRight);
                builder.append(CalendarForm.isLeftToRight ? (char)'(' : ')');
                builder.append(StringResources.ALL_DAY_EVENT);
                builder.append(CalendarForm.isLeftToRight ? (char)')' : '(');
                builder.append(' ');
                builder.append(appointment.getSubject());
                logger.debug((Object)("string: " + builder.toString()));
                allDayEventsList.add(new AbstarctItemBean(appointment, builder.toString()));
            }
        }
        return allDayEventsList;
    }

    public PrintingCalendarPanel getPrintingCalendarPanel() {
        return this.printingCalendarPanel;
    }
}

