/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingCalendarPanel;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.AbstarctItemBean;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.MonthForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.PageModel;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.PrintCalendarUtils;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class RollingMonthForm
extends MonthForm {
    private static Logger logger = Logger.getLogger(RollingMonthForm.class);
    private static final int VERTICAL_INSET = 3;
    private final Font monthNameFont = new Font(FNT_PLAIN.getFontName(), 0, 12);
    private boolean isExtraPagesExists = false;
    private boolean isCopyEnabled = true;
    private int monthsForPrinting = 1;
    private int monthCount = 1;
    private int additionalPages = 0;
    private Calendar startDateForPrinting;
    private List<AbstarctItemBean> remainedAbstractItems = new ArrayList<AbstarctItemBean>();
    private static final int DISTANCE_FROM_EDGE = 10;

    public RollingMonthForm(MVCController parentController) {
        super(parentController);
    }

    public String toString() {
        return StringResources.ROLLING_MONTH;
    }

    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_MONTH_ROLLING;
    }

    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        super.print(pg, pageFormat, pageIndex);
        this.monthsForPrinting = this.getPrintingCalendarPanel().getDaysForPrinting();
        if (this.calendarOptionsPanel.isInsertBlankPage() && pageIndex == 0) {
            return 0;
        }
        if (this.calendarOptionsPanel.isInsertBlankPage()) {
            --pageIndex;
        }
        this.currPrintDay = this.getPrintingCalendarPanel().getStartingDay();
        if (this.isCopyEnabled) {
            this.startDateForPrinting = (Calendar)this.currPrintDay.clone();
            this.isCopyEnabled = false;
        }
        if (this.monthCount > 1) {
            this.currPrintDay.setTimeInMillis(this.currPrintDay.getTime().getTime() + MONTH_IN_MILLISECONDS);
        }
        this.setStartingDay(this.currPrintDay);
        PrintCalendarUtils utils = new PrintCalendarUtils();
        this.getPrintingCalendarPanel().setStartingDay(this.currPrintDay);
        PageModel pageModel = utils.getPageModel(pageIndex, this.additionalPages + this.monthsForPrinting, this);
        if (pageModel == null) {
            this.isExtraPagesExists = false;
            this.additionalPages = 0;
            this.monthCount = 1;
            this.remainedAbstractItems.clear();
            this.getPrintingCalendarPanel().setStartingDay(this.startDateForPrinting);
            return 1;
        }
        CalendarForm.RTLOffset = 0;
        this.printPreviousMonthCalendar(pg, (int)pg.getClipBounds().getWidth());
        this.printNextMonthCalendar(pg, (int)pg.getClipBounds().getWidth());
        if (!this.isExtraPagesExists) {
            int y = monthlyCalendarFontAttributes.calculateMonthlyCalendarHeight() + 10;
            this.printCurrentMonth(pg, pageModel, y);
        } else {
            this.printAdditionalItems(pg);
        }
        int countOfAppointments = 0;
        if (this.remainedAbstractItems != null) {
            countOfAppointments = this.remainedAbstractItems.size();
        }
        if (this.isReplaceExtraText()) {
            if (countOfAppointments > 0) {
                this.isExtraPagesExists = true;
                ++this.additionalPages;
            } else {
                this.isExtraPagesExists = false;
                if (this.monthCount < this.monthsForPrinting) {
                    ++this.monthCount;
                    this.remainedAbstractItems.clear();
                }
            }
        } else {
            this.isExtraPagesExists = false;
            if (this.monthCount < this.monthsForPrinting) {
                ++this.monthCount;
                this.remainedAbstractItems.clear();
            }
        }
        return 0;
    }

    private void printCurrentMonth(Graphics pg, PageModel pageModel, int y) {
        pg.drawRect(0, y, this.pageWidth, this.getClipHeight(pg) - y);
        ++y;
        y = this.printDayNames(pg, pageModel, y);
        pg.setFont(this.monthNameFont);
        HashMap<Integer, String> monthLabels = new HashMap<Integer, String>(2);
        int monthLabelsHeight = 0;
        for (int i = 0; i < 4; ++i) {
            String label = pageModel.getMonthLabel(i);
            if (label == null) continue;
            monthLabels.put(i, label);
            monthLabelsHeight += (int)pg.getFontMetrics().getStringBounds(label, pg).getHeight();
        }
        int heightLeft = this.getClipHeight(pg) - y - this.footerHeight;
        int weekHeight = (heightLeft - (monthLabelsHeight += 6 * monthLabels.size())) / 4;
        for (int i = 0; i < 4; ++i) {
            if (monthLabels.get(i) != null) {
                y = this.printMonthLabel(pg, y, (String)monthLabels.get(i));
            }
            y = this.printWeek(pg, pageModel, y, weekHeight, i);
        }
    }

    private int printWeek(Graphics pg, PageModel pageModel, int y, int height, int weekIndex) {
        int endY = y + height;
        logger.debug((Object)("week: " + weekIndex + ", end Y: " + endY));
        assert (endY <= this.getClipHeight(pg)) : "below printable area, exceeded " + (endY - this.getClipHeight(pg)) + " pixels";
        Calendar[] days = pageModel.getWeekDays(weekIndex);
        int columnCount = days.length;
        pg.drawLine(0, endY, this.pageWidth, endY);
        int startX = 0;
        PrintCalendarUtils util = new PrintCalendarUtils();
        for (int i = 0; i < columnCount; ++i) {
            int endX = pageModel.getColumnWidth(i) + startX;
            pg.drawLine(startX, y, startX, endY);
            Rectangle dayRectangle = new Rectangle(startX + 1, y + 1, endX - startX - 1, endY - y - 1);
            Font previousFont = pg.getFont();
            pg.setFont(CalendarForm.chosenFont);
            util.printDay(pg, pageModel, days[i], dayRectangle, this, false);
            pg.setFont(previousFont);
            startX = endX;
        }
        this.remainedAbstractItems.addAll(util.getRemainedBeans());
        return endY;
    }

    protected void changeDateValues(Calendar day) {
        this.dateMonth = GWCalendarUtils.monthNames[day.get(2)];
        this.dateYear = String.valueOf(day.get(1));
    }

    boolean pageExists(int pageIndex) {
        boolean pageExist = true;
        PrintCalendarUtils utils = new PrintCalendarUtils();
        this.getPrintingCalendarPanel().setStartingDay(this.currPrintDay);
        PageModel pageModel = utils.getPageModel(pageIndex, this.additionalPages + this.monthsForPrinting, this);
        if (pageModel == null) {
            this.isExtraPagesExists = false;
            this.additionalPages = 0;
            this.monthCount = 1;
            this.remainedAbstractItems.clear();
            this.getPrintingCalendarPanel().setStartingDay(this.startDateForPrinting);
            pageExist = false;
        }
        return pageExist;
    }

    public void printAdditionalItems(Graphics pg) {
        pg.setFont(CalendarForm.chosenFont);
        pg.translate(0, 20);
        int additionalPageHeight = this.getClipHeight(pg) - (monthlyCalendarFontAttributes.calculateMonthlyCalendarHeight() + 10);
        pg.drawRect(0, 90, this.pageWidth, additionalPageHeight);
        ArrayList<AbstarctItemBean> ra = new ArrayList<AbstarctItemBean>();
        int y = 110;
        Date dateForPrinting = new Date();
        String strDateForPrinting = new SimpleDateFormat("dd MMMM").format(dateForPrinting);
        for (AbstarctItemBean bean : this.remainedAbstractItems) {
            ra.add(bean);
            PrintingCalendarPanel optionPanel = printingCalendarPanel;
            String date = new SimpleDateFormat("dd MMMM").format(bean.getItem().getDate());
            if (!strDateForPrinting.equals(date)) {
                strDateForPrinting = date;
                pg.drawString(strDateForPrinting, 10, y);
                y += CalendarForm.chosenFontCellHeight;
            }
            String string = "";
            if (optionPanel.hasAppointmentsStart() && optionPanel.hasAppointmentsEnd()) {
                string = string + "(" + PrintCalendarUtils.getCorrectTimeString(bean.getStartDate()) + "-" + PrintCalendarUtils.getCorrectTimeString(bean.getEndDate()) + ") ";
            } else {
                if (optionPanel.hasAppointmentsEnd()) {
                    string = string + "(" + PrintCalendarUtils.getCorrectTimeString(bean.getEndDate()) + ") ";
                }
                if (optionPanel.hasAppointmentsStart()) {
                    string = string + "(" + PrintCalendarUtils.getCorrectTimeString(bean.getStartDate()) + ") ";
                }
            }
            String subject = bean.getItem().getSubject();
            if (!"".equals(subject)) {
                string = string + " " + subject;
            }
            if (optionPanel.hasAppointmentsFrom()) {
                string = string + ", " + StringResources.FROM_C + bean.getItem().getSender().getEmailAddress();
            }
            if (bean.getItem() instanceof AppointmentItem && optionPanel.hasAppointmentsPlace()) {
                string = string + " (" + ((AppointmentItem)bean.getItem()).getPlace() + ") ";
            }
            y = this.printStringLineByLine(pg, string, 0, y, this.pageWidth, CategoryUtils.getPrimaryTextColor(bean.getItem().getCategories()), bean.getItem().getCalendarDisplayColor());
            if (optionPanel.hasAppointmentsMessage()) {
                y = this.printStringLineByLine(pg, bean.getItem().getMessage().getPlainText(), 0, y, this.pageWidth, CategoryUtils.getPrimaryTextColor(bean.getItem().getCategories()), bean.getItem().getCalendarDisplayColor());
            }
            if ((y += CalendarForm.chosenFontCellHeight) < this.getClipHeight(pg) - 10) continue;
            break;
        }
        if (this.remainedAbstractItems != null) {
            this.remainedAbstractItems.removeAll(ra);
        }
    }
}

