/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingCalendarPanel;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.AbstarctItemBean;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.PageModel;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.PrintCalendarUtils;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.WeekAndDayForm;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class WeekTrifold
extends WeekAndDayForm {
    private boolean isExtraPagesExists = false;
    private boolean printNotes = true;
    private boolean printTasks = true;
    private boolean printAppointments = true;
    private int additionalPages = 0;
    private int numberOfWeek = 1;
    private int weeksForPrinting = 0;
    private List<AbstarctItemBean> remainedAppointments;
    private final Font weeksFont = new Font(PrintForm.FNT_PLAIN.getFontName(), 0, 9);

    public WeekTrifold(MVCController theParentController) {
        super(theParentController);
    }

    public String toString() {
        return StringResources.WEEK_TRIFOLD_LANDSCAPE;
    }

    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_WEEK_TRIFOLD_LANDSCAPE;
    }

    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int h = super.print(pg, pageFormat, pageIndex);
        this.weeksForPrinting = this.getPrintingCalendarPanel().getDaysForPrinting();
        if (this.calendarOptionsPanel.isInsertBlankPage() && pageIndex == 0) {
            return 0;
        }
        if (this.calendarOptionsPanel.isInsertBlankPage()) {
            --pageIndex;
        }
        if (pageIndex > this.additionalPages + this.weeksForPrinting - 1) {
            this.numberOfWeek = 1;
            this.additionalPages = 0;
            this.isExtraPagesExists = false;
            this.printNotes = true;
            this.printTasks = true;
            this.printAppointments = true;
            return 1;
        }
        this.currPrintDay = this.getPrintingCalendarPanel().getStartingDay();
        this.currPrintDay.setTimeInMillis(this.currPrintDay.getTime().getTime() + WEEK_IN_MILLISECONDS * (long)(this.numberOfWeek - 1));
        this.changeDateValues(this.currPrintDay);
        int heightFont = pg.getFontMetrics().getHeight();
        Calendar endDate = Calendar.getInstance();
        endDate.setTimeInMillis(((Calendar)this.currPrintDay.clone()).getTime().getTime() + WEEK_IN_MILLISECONDS);
        String dateRange = StringResources.formatString(StringResources.DATE_RANGE_FOR_PRINT, String.valueOf(this.currPrintDay.get(5)), GWCalendarUtils.monthNames[this.currPrintDay.get(2)], String.valueOf(endDate.get(5)), GWCalendarUtils.monthNames[endDate.get(2)]);
        pg.drawString(dateRange, isLeftToRight ? this.pageWidth - SwingUtilities.computeStringWidth(pg.getFontMetrics(), dateRange) : 0, -this.commonHeaderH + pg.getFontMetrics().getAscent());
        int notesTasksWidth = this.pageWidth / 3 - 6;
        pg.translate(this.pageWidth / 3 + 2, 0);
        int width = SwingUtilities.computeStringWidth(pg.getFontMetrics(), StringResources.APPOINTMENTS);
        pg.drawString(StringResources.APPOINTMENTS, this.pageWidth / 6 - width / 2, -heightFont / 2);
        if (!this.isExtraPagesExists) {
            this.printAppointments(pg, notesTasksWidth, this.pageHeight - this.footerHeight - this.translateY, pageIndex);
        } else if (this.printAppointments) {
            this.printAdditionalAppointments(pg, notesTasksWidth, this.pageHeight - this.footerHeight - this.translateY);
        }
        int countOfAppointments = 0;
        if (this.remainedAppointments != null) {
            countOfAppointments = this.remainedAppointments.size();
        }
        pg.translate(-this.pageWidth / 3 - 2, 0);
        PrintCalendarUtils util = new PrintCalendarUtils();
        util.drawMonthCalendar(pg, pageFormat, this.currPrintDay, this);
        int y = monthlyCalendarFontAttributes.calculateMonthlyCalendarHeight();
        pg.translate(0, y + h + 20);
        int notesTasksHeight = this.pageHeight - y - 50 - monthlyCalendarFontAttributes.calculateMonthlyCalendarHeight();
        pg.translate(isLeftToRight ? 0 : 2 * this.pageWidth / 3 + 3, 0);
        int countOfTasks = 0;
        if (this.printTasks) {
            countOfTasks = this.printTasks(pg, notesTasksHeight, notesTasksWidth, true, this.isExtraPagesExists, true).size();
        }
        pg.translate(0, -10);
        pg.translate(isLeftToRight ? 0 : -(2 * this.pageWidth / 3 + 3), 0);
        if (isLeftToRight) {
            pg.translate(2 * this.pageWidth / 3 + 3, 0);
        }
        int countOfNotes = 0;
        if (this.printNotes) {
            countOfNotes = this.printNotes(pg, notesTasksHeight, notesTasksWidth, true, this.isExtraPagesExists).size();
        }
        if (this.isReplaceExtraText()) {
            if (countOfNotes == 0) {
                this.printNotes = false;
            }
            if (countOfTasks == 0) {
                this.printTasks = false;
            }
            if (countOfAppointments == 0) {
                this.printAppointments = false;
            }
            if (countOfTasks > 0 || countOfNotes > 0 || countOfAppointments > 0) {
                this.isExtraPagesExists = true;
                ++this.additionalPages;
            } else {
                this.isExtraPagesExists = false;
                this.printNotes = true;
                this.printTasks = true;
                this.printAppointments = true;
                if (this.numberOfWeek < this.weeksForPrinting) {
                    ++this.numberOfWeek;
                }
            }
        } else {
            this.isExtraPagesExists = false;
            if (this.numberOfWeek < this.weeksForPrinting) {
                ++this.numberOfWeek;
            }
        }
        return 0;
    }

    private void printAppointments(Graphics pg, int width, int height, int pageIndex) {
        int startX = 0;
        boolean hasWeekEnd = printingCalendarPanel.hasWeekendDays();
        int days = hasWeekEnd ? 7 : 5;
        int endY = height / days;
        Rectangle dayRectangle = new Rectangle(startX + 1, 1, width - startX - 1, endY - 1);
        Calendar day = (Calendar)this.currPrintDay.clone();
        PrintCalendarUtils util = new PrintCalendarUtils();
        PageModel pageModel = util.getPageModel(pageIndex, this.additionalPages + this.weeksForPrinting, this);
        for (int i = 0; i < days; ++i) {
            this.setCorrectNextDay(hasWeekEnd, day);
            this.setCorrectNextDay(hasWeekEnd, day);
            pg.translate(0, i * height / days);
            pg.drawRect(startX, 0, width - startX, (i + 1) * height / days - i * height / days);
            Font previousFont = pg.getFont();
            pg.setFont(CalendarForm.chosenFont);
            util.printDay(pg, pageModel, day, dayRectangle, this, true);
            pg.setFont(previousFont);
            pg.translate(0, -(i * height) / days);
            day.setTimeInMillis(day.getTime().getTime() + DAY_IN_MILLISECONS);
        }
        this.remainedAppointments = util.getRemainedBeans();
    }

    private void printAdditionalAppointments(Graphics pg, int width, int height) {
        pg.setFont(this.weeksFont);
        pg.translate(0, 20);
        pg.drawRect(0, 0, width, height);
        ArrayList<AbstarctItemBean> ra = new ArrayList<AbstarctItemBean>();
        int y = 20;
        Date dateForPrinting = new Date();
        String strDateForPrinting = new SimpleDateFormat("dd MMMM").format(dateForPrinting);
        Font previousFont = pg.getFont();
        pg.setFont(CalendarForm.chosenFont);
        for (int j = 0; j < this.remainedAppointments.size(); ++j) {
            AbstarctItemBean bean = this.remainedAppointments.get(j);
            ra.add(bean);
            PrintingCalendarPanel optionPanel = printingCalendarPanel;
            String date = new SimpleDateFormat("dd MMMM").format(bean.getItem().getDate());
            if (!strDateForPrinting.equals(date)) {
                strDateForPrinting = date;
                pg.drawString(strDateForPrinting, 10, y);
                y += CalendarForm.chosenFontCellHeight;
            }
            String string = "";
            if (optionPanel.hasAppointmentsStart() && optionPanel.hasAppointmentsEnd()) {
                string = string + "(" + PrintCalendarUtils.getCorrectTimeString(bean.getStartDate()) + "-" + PrintCalendarUtils.getCorrectTimeString(bean.getEndDate()) + ") ";
            } else {
                if (optionPanel.hasAppointmentsEnd()) {
                    string = string + "(" + PrintCalendarUtils.getCorrectTimeString(bean.getEndDate()) + ") ";
                }
                if (optionPanel.hasAppointmentsStart()) {
                    string = string + "(" + PrintCalendarUtils.getCorrectTimeString(bean.getStartDate()) + ") ";
                }
            }
            String subject = bean.getItem().getSubject();
            if (!"".equals(subject)) {
                string = string + " " + subject;
            }
            if (optionPanel.hasAppointmentsFrom()) {
                string = string + ", " + StringResources.FROM_C + bean.getItem().getSender();
            }
            if (optionPanel.hasAppointmentsPlace()) {
                string = string + " (" + ((AppointmentItem)bean.getItem()).getPlace() + ") ";
            }
            y = this.printStringLineByLine(pg, string, 0, y, width, CategoryUtils.getPrimaryTextColor(bean.getItem().getCategories()), bean.getItem().getCalendarDisplayColor());
            if (optionPanel.hasAppointmentsMessage()) {
                y = this.printStringLineByLine(pg, bean.getItem().getMessage().getPlainText(), 0, y, width, CategoryUtils.getPrimaryTextColor(bean.getItem().getCategories()), bean.getItem().getCalendarDisplayColor());
            }
            if ((y += CalendarForm.chosenFontCellHeight) >= height - 100) break;
        }
        pg.setFont(previousFont);
        if (this.remainedAppointments != null) {
            this.remainedAppointments.removeAll(ra);
        }
    }

    private void setCorrectNextDay(boolean hasWeekEnd, Calendar day) {
        if (!(hasWeekEnd || day.get(7) != 7 && day.get(7) != 1)) {
            day.setTimeInMillis(day.getTime().getTime() + DAY_IN_MILLISECONS);
        }
    }

    protected void changeDateValues(Calendar day) {
        this.dateMonth = GWCalendarUtils.monthNames[day.get(2)];
        this.dateYear = String.valueOf(day.get(1));
    }

    boolean pageExists(int pageIndex) {
        boolean pageExist = true;
        int weeks = this.getPrintingCalendarPanel().getDaysForPrinting();
        int pseudoPageIndex = pageIndex;
        if (this.calendarOptionsPanel.isInsertBlankPage()) {
            --pseudoPageIndex;
        }
        if (pseudoPageIndex > this.additionalPages + weeks - 1) {
            this.numberOfWeek = 1;
            this.additionalPages = 0;
            this.isExtraPagesExists = false;
            this.printNotes = true;
            this.printTasks = true;
            this.printAppointments = true;
            pageExist = false;
        }
        return pageExist;
    }
}

