/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingitem;

import com.appframework.cache.IdentifiedObject;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.printing.BasicPrintManager;
import com.novell.gw.jclient.application.printing.basicforms.GWItemForm;
import com.novell.gw.jclient.application.printing.basicforms.HTMLAttachmentPrintForm;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.basicforms.TextPrintForm;
import com.novell.gw.jclient.application.printing.printingitem.ItemChecksPanel;
import com.novell.gw.jclient.application.printing.printingitem.ItemPrintManagerController;
import com.novell.gw.jclient.application.printing.printingitem.printforms.AppointmentForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.AttachmentPrintForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.GWItemHTMLPrintForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.GWItemPropertiesHTMLPrintForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.MailForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.PhoneForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.ReminderNoteForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.TaskForm;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemPrintManager
extends BasicPrintManager {
    private static Logger logger = Logger.getLogger(ItemPrintManager.class);
    private AbstractItem item;
    private Object selectedAttachment;
    private ItemChecksPanel itemChecksPanel;

    public ItemPrintManager(MVCController theParentController) {
        this(theParentController, null);
    }

    public ItemPrintManager(MVCController theParentController, Object theSelectedAttachment) {
        this(theParentController, theSelectedAttachment, false);
    }

    public ItemPrintManager(MVCController theParentController, Object theSelectedAttachment, boolean propertiesSelected) {
        this.setController(new ItemPrintManagerController(this, theParentController));
        this.selectedAttachment = theSelectedAttachment;
        this.setPropertiesSelected(propertiesSelected);
        this.buildUI();
    }

    private void buildUI() {
        this.buildSelectionPanel();
        this.buildContentPanel();
        this.lstPrintingItems.addListSelectionListener(new LstPrintingItemsChanged());
        this.lstPrintingForms.addListSelectionListener(new LstPrintingFormsChanged());
    }

    @Override
    protected void buildContentPanel() {
        this.itemChecksPanel = new ItemChecksPanel(this.getController());
        this.add(StringResources.CONTENTS, this.itemChecksPanel);
    }

    private void refreshSelectionPanel() {
        this.vPrintingItems = this.getPrintItems(this.item);
        this.lstPrintingItems.setListData(this.vPrintingItems);
        if (this.selectedAttachment != null) {
            this.lstPrintingItems.setSelectedValue(this.selectedAttachment, true);
        }
        if (this.lstPrintingItems.getSelectedIndex() == -1) {
            this.lstPrintingItems.setSelectedIndex(0);
        }
        this.lstPrintingForms.setListData(this.getPrintForms(this.lstPrintingItems.getSelectedValue()));
        this.lstPrintingForms.setSelectedIndex(0);
        this.pnlListSelection.validate();
    }

    private Vector getPrintItems(AbstractItem<IMessage> item) {
        Vector<IdentifiedObject> vector = new Vector<IdentifiedObject>();
        if (item == null) {
            return vector;
        }
        vector.add(item);
        if (this.propertiesSelected) {
            return vector;
        }
        for (GWAttachment attachment : item.getAttachments()) {
            if (attachment.isSystemAttachment()) continue;
            if (attachment.isMessageAttachment()) {
                try {
                    String userGuid = ControlsUtils.getUserGuid(this.controller);
                    AbstractItem it = GWCommandManager.getInstance(userGuid).getEnclosedItem(attachment);
                    vector.add(it);
                }
                catch (GWCommandException e) {
                    logger.error((Object)e, (Throwable)e);
                    ErrorDialog.processGWException(e, this);
                }
                continue;
            }
            vector.add(attachment);
        }
        return vector;
    }

    public Vector getPrintForms(Object theObject) {
        if (theObject instanceof AbstractItem) {
            if (this.propertiesSelected) {
                Vector<GWItemPropertiesHTMLPrintForm> v = new Vector<GWItemPropertiesHTMLPrintForm>();
                v.add(new GWItemPropertiesHTMLPrintForm((AbstractItem)theObject, this.itemChecksPanel, ControlsUtils.getUserGuid(this.controller)));
                return v;
            }
            return this.getGWItemPrintForms((AbstractItem)theObject);
        }
        if (theObject instanceof GWAttachment) {
            Vector<PrintForm> v;
            block12: {
                v = new Vector<PrintForm>();
                GWAttachment att = (GWAttachment)theObject;
                try {
                    File file = ControlsUtils.getAttachmentFilePath(att);
                    if (!file.exists()) {
                        GWEngineUtils.saveAttachment(att, file.getAbsolutePath());
                    }
                    String extension = Utils.getExtention(att.getFileName());
                    String userGuid = ControlsUtils.getUserGuid(this.controller);
                    if (ControlsUtils.isHTML(extension)) {
                        v.add(new HTMLAttachmentPrintForm(file.toURL(), this.itemChecksPanel, userGuid));
                        break block12;
                    }
                    if (ControlsUtils.isText(extension)) {
                        String theText = "";
                        try {
                            int c;
                            FileReader reader = new FileReader(file);
                            while ((c = reader.read()) != -1) {
                                theText = theText + (char)c;
                            }
                        }
                        catch (IOException e) {
                            logger.error((Object)StringResources.ERROR_WHILE_READING_ATTACHMENT_FILE, (Throwable)e);
                        }
                        v.add(new TextPrintForm(theText, this.itemChecksPanel, userGuid));
                        break block12;
                    }
                    v.add(new AttachmentPrintForm(att.getFileName(), this.getController(), this.itemChecksPanel));
                }
                catch (GWCommandException e) {
                    logger.error((Object)e, (Throwable)e);
                    ErrorDialog.processGWException(e);
                }
                catch (MalformedURLException me) {
                    logger.error((Object)me, (Throwable)me);
                }
            }
            return v;
        }
        return new Vector();
    }

    private Vector getGWItemPrintForms(AbstractItem theItem) {
        Vector<Object> v = new Vector<Object>();
        String message = theItem.getMessage().getMessage();
        if (theItem.isHTMLMessage() || message.toLowerCase().contains("<body")) {
            String userGuid = ControlsUtils.getUserGuid(this.controller);
            v.add(new GWItemHTMLPrintForm(theItem, this.itemChecksPanel, userGuid));
            return v;
        }
        if (theItem instanceof AppointmentItem) {
            AppointmentForm af = new AppointmentForm((AppointmentItem)theItem, GWItemForm.DONT_PRINT_ATTACHMENT_LIST, this.getController());
            af.setMVCModel(this.itemChecksPanel);
            v.add(af);
            af = new AppointmentForm((AppointmentItem)theItem, GWItemForm.PRINT_ATTACHMENT_LIST, this.getController());
            af.setMVCModel(this.itemChecksPanel);
            v.add(af);
            return v;
        }
        if (theItem instanceof TaskItem) {
            TaskForm tf = new TaskForm((TaskItem)theItem, GWItemForm.DONT_PRINT_ATTACHMENT_LIST, this.getController());
            tf.setMVCModel(this.itemChecksPanel);
            v.add(tf);
            tf = new TaskForm((TaskItem)theItem, GWItemForm.PRINT_ATTACHMENT_LIST, this.getController());
            tf.setMVCModel(this.itemChecksPanel);
            v.add(tf);
            return v;
        }
        if (theItem instanceof ReminderNote) {
            ReminderNoteForm rnf = new ReminderNoteForm((ReminderNote)theItem, GWItemForm.DONT_PRINT_ATTACHMENT_LIST, this.getController());
            rnf.setMVCModel(this.itemChecksPanel);
            v.add(rnf);
            rnf = new ReminderNoteForm((ReminderNote)theItem, GWItemForm.PRINT_ATTACHMENT_LIST, this.getController());
            rnf.setMVCModel(this.itemChecksPanel);
            v.add(rnf);
            return v;
        }
        if (theItem instanceof MailItem) {
            MailForm mf = new MailForm((MailItem)theItem, GWItemForm.DONT_PRINT_ATTACHMENT_LIST, this.getController());
            mf.setMVCModel(this.itemChecksPanel);
            v.add(mf);
            mf = new MailForm((MailItem)theItem, GWItemForm.PRINT_ATTACHMENT_LIST, this.getController());
            mf.setMVCModel(this.itemChecksPanel);
            v.add(mf);
            return v;
        }
        if (theItem.isPersonal()) {
            v.add(StringResources.NO_PRINT_FORMS_AVAILABLE);
            return v;
        }
        if (theItem instanceof PhoneItem) {
            PhoneForm pf = new PhoneForm((PhoneItem)theItem, GWItemForm.DONT_PRINT_ATTACHMENT_LIST, this.getController());
            pf.setMVCModel(this.itemChecksPanel);
            v.add(pf);
            pf = new PhoneForm((PhoneItem)theItem, GWItemForm.PRINT_ATTACHMENT_LIST, this.getController());
            pf.setMVCModel(this.itemChecksPanel);
            v.add(pf);
            return v;
        }
        v.add(StringResources.NO_PRINT_FORMS_AVAILABLE);
        return v;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof AbstractItem) {
            this.item = (AbstractItem)theModel;
            this.refreshSelectionPanel();
        }
    }

    class LstPrintingFormsChanged
    implements ListSelectionListener {
        LstPrintingFormsChanged() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!(ItemPrintManager.this.lstPrintingForms.getSelectedValue() instanceof PrintForm)) {
                Command com = new Command(290, null);
                ItemPrintManager.this.getController().processCommand(com);
                return;
            }
            if (!e.getValueIsAdjusting()) {
                ItemPrintManager.this.selectedForm = (PrintForm)ItemPrintManager.this.lstPrintingForms.getSelectedValue();
                Command command = new Command(290);
                if (ItemPrintManager.this.selectedForm != null) {
                    ItemPrintManager.this.lbPreview.setIcon(ItemPrintManager.this.selectedForm.getIcon());
                    command.setCommandObject(ItemPrintManager.this.selectedForm);
                } else {
                    ItemPrintManager.this.lbPreview.setIcon(null);
                }
                ItemPrintManager.this.getController().processCommand(command);
            }
        }
    }

    class LstPrintingItemsChanged
    implements ListSelectionListener {
        LstPrintingItemsChanged() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Object ob = ItemPrintManager.this.lstPrintingItems.getSelectedValue();
                Vector v = ItemPrintManager.this.getPrintForms(ob);
                ItemPrintManager.this.lstPrintingForms.setListData(v);
                if (v.isEmpty()) {
                    ItemPrintManager.this.lbPreview.setIcon(null);
                } else {
                    ItemPrintManager.this.lstPrintingForms.setSelectedIndex(0);
                }
            }
        }
    }
}

