/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.startup;

import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.startup.ComposeMailEvent;
import com.novell.gw.jclient.application.startup.MailToEvent;
import com.novell.gw.jclient.application.startup.OpenMailEvent;
import java.util.LinkedList;
import java.util.Queue;

public final class ComposeMailDispatcher {
    private static Queue<ComposeMailEvent> eventQueue = new LinkedList<ComposeMailEvent>();

    private static boolean handleEvent(ComposeMailEvent event) {
        boolean handled = false;
        if (GWClient.isGwClientRunning()) {
            if (event instanceof OpenMailEvent) {
                GWClient.openEmlFile(((OpenMailEvent)event).getFileToOpen());
                handled = true;
            } else if (event instanceof MailToEvent) {
                GWClient.composeMail(((MailToEvent)event).getMailToOptions());
                handled = true;
            }
        }
        return handled;
    }

    public static void dispatchEvent(ComposeMailEvent event) {
        if (!ComposeMailDispatcher.handleEvent(event)) {
            eventQueue.add(event);
        }
    }

    public static void dispatchRemainedEvents() {
        while (eventQueue.size() > 0) {
            ComposeMailEvent event = eventQueue.poll();
            if (event instanceof OpenMailEvent) {
                GWClient.openEmlFile(((OpenMailEvent)event).getFileToOpen());
                continue;
            }
            if (!(event instanceof MailToEvent)) continue;
            GWClient.composeMail(((MailToEvent)event).getMailToOptions());
        }
    }
}

