/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om;

import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.account.Account;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.Filter;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.JunkMailListManager;
import com.novell.gw.engine.JunkMailSettings;
import com.novell.gw.engine.ProxyAccessList;
import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.engine.SendCallback;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.api.enums.DataStoreDisplaySettingsSubtype;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.IItemListComponentDataModel;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.options.AppearanceSettings;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWSecurityPasswordOptions;
import com.novell.gw.jclient.bl.om.GWUserInfo;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.SharedAddressBookNotificationItem;
import com.novell.gw.jclient.bl.om.items.TableItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import com.novell.gw.jclient.bl.om.options.ItemSendOptions;
import com.novell.gw.jclient.bl.om.options.Signature;
import com.novell.gw.notification.NotifySubscribeList;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GWCommandManager {
    private static Logger logger = Logger.getLogger(GWCommandManager.class);
    protected static GWUserInfo userInfo;
    protected static Map instances;
    protected static Map refs;

    protected GWCommandManager() {
    }

    public static GWCommandManager getInstance(String userGuid) {
        GWCommandManager instance = (GWCommandManager)instances.get(userGuid);
        return instance;
    }

    public abstract GWUserInfo getCurrentUserInfo();

    public static void addFrameRef(String userGuid) {
        Integer refCount = (Integer)refs.get(userGuid);
        int value = refCount == null ? 1 : refCount + 1;
        refs.put(userGuid, value);
        logger.debug((Object)("add userID == " + userGuid + "   refCount === " + value));
    }

    public static void removeFrameRef(String userGuid) {
        Integer refCount = (Integer)refs.get(userGuid);
        if (refCount <= 0) {
            throw new IllegalStateException("Illegal number of references: " + refCount + ". Probably some application frame was not correctly registered during creation.");
        }
        int value = refCount - 1;
        if (value == 0 && !userGuid.equals(EngineCommandManager.getUserInfo().getGuid())) {
            refs.remove(userGuid);
            EngineCommandManager instance = (EngineCommandManager)instances.get(userGuid);
            instances.remove(userGuid);
            instance.getCurrentDataStore().writeMemoryCachedData();
            instance.getCurrentDataStore().dispose();
            Object var3_3 = null;
        } else {
            refs.put(userGuid, value);
        }
        logger.debug((Object)("remove userID == " + userGuid + "   refCount === " + value));
    }

    public abstract AbstractFolder getRootFolder() throws GWCommandException;

    public abstract AbstractFolder getMailboxFolder() throws GWCommandException;

    public abstract AbstractFolder getTrashFolder() throws GWCommandException;

    public abstract CalendarFolder getCalendarFolder() throws GWCommandException;

    public abstract SentItemsFolder getSentItemsFolder() throws GWCommandException;

    public static CalendarFolder getCalendarFolder(String userGuid) {
        CalendarFolder result = null;
        try {
            result = GWCommandManager.getInstance(userGuid).getCalendarFolder();
        }
        catch (GWCommandException e) {
            ErrorDialog.processGWException(e);
        }
        return result;
    }

    public abstract AbstractItem composeNewItem(Class var1) throws GWCommandException;

    public abstract void sendItem(AbstractItem var1, SendCallback var2) throws GWCommandException, UnresolvedAddressException;

    public abstract void sendItem(AbstractItem var1, Account var2, IDataStore var3, SendCallback var4) throws GWCommandException, UnresolvedAddressException;

    public abstract GWBusySearch composeBusySearch(RecipientDescriptionsList var1, Date var2, int var3, TimeInterval var4) throws GWCommandException;

    public static long getToday() {
        return System.currentTimeMillis();
    }

    public abstract AbstractFolder createFolder(String var1, String var2, AbstractFolder var3, int var4) throws EngineException;

    public abstract AbstractFolder createCalendarFolder(String var1, IFolder var2);

    public abstract AbstractItem getEnclosedItem(GWAttachment var1) throws GWCommandException;

    public abstract void directorySaveAs(AbstractAddressBook var1, String var2, String var3) throws GWCommandException;

    public abstract void acceptSharedAddressBook(SharedAddressBookNotificationItem var1) throws GWCommandException;

    public abstract void rejectSharedAddressBook(SharedAddressBookNotificationItem var1) throws GWCommandException;

    public abstract boolean setSecurityPasswordOptions(String var1, String var2, Boolean var3, Boolean var4) throws GWCommandException;

    public abstract boolean setSignature(Signature var1, Account var2) throws GWCommandException;

    public abstract Signature getSignature(Account var1) throws GWCommandException;

    public abstract RuleList getRuleList();

    public abstract ItemSendOptions getItemSendOptions() throws GWCommandException;

    public abstract void modifyItemSendOptions(ItemSendOptions var1) throws GWCommandException;

    public abstract AbstractItem getGWItem(IMessage var1) throws GWCommandException;

    public abstract AbstractItem getItem(IItemList var1, IMessage var2) throws GWCommandException;

    public abstract TableItem getTableItem(IItemList var1, IItem var2) throws GWCommandException;

    public abstract AbstractFolder getGWFolder(IFolder var1);

    public abstract AbstractFolder getFolder(String var1);

    public abstract boolean switchToCaching();

    public abstract boolean switchToOnline();

    public abstract boolean setArchiveLocation(String var1);

    public abstract String getArchiveLocation();

    public abstract String performProxy(ProxyHistoryEntry var1) throws EngineException;

    public abstract String switchToUserMode();

    public abstract String switchToArchiveMode() throws GWCommandException;

    public abstract boolean isArchive();

    public abstract boolean isOnlineDataStore();

    public abstract boolean isCachingDataStore();

    public abstract boolean archiveItems(List<AbstractItem> var1) throws GWCommandException;

    public abstract AbstractFolder createSharedFolder(String var1, String var2, AbstractFolder var3, int var4, FolderSharedList var5) throws EngineException;

    public abstract IAddressable getUserFields();

    public abstract void syncDataStore();

    public abstract void postItem(AbstractItem var1, SendCallback var2, IDataStore var3) throws GWCommandException;

    public abstract void modifyItem(AbstractItem var1, SendCallback var2) throws GWCommandException, UnresolvedAddressException;

    public abstract void setCachingPath(String var1);

    public abstract AbstractItem getNextItem(IItemList var1, AbstractItem var2);

    public abstract AbstractItem getPrevItem(IItemList var1, AbstractItem var2);

    @Deprecated
    public abstract IItemList getItemListForItem(AbstractItem var1);

    public abstract ProxyAccessList getProxyAccessList();

    public abstract NotifySubscribeList getNotifySubscribeList();

    public abstract AbstractItem composeNewItem(Class var1, boolean var2, AbstractFolder var3) throws GWCommandException;

    public abstract QueryFolder find(ItemListFilter var1);

    public abstract AbstractItem find(String var1) throws GWCommandException;

    public abstract AbstractItem getNextUnreadItem(IItemList var1, AbstractItem var2);

    public abstract AbstractItem getPrevUnreadItem(IItemList var1, AbstractItem var2);

    public abstract AbstractItem getLastUnreadItem(IItemList var1);

    public abstract boolean isProxyDataStore();

    public abstract void switchOnlineDataStore();

    public abstract void saveDraft(AbstractItem var1, String var2, SendCallback var3) throws GWCommandException, UnresolvedAddressException;

    public abstract String getProxyUserName();

    public abstract IDataStore getCurrentDataStore();

    public abstract boolean isJunkMailMasterEnabled();

    public abstract JunkMailSettings getJunkMailSettings();

    public abstract void setJunkMailSettings(JunkMailSettings var1) throws GWCommandException;

    public abstract JunkMailListManager getJunkMailListManager() throws EngineException;

    public abstract Rule createRule();

    public abstract TableItem getFirstItem(IItemListComponentDataModel var1);

    public abstract boolean performBackupOnDB(boolean var1, boolean var2);

    public abstract String openBackupDB() throws GWCommandException;

    public abstract boolean isBackupDB();

    public abstract DataStoreSettings getDataStoreSettings();

    public abstract Enumeration getDisplaySettingsEnumeration(DataStoreDisplaySettingsSubtype var1);

    public abstract Filter createRuleFilter();

    public abstract AbstractFolder findFolderInCurrentDataStore(AbstractFolder var1);

    public abstract GWSecurityPasswordOptions getSecurityPasswordOptions();

    public abstract boolean canClearPassword();

    public abstract boolean clearPassword(String var1) throws GWCommandException;

    public abstract boolean validatePassword(String var1);

    public abstract boolean validateOnlineMailboxPassword(String var1);

    public abstract boolean isPasswordSet();

    public abstract List<IPanelDisplaySettings> getNativePanelTemplateSettings();

    public abstract List<String> getPanelTemplateNames();

    public abstract IDataStore getProxyDataStore(ProxyHistoryEntry var1) throws EngineException;

    public abstract AppearanceSettings getAppearanceSettings();

    public abstract boolean canUsePopAndImapAccounts();

    static {
        instances = new Hashtable();
        refs = new Hashtable();
    }
}

