/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.categories;

import com.appframework.ActionList;
import com.appframework.filter.FiltersFactory;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.enums.CategoryListRecordStatusType;
import com.novell.gw.jclient.api.impl.APIUtilsImpl;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.filter.ActionFilterByCategories;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.menus.CategorySelectAction;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryUtils {
    private static Logger logger = Logger.getLogger(CategoryUtils.class);
    public static final Color DEFAULT_CATEGORY_TEXT_COLOR = Color.BLACK;
    public static final Color DEFAULT_CATEGORY_BACKGROUND_COLOR = Color.WHITE;
    public static final int TOP_COUNT_LIMIT = 10;

    public static ICategoryList createNewCategoryList(String userGuid) {
        return APIWrapperManager.createCategoryList(GWCommandManager.getInstance(userGuid).getCurrentDataStore());
    }

    public static ICategoryList createNewCategoryList(IItem item, String userGuid) {
        return APIWrapperManager.createCategoryList(GWCommandManager.getInstance(userGuid).getCurrentDataStore(), item);
    }

    public static void setCategoriesToItemList(IItemList itemList, ICategoryList newCategories, IItem[] items, List<ICategory> changedCategories) {
        if (items.length > 1 && changedCategories != null) {
            for (IItem item : items) {
                CategoryUtils.setCategoriesToItemList(itemList, newCategories, item, changedCategories);
            }
        } else {
            ICategoryList categories = CategoryUtils.getCategories(items);
            categories = CategoryUtils.createValidCategoryList(categories, newCategories);
            itemList.setCategories(categories, items);
        }
    }

    public static void setCategoriesToItemList(IItemList itemList, ICategoryList newCategories, IItem item, List<ICategory> changedCategories) {
        IItem[] items = new IItem[]{item};
        ICategoryList categories = changedCategories != null ? CategoryUtils.createValidCategoryList(CategoryUtils.getCategories(item), newCategories, changedCategories) : CategoryUtils.createValidCategoryList(CategoryUtils.getCategories(item), newCategories);
        itemList.setCategories(categories, items);
    }

    public static ICategoryList getCategories(IItem item) {
        if (item instanceof IMessage) {
            return ((IMessage)item).getCategories();
        }
        if (item instanceof IContact) {
            return ((IContact)item).getCategories();
        }
        return null;
    }

    public static ICategoryList getCategories(IItem[] items) {
        if (items.length == 1) {
            return CategoryUtils.getCategories(items[0]);
        }
        return APIUtilsImpl.getInstance().getCategories(items);
    }

    public static ICategoryList createValidCategoryList(ICategoryList categories, ICategoryList newCategories) {
        ICategory category;
        int i;
        ICategory primary = newCategories.getPrimary();
        for (i = 0; i < categories.getCount(); ++i) {
            category = categories.getCategoryAt(i);
            if (categories.isPrimary(i) && (primary == null || !category.isEqual(primary))) {
                categories.setPrimary(category, false, CategoryListRecordStatusType.NONE);
                continue;
            }
            if (categories.isPrimary(i) || primary != null && !category.isEqual(primary)) continue;
            categories.setPrimary(category, true, CategoryListRecordStatusType.NONE);
        }
        for (i = 0; i < categories.getCount(); ++i) {
            category = categories.getCategoryAt(i);
            if (newCategories.findCategoryIndex(category) != -1) continue;
            if (categories.getPrimary() != null && categories.getPrimary().isEqual(categories.getCategoryAt(i))) {
                categories.setPrimary(category, false, CategoryListRecordStatusType.REMOVE);
                continue;
            }
            categories.setState(category, CategoryListRecordStatusType.REMOVE);
        }
        for (i = 0; i < newCategories.getCount(); ++i) {
            category = newCategories.getCategoryAt(i);
            if (categories.findCategoryIndex(category) != -1) continue;
            categories.addCategory(category, CategoryListRecordStatusType.ADD);
            if (!newCategories.isPrimary(i)) continue;
            categories.setPrimary(category, true, CategoryListRecordStatusType.ADD);
        }
        return categories;
    }

    public static ICategoryList createValidCategoryList(ICategoryList categories, ICategoryList newCategories, List<ICategory> changedCategories) {
        ICategory category;
        int i;
        ICategory primary = newCategories.getPrimary();
        for (i = 0; i < categories.getCount(); ++i) {
            category = categories.getCategoryAt(i);
            if (!changedCategories.contains(category)) continue;
            if (categories.isPrimary(i) && (primary == null || !category.isEqual(primary))) {
                categories.setPrimary(category, false, CategoryListRecordStatusType.NONE);
                continue;
            }
            if (categories.isPrimary(i) || primary != null && !category.isEqual(primary)) continue;
            categories.setPrimary(category, true, CategoryListRecordStatusType.NONE);
        }
        for (i = 0; i < categories.getCount(); ++i) {
            category = categories.getCategoryAt(i);
            if (newCategories.findCategoryIndex(category) != -1 || !changedCategories.contains(category)) continue;
            if (categories.getPrimary() != null && categories.getPrimary().isEqual(categories.getCategoryAt(i))) {
                categories.setPrimary(category, false, CategoryListRecordStatusType.REMOVE);
                continue;
            }
            categories.setState(category, CategoryListRecordStatusType.REMOVE);
        }
        for (i = 0; i < newCategories.getCount(); ++i) {
            category = newCategories.getCategoryAt(i);
            if (categories.findCategoryIndex(category) != -1 || !changedCategories.contains(category)) continue;
            categories.addCategory(category, CategoryListRecordStatusType.ADD);
            if (!newCategories.isPrimary(i)) continue;
            categories.setPrimary(category, true, CategoryListRecordStatusType.ADD);
        }
        return categories;
    }

    public static ICategory createCategory(String name, String userGuid) {
        return APIWrapperManager.createCategory(GWCommandManager.getInstance(userGuid).getCurrentDataStore(), name);
    }

    public static boolean removeCategory(int i, String userGuid) {
        return GWCommandManager.getInstance(userGuid).getCurrentDataStore().getCategory(i).deleteFromDB();
    }

    public static int getCategoryCount(String userGuid) {
        return GWCommandManager.getInstance(userGuid).getCurrentDataStore().getCategoryCount();
    }

    public static ICategory getCategory(int i, String userGuid) {
        return GWCommandManager.getInstance(userGuid).getCurrentDataStore().getCategory(i);
    }

    public static ICategory getCategory(String name, String userGuid) {
        return GWCommandManager.getInstance(userGuid).getCurrentDataStore().getCategory(name);
    }

    public static boolean existsCategory(String name, String userGuid) {
        return GWCommandManager.getInstance(userGuid).getCurrentDataStore().getCategory(name) != null;
    }

    public static Color checkTextColorForNull(Color textColor) {
        if (textColor == null) {
            return DEFAULT_CATEGORY_TEXT_COLOR;
        }
        return textColor;
    }

    public static Color checkBackgroundColorForNull(Color backgroundColor) {
        if (backgroundColor == null) {
            return DEFAULT_CATEGORY_BACKGROUND_COLOR;
        }
        return backgroundColor;
    }

    public static Color getPrimaryTextColor(ICategoryList categoryList) {
        if (categoryList.getPrimary() != null) {
            return CategoryUtils.checkTextColorForNull(categoryList.getPrimary().getTextColor());
        }
        if (categoryList.getCount() > 0) {
            return CategoryUtils.checkTextColorForNull(categoryList.getCategoryAt(0).getTextColor());
        }
        return null;
    }

    public static Color getPrimaryBackgroundColor(ICategoryList categoryList) {
        if (categoryList.getPrimary() != null) {
            return CategoryUtils.checkBackgroundColorForNull(categoryList.getPrimary().getBackgroundColor());
        }
        if (categoryList.getCount() > 0) {
            return CategoryUtils.checkBackgroundColorForNull(categoryList.getCategoryAt(0).getBackgroundColor());
        }
        return null;
    }

    public static void printCategories(IItem[] items) {
        logger.debug((Object)("items.length: " + items.length));
        for (IItem item : items) {
            logger.debug((Object)("item: " + item));
            CategoryUtils.printCategories(CategoryUtils.getCategories(item));
        }
        logger.debug((Object)"ALL CATEGORIES");
        ICategoryList categoryList = CategoryUtils.getCategories(items);
        CategoryUtils.printCategories(categoryList);
    }

    public static void printCategories(ICategoryList categoryList) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < categoryList.getCount(); ++i) {
            ICategory category = categoryList.getCategoryAt(i);
            builder.append("\n");
            builder.append("Categor[");
            builder.append(i);
            builder.append("]: ");
            builder.append(category.getName());
            builder.append("; ");
            builder.append((Object)categoryList.getState(i));
            if (!categoryList.isPrimary(i)) continue;
            builder.append("; primary");
        }
        if (categoryList.getPrimary() != null) {
            builder.append("\n");
            builder.append("Primary - ");
            builder.append(categoryList.getPrimary().getName());
        }
        logger.debug((Object)builder.toString());
    }

    public static String getCategoryTableName(ICategoryList categoryList, ICategory category) {
        StringBuilder builder = new StringBuilder(category.getName());
        int index = categoryList.findCategoryIndex(category);
        if (index != -1 && categoryList.isPrimary(index)) {
            builder.append(" (");
            builder.append(StringResources.PRIMARY);
            builder.append(")");
        }
        return builder.toString();
    }

    public static boolean canEditCategories(IContact contact) {
        boolean editable;
        boolean bl = editable = !contact.isReadOnly();
        if (editable) {
            editable = !EngineCommandManager.getContactAddressBook(contact).isSystemAddressBook();
        }
        return editable;
    }

    public static void populateMenuWithCategories(JMenu menu, MVCController controller, IItemList itemList, IItem[] items) {
        CategoryUtils.populateMenuWithCategories(new MenuAdapter<JMenu>(menu), controller, itemList, items);
    }

    public static void populateMenuWithCategories(JMenu menu, Filter filter, ActionList actionList) {
        int topCounter = 0;
        String userGuid = ControlsUtils.getUserGuid(actionList);
        int categoriesCount = CategoryUtils.getCategoryCount(userGuid);
        for (int index = 0; index < categoriesCount && topCounter < 10; ++topCounter, ++index) {
            ICategory category = CategoryUtils.getCategory(index, userGuid);
            menu.add(new ActionFilterByCategories(actionList, filter, category).getMenuItem());
        }
    }

    public static Set<ICategory> populateMenuWithCategories(JPopupMenu menu, MVCController controller, IItemList itemList, IItem[] items) {
        return CategoryUtils.populateMenuWithCategories(new MenuAdapter<JPopupMenu>(menu), controller, itemList, items);
    }

    private static Set<ICategory> populateMenuWithCategories(MenuAdapter adapter, MVCController controller, IItemList itemList, IItem[] items) {
        ICategory category;
        int topCounter = 0;
        ICategoryList categories = CategoryUtils.getCategories(items);
        HashSet<ICategory> itemCategorySet = new HashSet<ICategory>();
        int categoriesCount = categories.getCount();
        for (int index = 0; index < categoriesCount && topCounter < 10; ++index) {
            category = categories.getCategoryAt(index);
            itemCategorySet.add(category);
            JMenuItem menuItem = new CategorySelectAction(itemList, items, category).getMenuItem();
            if (categories.getPrimary() != null && index != categories.findCategoryIndex(categories.getPrimary())) {
                ++topCounter;
                adapter.add(menuItem);
                continue;
            }
            ++topCounter;
            adapter.add(menuItem, 0);
        }
        String userGuid = ControlsUtils.getUserGuid(controller);
        categoriesCount = CategoryUtils.getCategoryCount(userGuid);
        for (int index = 0; index < categoriesCount && topCounter < 10; ++index) {
            category = CategoryUtils.getCategory(index, userGuid);
            if (categories.findCategoryIndex(category) != -1) continue;
            ++topCounter;
            adapter.add(new CategorySelectAction(itemList, items, category).getMenuItem());
        }
        return itemCategorySet;
    }

    public static JPopupMenu createEditCategoryPopupMenu(MVCController controller, IItemList itemList, IItem[] items, boolean isContacts) {
        GWPopupMenu popup = new GWPopupMenu();
        Set<ICategory> itemCategorySet = CategoryUtils.populateMenuWithCategories(popup, controller, itemList, items);
        popup.addSeparator();
        ActionList actionList = controller.getActionList();
        if (isContacts) {
            popup.add(actionList.getAction(ActionKey.EDIT_CATEGORIES_FOR_CONTACTS).getMenuItem());
        } else {
            popup.add(actionList.getAction(ActionKey.EDIT_CATEGORIES).getMenuItem());
        }
        Filter filter = FiltersFactory.getInstance().getFilter(actionList);
        if (!itemCategorySet.isEmpty()) {
            popup.addSeparator();
            ActionFilterByCategories actionFilterByCategories = new ActionFilterByCategories(actionList, filter, itemCategorySet, StringResources.FIND_SIMILAR);
            JMenuItem mi = actionFilterByCategories.getMenuItem();
            popup.add(mi);
            if (filter != null && !filter.isEmpty()) {
                popup.add(actionList.getAction(ActionKey.CLEAR_FILTER).getMenuItem());
            }
        } else if (filter != null && !filter.isEmpty()) {
            popup.addSeparator();
            popup.add(actionList.getAction(ActionKey.CLEAR_FILTER).getMenuItem());
        }
        return popup;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MenuAdapter<T extends JComponent> {
        T component;
        Method addMethod;

        public MenuAdapter(T component) {
            this.component = component;
            try {
                Class<?> type = component.getClass();
                this.addMethod = type.getMethod("add", JMenuItem.class);
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        }

        public JMenuItem add(JMenuItem item) {
            JMenuItem value = null;
            try {
                value = (JMenuItem)this.addMethod.invoke(this.component, item);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            return value;
        }

        public Component add(Component comp, int index) {
            return ((Container)this.component).add(comp, index);
        }
    }
}

