/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.folders;

import com.appframework.utils.Assertions;
import com.appframework.utils.Utils;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.folder.FolderCountInfo;
import com.novell.gw.folder.FolderListener;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.bl.eng_impl.displaysettings.DisplaySettingsManager;
import com.novell.gw.jclient.bl.eng_impl.displaysettings.FolderDisplaySettings;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.DocumentFolder;
import com.novell.gw.jclient.bl.om.folders.ItemListsCache;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.SharedRefFolder;
import com.novell.gw.jclient.bl.om.folders.TaskListFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import com.novell.gw.jclient.bl.om.folders.UnopenedFolder;
import com.novell.gw.jclient.bl.om.items.TableItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFolder
implements TableItem,
Serializable {
    private static Logger logger = Logger.getLogger(AbstractFolder.class);
    protected String id;
    private String name;
    protected FolderDisplaySettings displaySettings;
    protected IFolder nativeFolder;
    private boolean exist = true;
    protected String userGuid;

    public AbstractFolder() {
    }

    protected AbstractFolder(String theID) {
        this(theID, theID);
    }

    protected AbstractFolder(String theID, String theName) {
        this.id = theID;
        this.name = theName;
    }

    public final boolean isExist() {
        return this.exist;
    }

    public void setExist(boolean exist) {
        this.exist = exist;
        if (!exist) {
            this.id = "doesn't exist";
        }
    }

    public final IFolder getNativeFolder() {
        return this.nativeFolder;
    }

    public void setNativeFolder(IFolder theNativeFolder) {
        this.nativeFolder = theNativeFolder;
    }

    public int countSubFolders() {
        return this.nativeFolder.getSubFolders().length;
    }

    public final List<AbstractFolder> getChildFolders() {
        IFolder[] subFolders;
        ArrayList<AbstractFolder> result = new ArrayList<AbstractFolder>();
        for (IFolder subFolder : subFolders = this.nativeFolder.getSubFolders()) {
            AbstractFolder folder = GWCommandManager.getInstance(this.userGuid).getGWFolder(subFolder);
            result.add(folder);
        }
        return result;
    }

    public final IItemList getItemList(IViewDisplaySettings ds) {
        if (logger.isDebugEnabled() && ds != null) {
            logger.debug((Object)("folder: " + this.getName()));
        }
        return this.nativeFolder.getContents(null, ds);
    }

    public final IItemList getItemList(ItemListFilter itemListFilter, IViewDisplaySettings ds) {
        if (logger.isDebugEnabled() && ds != null && itemListFilter != null) {
            logger.debug((Object)("folder: " + this.getName()));
            logger.debug((Object)("Filter: " + itemListFilter.generateDescription()));
        }
        return this.nativeFolder.getContents(itemListFilter, ds);
    }

    public IItemList getItemList() {
        String theID = this.id;
        if (!ItemListsCache.containsKey(theID, this.userGuid)) {
            logger.debug((Object)("!!!!!!!!!!!!!! GETTING NEW (FRESH) ITEM LIST FOR FOLDER :" + this.name + " !!!!!!!!!!!!!!!!!!!"));
            IItemList list = this.nativeFolder.getContents();
            ItemListsCache.put(theID, list, this.userGuid);
        }
        return ItemListsCache.get(theID, this.userGuid);
    }

    public final IItemList getContents() {
        return this.nativeFolder.getContents();
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public final int getDisplayCount() {
        if (this.nativeFolder != null) {
            return this.nativeFolder.getDisplayCount();
        }
        return -1;
    }

    public final int hashCode() {
        return this.id.hashCode() + this.name.hashCode();
    }

    public void setName(String theFolderNewName) {
        this.name = theFolderNewName;
    }

    public boolean rename(String name) {
        boolean result = false;
        if (this.canRename() && (result = this.nativeFolder.setName(name))) {
            this.name = name;
        }
        return result;
    }

    public boolean canDelete() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.canDelete();
    }

    public boolean canRename() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.canRename();
    }

    public boolean canHaveChildren() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.canHaveChildren();
    }

    public boolean isCalendarFolder() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.isCalendarFolder();
    }

    public boolean isCalendarChildFolder() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.isCalendarChildFolder();
    }

    public boolean isJunkMailFolder() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.isJunkMailFolder();
    }

    public boolean isSubCalendarShown() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.isSubCalendarShown();
    }

    public final boolean canShare() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.canShare();
    }

    public void setID(String theFolderID) {
        this.id = theFolderID;
    }

    public boolean move(AbstractFolder theTargetFolder) {
        if (!this.canMoveTo(theTargetFolder)) {
            return false;
        }
        IFolder targetFolder = theTargetFolder.nativeFolder;
        return this.nativeFolder.moveTo(targetFolder, 0);
    }

    public boolean canMoveTo(AbstractFolder theParentFolder) {
        boolean result = true;
        if (theParentFolder instanceof UnopenedFolder || theParentFolder instanceof CalendarFolder || theParentFolder instanceof QueryFolder || theParentFolder instanceof TaskListFolder || theParentFolder instanceof SentItemsFolder || theParentFolder instanceof DocumentFolder || theParentFolder instanceof TrashFolder) {
            result = false;
        }
        if (theParentFolder instanceof SharedRefFolder && !((SharedRefFolder)theParentFolder).isAddRight()) {
            result = false;
        }
        if (theParentFolder.id.equals(this.id)) {
            result = false;
        }
        if (this.isAncestor(theParentFolder)) {
            result = false;
        }
        return result;
    }

    private boolean isAncestor(AbstractFolder theParentFolder) {
        IFolder folder = this.nativeFolder.findFolder(theParentFolder.nativeFolder.getId());
        return folder != null;
    }

    @Override
    public final String getSubject() {
        return this.name;
    }

    public FolderCountInfo getCountOFContents() {
        return this.nativeFolder.getCountOfContents();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractFolder)) {
            return false;
        }
        AbstractFolder folder = (AbstractFolder)obj;
        return this.id.equals(folder.id) && Utils.areObjectsNullsOrEqual(this.nativeFolder.getOwnerName(), folder.nativeFolder.getOwnerName());
    }

    @Override
    public final IItem getNativeObject() {
        return this.nativeFolder;
    }

    public boolean hasUnopenedItems() {
        boolean stat = false;
        if (this.nativeFolder != null) {
            stat = this.nativeFolder.hasUnreadItems();
        }
        return stat;
    }

    public boolean hasUnreadItems(boolean recurse) {
        return this.nativeFolder != null && this.nativeFolder.hasUnreadItems(recurse);
    }

    public void setFolderListener(FolderListener theFolderListener) {
        this.nativeFolder.removeFolderListener(theFolderListener);
        this.nativeFolder.addFolderListener(theFolderListener);
    }

    public boolean isSelectFirstUnreadItemState() {
        return this.nativeFolder.getSelectFirstUnreadItemState();
    }

    public void setSelectFirstUnreadItemState(boolean b) {
        if (this.isSelectFirstUnreadItemState() != b) {
            this.nativeFolder.setSelectFirstUnreadItemState(b);
        }
    }

    public final String getDescription() {
        return this.nativeFolder.getDescription();
    }

    public void setDescription(String theDescription) {
        if (theDescription == null) {
            theDescription = "";
        }
        if (!theDescription.equals(this.getDescription())) {
            this.nativeFolder.setDescription(theDescription);
        }
    }

    public abstract String getTypeString();

    public boolean canSortSubfolders() {
        return this.nativeFolder.canSortSubFolders();
    }

    public final AbstractFolder getParent() {
        if (this.nativeFolder == null) {
            return null;
        }
        IFolder parent = this.nativeFolder.getParent();
        GWCommandManager commandManager = GWCommandManager.getInstance(this.userGuid);
        if (commandManager != null && parent != null) {
            return commandManager.getGWFolder(parent);
        }
        return null;
    }

    public final String getDisplayCountString() {
        int displayCount = this.getDisplayCount();
        if (displayCount > 0) {
            return " [" + displayCount + ']';
        }
        return "";
    }

    public IFolderDisplaySettings getDisplaySettings() {
        return this.nativeFolder.getDisplaySettings();
    }

    public FolderDisplaySettings getFolderDisplaySettings() {
        if (this.displaySettings == null) {
            logger.debug((Object)("folder: " + this));
            logger.debug((Object)"display settings is null > creating a new one");
            IFolderDisplaySettings nativeDisplaySettings = this.nativeFolder.getDisplaySettings();
            logger.debug((Object)("nativeDisplaySettings: " + nativeDisplaySettings));
            this.displaySettings = DisplaySettingsManager.getInstance().createFolderDisplaySettings(nativeDisplaySettings);
        }
        return this.displaySettings;
    }

    public void setFolderDisplaySettings(FolderDisplaySettings theSettings) {
        this.nativeFolder.linkTo(theSettings.getNativeDisplaySettings());
        this.displaySettings = theSettings;
    }

    public final String toString() {
        return this.name + this.getDisplayCountString();
    }

    public void removeFolderListener(FolderListener theListener) {
        this.nativeFolder.removeFolderListener(theListener);
    }

    public final TransferItems getTransferItems() {
        return this.nativeFolder.getTransferItems();
    }

    public boolean transfer(TransferItems transferData, int action) {
        return this.nativeFolder.transfer(transferData, action);
    }

    public boolean transfer(TransferItems transferData, int action, boolean bIsCalendarContext) {
        return this.nativeFolder.transfer(transferData, action, bIsCalendarContext);
    }

    public final int getTransferOptions(TransferItems transferItems) {
        return this.nativeFolder.getTransferOptions(transferItems);
    }

    public final int getTransferOptions(TransferItems transferItems, boolean bIsDropInCalendarContext) {
        return this.nativeFolder.getTransferOptions(transferItems, bIsDropInCalendarContext);
    }

    public boolean sortSubFolders() {
        return this.nativeFolder.sortSubFolders();
    }

    public final String getUserGuid() {
        return this.userGuid;
    }

    public void setUserGuid(String userGuid) {
        this.userGuid = userGuid;
    }

    public boolean setSharedList(FolderSharedList userList) throws GWCommandException {
        boolean result = this.nativeFolder.setSharedList(userList);
        return result;
    }

    public boolean isCalendarViewEnabled() {
        return this.getDisplaySettings().getViewMode() == 6;
    }

    public boolean isContactsFolder() {
        if (this.nativeFolder == null) {
            throw new IllegalStateException("native folder is null");
        }
        return this.nativeFolder.isContactsFolder();
    }

    public final String getShortName() {
        return this.nativeFolder.getShortName();
    }

    public boolean isImapSubFolder() {
        return this.nativeFolder.isImapSubFolder();
    }
}

