/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.folders;

import com.novell.gw.ab.AddressBook;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.ab.PersonalAddressBook;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.interfaces.folder.IContactsFolder;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.AddressBookItemsFactory;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import org.apache.log4j.Logger;

public class ContactsFolder
extends AbstractFolder {
    private static Logger logger = Logger.getLogger(ContactsFolder.class);

    public ContactsFolder() {
    }

    public ContactsFolder(String theID, String theName) {
        super(theID, theName);
    }

    public String getType() {
        return "Contacts";
    }

    public String getTypeString() {
        return StringResources.CONTACTS;
    }

    public boolean setAddressBook(com.novell.gw.jclient.bl.om.directory.PersonalAddressBook theAddressBook) {
        return ((IContactsFolder)this.nativeFolder).setAddressBook((PersonalAddressBook)theAddressBook.getNativeAddressBook());
    }

    public AbstractAddressBook getAddressBook(AddressBookManager addressBookManager) {
        PersonalAddressBook addressBook = ((IContactsFolder)this.nativeFolder).getAddressBook(addressBookManager);
        if (addressBook != null) {
            return AddressBookItemsFactory.createAddressBook((AddressBook)addressBook);
        }
        return null;
    }

    public boolean rename(String name) {
        AbstractAddressBook addressBook = this.getAddressBook(EngineCommandManager.getAddressBookManager());
        if (addressBook instanceof com.novell.gw.jclient.bl.om.directory.PersonalAddressBook && !addressBook.getNativeAddressBook().isFrequentContacts()) {
            try {
                ((com.novell.gw.jclient.bl.om.directory.PersonalAddressBook)addressBook).setName(name);
                return true;
            }
            catch (EngineException e) {
                if (e.getErrorCode() != 60164) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return false;
    }

    public boolean canRename() {
        if (super.canRename() && this.hasAddressBook()) {
            AbstractAddressBook addressBook = this.getAddressBook(EngineCommandManager.getAddressBookManager());
            return addressBook != null && !addressBook.getNativeAddressBook().isFrequentContacts();
        }
        return false;
    }

    public boolean hasAddressBook() {
        PersonalAddressBook addressBook = ((IContactsFolder)this.nativeFolder).getAddressBook(EngineCommandManager.getAddressBookManager());
        if (addressBook == null) {
            logger.warn((Object)("following Contacts folder has NULL address book: " + this));
            return false;
        }
        return true;
    }
}

