/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options;

import com.appframework.CustomizableToolBarComponent;
import com.appframework.CustomizableToolBarSeparator;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.bl.om.options.ActionInfo;
import com.novell.gw.jclient.bl.om.options.SeparatorInfo;
import com.novell.gw.jclient.bl.om.options.ToolBarOptions;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentInfo
implements Serializable {
    private static final Logger logger = Logger.getLogger(ComponentInfo.class);
    public static final String SEPARATOR = "SEPARATOR";
    public static final SeparatorInfo SEPARATOR_INFO = new SeparatorInfo();
    private final Object componentSource;
    private ToolBarOptions.State state = ToolBarOptions.State.DEFAULT;

    public static ComponentInfo getInstance(Object componentSource) {
        if (componentSource.equals(SEPARATOR)) {
            return SEPARATOR_INFO;
        }
        if (componentSource instanceof ActionKey) {
            return new ActionInfo((ActionKey)((Object)componentSource));
        }
        throw new IllegalArgumentException();
    }

    public static ComponentInfo getInstance(CustomizableToolBarComponent component) {
        if (component instanceof CustomizableToolBarSeparator) {
            return ComponentInfo.getInstance(SEPARATOR);
        }
        ComponentInfo instance = ComponentInfo.getInstance((Object)component.getDefaultActionName());
        if (instance instanceof ActionInfo) {
            ((ActionInfo)instance).setShowWithText(component.showTextLabel());
        }
        return instance;
    }

    public static ComponentInfo getClone(ComponentInfo componentInfo) {
        ComponentInfo clone = ComponentInfo.getInstance(componentInfo.getComponentSource());
        clone.setState(componentInfo.getState());
        if (componentInfo instanceof ActionInfo) {
            ((ActionInfo)clone).setShowWithText(((ActionInfo)componentInfo).isShowWithText());
        }
        return clone;
    }

    protected ComponentInfo(Object componentSource) {
        if (componentSource == null) {
            throw new IllegalArgumentException();
        }
        this.componentSource = componentSource;
    }

    public Object getComponentSource() {
        return this.componentSource;
    }

    public ToolBarOptions.State getState() {
        return this.state;
    }

    public void setState(ToolBarOptions.State state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentInfo)) {
            return false;
        }
        ComponentInfo that = (ComponentInfo)o;
        return !(this.componentSource == null ? that.componentSource != null : !this.componentSource.equals(that.componentSource));
    }

    public int hashCode() {
        return this.componentSource != null ? this.componentSource.hashCode() : 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.componentSource);
        builder.append(" ");
        builder.append((Object)this.state);
        return builder.toString();
    }

    public static int indexOfAction(List<ComponentInfo> infoList, ActionKey action) {
        for (int i = 0; i < infoList.size(); ++i) {
            if (!action.equals(infoList.get(i).getComponentSource())) continue;
            return i;
        }
        return -1;
    }
}

