/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options.properties;

import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import com.novell.gw.jclient.bl.om.options.Options;
import com.novell.gw.jclient.bl.om.options.properties.GeneralOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.OptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.SortedProperties;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateAndTimeOptionsProperties
extends OptionsProperties<DateTimeOptions> {
    private static Logger logger = Logger.getLogger(GeneralOptionsProperties.class);
    private static final String LONG_DATE_FORMAT = "dateAndTime.longDateFormat";
    private static final String SHORT_DATE_FORMAT = "dateAndTime.shortDateFormat";
    private static final String TIME_ZONE = "dateAndTime.GWTimeZoneOptions.timeZone";
    private static final String ALTERNATE_TIME_ZONE = "dateAndTime.GWTimeZoneOptions.alternateTimeZone";
    private static final String WORKSTATION_TIME_ZONE_LABEL = "dateAndTime.workstationTimeZone.label";
    private static final String ALTERNATE_TIME_ZONE_LABEL = "dateAndTime.alternateTimeZone.label";

    @Override
    public Options readOptions(Properties theProperties) {
        DateTimeOptions dateTime = new DateTimeOptions();
        String value = theProperties.getProperty(SHORT_DATE_FORMAT);
        if (value != null) {
            try {
                dateTime.setShortDateFormat(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(LONG_DATE_FORMAT)) != null) {
            try {
                dateTime.setLongDateFormat(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(TIME_ZONE)) != null) {
            try {
                dateTime.setTimeZone(TimeZone.getTimeZone(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(ALTERNATE_TIME_ZONE)) != null) {
            try {
                dateTime.setAlternateTimeZone(TimeZone.getTimeZone(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(ALTERNATE_TIME_ZONE_LABEL)) != null) {
            try {
                dateTime.setAlternateTimeZoneLabel(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(WORKSTATION_TIME_ZONE_LABEL)) != null) {
            try {
                dateTime.setWorkstationTimeZoneLabel(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return dateTime;
    }

    @Override
    public Properties createProperties(DateTimeOptions options) {
        SortedProperties properties = new SortedProperties();
        properties.put((Object)SHORT_DATE_FORMAT, options.getShortDateFormat());
        properties.put((Object)LONG_DATE_FORMAT, options.getLongDateFormat());
        properties.put((Object)ALTERNATE_TIME_ZONE_LABEL, options.getAlternateTimeZoneLabel());
        properties.put((Object)WORKSTATION_TIME_ZONE_LABEL, options.getWorkstationTimeZoneLabel());
        properties.put((Object)TIME_ZONE, options.getTimeZone().getID());
        properties.put((Object)ALTERNATE_TIME_ZONE, options.getAlternateTimeZone().getID());
        return properties;
    }
}

