/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options.properties;

import com.novell.gw.jclient.bl.om.options.GeneralOptions;
import com.novell.gw.jclient.bl.om.options.Options;
import com.novell.gw.jclient.bl.om.options.properties.OptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.SortedProperties;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralOptionsProperties
extends OptionsProperties<GeneralOptions> {
    private static Logger logger = Logger.getLogger(GeneralOptionsProperties.class);
    private static final String SHOW_SMART_TOOLTIP = "general.show_smart_tooltip";
    private static final String DELETE_CONFIRMATION = "general.delete_confirmation";
    private static final String LOCAL_MODE_USED = "general.local_mode_used";
    private static final String ITEMS_COUNT = "general.items_count";
    private static final String FRAME_ADDRESS_BOOK_ID = "general.frame_address_book_id";
    private static final String AS_ADDRESS_BOOK_ID = "general.as_address_book_id";
    private static final String WEBRENDERER_VERSION = "general.webrenderer.version";
    private static final String ITEM_DELETE_KEY = "general.item_delete_key";
    private static final String NAME_COMPLETION = "general.name_completion";
    private static final String SHOW_QUICK_INFO = "general.show_quick_info";

    @Override
    public Options readOptions(Properties theProperties) {
        GeneralOptions go = new GeneralOptions();
        String value = theProperties.getProperty(SHOW_SMART_TOOLTIP);
        if (value != null) {
            try {
                go.setSmartToolTipEnabled(GeneralOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(DELETE_CONFIRMATION)) != null) {
            try {
                go.setDeletionConfirmation(GeneralOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(LOCAL_MODE_USED)) != null) {
            try {
                go.setLocal(GeneralOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(ITEMS_COUNT)) != null) {
            try {
                go.setItemsCount(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                logger.error((Object)e);
            }
        }
        go.setSelectedAddressBookID(theProperties.getProperty(FRAME_ADDRESS_BOOK_ID));
        go.setSelectedAddressSelectorBookID(theProperties.getProperty(AS_ADDRESS_BOOK_ID));
        go.setWebRendererVersion(theProperties.getProperty(WEBRENDERER_VERSION));
        value = theProperties.getProperty(ITEM_DELETE_KEY);
        if (value != null) {
            try {
                go.setItemDeleteKey(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(NAME_COMPLETION)) != null) {
            try {
                go.setDisabledNameCompletion(GeneralOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(SHOW_QUICK_INFO)) != null) {
            try {
                go.setDisableQuickInfo(GeneralOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return go;
    }

    @Override
    public Properties createProperties(GeneralOptions options) {
        SortedProperties properties = new SortedProperties();
        properties.put((Object)SHOW_SMART_TOOLTIP, options.isSmartToolTipEnabled());
        properties.put((Object)DELETE_CONFIRMATION, options.isDeleteConfirmationAllowed());
        properties.put((Object)ITEM_DELETE_KEY, options.getItemDeleteKey());
        properties.put((Object)NAME_COMPLETION, options.isDisabledNameCompletion());
        properties.put((Object)SHOW_QUICK_INFO, options.isDisableQuickInfo());
        String strValue = options.getSelectedAddressSelectorBookID();
        if (strValue == null) {
            logger.error((Object)"getSelectedAddressSelectorBookID returned null!!");
        } else {
            properties.put((Object)AS_ADDRESS_BOOK_ID, strValue);
        }
        strValue = options.getSelectedAddressBookID();
        if (strValue == null) {
            logger.error((Object)"getSelectedAddressBookID returned null!!");
        } else {
            properties.put((Object)FRAME_ADDRESS_BOOK_ID, strValue);
        }
        strValue = options.getWebRendererVersion();
        if (strValue == null) {
            logger.error((Object)"getWebRendererVersion returned null!!");
        } else {
            properties.put((Object)WEBRENDERER_VERSION, strValue);
        }
        return properties;
    }
}

