/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options.properties;

import com.novell.gw.jclient.bl.om.options.InterfaceOptions;
import com.novell.gw.jclient.bl.om.options.Options;
import com.novell.gw.jclient.bl.om.options.properties.OptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.SortedProperties;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceOptionsProperties
extends OptionsProperties<InterfaceOptions> {
    private static Logger logger = Logger.getLogger(InterfaceOptionsProperties.class);
    private static final String PREFIX = "interface.";
    public static final String INTERFACE_FONT_NAME = "interface.font.name";
    public static final String INTERFACE_FONT_SIZE = "interface.font.size";
    public static final String GTK_LOOK_AND_FEEL = "interface.gtk_look_and_feel";

    @Override
    public Options readOptions(Properties theProperties) {
        InterfaceOptions options = new InterfaceOptions();
        String value = theProperties.getProperty(INTERFACE_FONT_SIZE);
        if (value != null) {
            options.setFontSize(new Integer(value));
        }
        value = theProperties.getProperty(INTERFACE_FONT_NAME);
        options.setFontName(value);
        value = theProperties.getProperty(GTK_LOOK_AND_FEEL);
        if (value != null) {
            try {
                options.setGtkLookAndFeel(InterfaceOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return options;
    }

    @Override
    public Properties createProperties(InterfaceOptions options) {
        SortedProperties properties = new SortedProperties();
        properties.put((Object)INTERFACE_FONT_NAME, options.getFontName());
        properties.put((Object)INTERFACE_FONT_SIZE, options.getFontSize());
        properties.put((Object)GTK_LOOK_AND_FEEL, options.isGtkLookAndFeel());
        return properties;
    }
}

