/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.store;

import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.util.Date;

public class GWItemFormatSerializer {
    private static String NEW_LINE = Utils.LINE_SEPARATOR;
    private static String BOLD_START = "<b>";
    private static String BOLD_END = "</b>";
    protected AbstractItem theItem;
    protected String theMessage;

    public GWItemFormatSerializer(AbstractItem theItem) {
        this.theItem = theItem;
    }

    protected void save(String theFile) throws GWException {
        this.theMessage = this.getItemHeader(this.theItem, true);
        if (this.theItem.getMessage() != null) {
            this.theMessage = this.theMessage + (this.theItem.getMessage().getMessage() == null ? "" : this.theItem.getMessage().getMessage());
        }
    }

    protected String addTitleValue(String title, String value) {
        StringBuffer result = new StringBuffer();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            result.append(BOLD_START);
            result.append(title);
            result.append(BOLD_END);
            result.append(' ');
            result.append(value);
        } else {
            result.append(value);
            result.append(' ');
            result.append(BOLD_START);
            result.append(title);
            result.append(BOLD_END);
        }
        return result.toString();
    }

    private String parsePhoneItem(String theSubject, String theField) {
        if (theSubject.indexOf(theField) > -1) {
            return "[X] " + theField;
        }
        return "[ ] " + theField;
    }

    public String getItemHeader(AbstractItem theItem, boolean thePrintDate) {
        StringBuffer message = new StringBuffer();
        if (theItem instanceof AppointmentItem) {
            AppointmentItem ai = (AppointmentItem)theItem;
            message.append(this.addTitleValue(StringResources.ITEM_TYPE_C, StringResources.APPOINTMENT));
            message.append(NEW_LINE);
            if (thePrintDate) {
                String date = ai.getDate() == null ? "" : OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(ai.getDate());
                message.append(this.addTitleValue(StringResources.START_DATE_C, date));
                message.append(NEW_LINE);
                long hour = ai.getDuration() / 60000L;
                long min = ai.getDuration() % 60000L;
                String hours = this.addTitleValue(StringResources.HOUR_S, Long.toString(hour));
                String mins = this.addTitleValue(StringResources.MINUTES, Long.toString(min));
                String hoursAndMin = this.addTitleValue(hours, mins);
                message.append(this.addTitleValue(StringResources.DURATION_C, hoursAndMin));
                message.append(NEW_LINE);
            }
            message.append(this.addTitleValue(StringResources.PLACE_C, ai.getLocation()));
        } else if (theItem instanceof TaskItem) {
            TaskItem ti = (TaskItem)theItem;
            message.append(this.addTitleValue(StringResources.ITEM_TYPE_C, StringResources.TASK));
            message.append(NEW_LINE);
            if (thePrintDate) {
                String date = OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(new Date(ti.getDateTaskAssigned()));
                message.append(this.addTitleValue(StringResources.START_DATE_C, date));
                message.append(NEW_LINE);
                String endDate = ti.getEndDate() == null ? "" : OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(ti.getEndDate());
                message.append(this.addTitleValue(StringResources.DUE_C, endDate));
                message.append(NEW_LINE);
            }
            message.append(this.addTitleValue(StringResources.PRIORITY_C, Integer.toString(ti.getPriority())));
            message.append(NEW_LINE);
        } else if (theItem instanceof ReminderNote) {
            ReminderNote rn = (ReminderNote)theItem;
            message.append(this.addTitleValue(StringResources.ITEM_TYPE_C, StringResources.REMINDERNOTE));
            message.append(NEW_LINE);
            if (thePrintDate) {
                String date = rn.getDate() == null ? "" : OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(rn.getDate());
                message.append(this.addTitleValue(StringResources.DATE_C, date));
                message.append(NEW_LINE);
            }
        } else if (theItem instanceof PhoneItem) {
            PhoneItem pi = (PhoneItem)theItem;
            message.append(this.addTitleValue(StringResources.ITEM_TYPE_C, StringResources.PHONE));
            message.append(NEW_LINE);
            message.append(this.addTitleValue(StringResources.CALLER_C, pi.getCaller()));
            message.append(NEW_LINE);
            message.append(this.addTitleValue(StringResources.COMPANY_C, pi.getCompany()));
            message.append(NEW_LINE);
            message.append(this.addTitleValue(StringResources.PHONE_C, pi.getPhone()));
            message.append(NEW_LINE);
            String tmp = pi.getSubject() == null ? "" : pi.getSubject();
            message.append(this.parsePhoneItem(tmp, StringResources.TELEPHONED) + NEW_LINE);
            message.append(this.parsePhoneItem(tmp, StringResources.WILL_CALL_AGAIN) + NEW_LINE);
            message.append(this.parsePhoneItem(tmp, StringResources.WANTS_TO_SEE_YOU) + NEW_LINE);
            message.append(this.parsePhoneItem(tmp, StringResources.URGENT) + NEW_LINE);
            message.append(this.parsePhoneItem(tmp, StringResources.PLEASE_CALL) + NEW_LINE);
            message.append(this.parsePhoneItem(tmp, StringResources.RETURNED_YOUR_CALL) + NEW_LINE);
            message.append(this.parsePhoneItem(tmp, StringResources.CAME_TO_SEE_YOU) + NEW_LINE);
        } else if (!(theItem instanceof MailItem) && theItem.isPersonal()) {
            String posted = this.addTitleValue(StringResources.POSTED, theItem.getType());
            message.append(this.addTitleValue(StringResources.ITEM_TYPE_C, posted));
            message.append(NEW_LINE);
        }
        message.append(NEW_LINE);
        return message.toString();
    }

    public String getAdditionalItemHeader(AbstractItem theItem, boolean thePrintFrom, boolean thePrintTo, boolean thePrintDate, boolean thePrintSubject) {
        StringBuffer str = new StringBuffer();
        if (thePrintFrom) {
            String from = theItem.getSender().getDisplayText() == null ? "" : theItem.getSender().getDisplayText();
            str.append(this.addTitleValue(StringResources.FROM_C, from));
            str.append(NEW_LINE);
        }
        if (thePrintTo) {
            String cc;
            String to = theItem.getTo() == null ? "" : theItem.getTo();
            str.append(this.addTitleValue(StringResources.TO_C, to));
            str.append(NEW_LINE);
            String string = cc = theItem.getCc() == null ? "" : theItem.getCc();
            if (!"".equals(cc)) {
                str.append(this.addTitleValue(StringResources.CC_C, cc));
                str.append(NEW_LINE);
            }
        }
        if (thePrintDate) {
            String date = theItem.getDate() == null ? "" : OptionManager.getInstance().getDateTimeOptions().getPropertiesString(theItem.getDate());
            str.append(this.addTitleValue(StringResources.DATE_C, date));
            str.append(NEW_LINE);
        }
        if (thePrintSubject) {
            String subject = theItem.getSubject() == null ? "" : theItem.getSubject();
            str.append(this.addTitleValue(StringResources.SUBJECT_C, subject));
            str.append(NEW_LINE);
        }
        str.append(NEW_LINE);
        return str.toString();
    }
}

