/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.store.mail;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.store.GWItemFormatSerializer;
import java.io.File;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSerializer
extends GWItemFormatSerializer {
    private static Logger logger = Logger.getLogger(MailSerializer.class);
    private boolean withAttachments;
    private boolean dragNDrop;

    public MailSerializer(AbstractItem theItem, boolean withAttachments, boolean dragNDrop) {
        super(theItem);
        this.withAttachments = withAttachments;
        this.dragNDrop = dragNDrop;
    }

    @Override
    protected String addTitleValue(String title, String value) {
        StringBuffer result = new StringBuffer();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            result.append(title);
            result.append(' ');
            result.append(value);
        } else {
            result.append(value);
            result.append(' ');
            result.append(title);
        }
        return result.toString();
    }

    public void saveAttachments(String theDirName, AbstractItem<IMessage> item, boolean dragNDrop) {
        for (GWAttachment attachment : item.getAttachments()) {
            if (attachment.isMessageAttachment()) continue;
            String fileName = theDirName + System.getProperty("file.separator") + attachment.getFileName();
            MailSerializer.saveAttachment(fileName, attachment, dragNDrop);
        }
    }

    public static void saveAttachment(String theDestinationFileName, GWAttachment theAttachment, boolean dragNDrop) {
        File theFile = new File(theDestinationFileName);
        if (theFile.exists()) {
            if (dragNDrop) {
                return;
            }
            int res = JOptionPane.showConfirmDialog(null, StringResources.formatString(StringResources.FILE_ALREADY_EXISTS_OVERWRITE_Q, theFile.getPath()), StringResources.SAVE_ATTACHMENT, 0, 2);
            if (res == 1) {
                return;
            }
        }
        MessageUtils.saveAttachment(theAttachment, theDestinationFileName);
    }

    @Override
    public void save(String filename) throws GWException {
        if (!this.theItem.getNativeItem().saveToFile(filename, 2)) {
            throw new GWException(StringResources.CANT_EXPORT_TO_FILE);
        }
        if (this.withAttachments) {
            String dirName = new File(filename).getParent();
            this.saveAttachments(dirName, this.theItem, this.dragNDrop);
        }
    }
}

