/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.SpellException;
import azcheck.engine.TLex;
import azcheck.util.DataReader;
import java.io.IOException;

public class CompiledTLex
extends TLex {
    static final int HEADER_SIZE = 256;
    static final byte[] MAGIC = new byte[]{-96, 65, 90, 99, 104, 101, 99, 107};
    static final byte MAJOR_VERSION = 1;
    static final byte MINOR_VERSION = 3;
    DataReader reader_;
    int compoundMin_ = 0;
    int curNodeFlags_;
    int[] sharedSuffixes_;
    static final int FAKE_CHILD = 1;
    static final int SHARED_CHILD = 2;

    public CompiledTLex(Object object) {
        super(object);
    }

    public CompiledTLex setReader(DataReader dataReader) throws IOException, SpellException {
        byte by;
        int n;
        this.reader_ = dataReader;
        if (this.reader_ == null) {
            return null;
        }
        for (n = 0; n < MAGIC.length; ++n) {
            if (dataReader.getByte() == MAGIC[n]) continue;
            throw new SpellException("bad magic number");
        }
        n = dataReader.getByte();
        if (n * 100 + (by = dataReader.getByte()) > 103) {
            throw new SpellException("version " + n + "." + by + " not supported");
        }
        int n2 = dataReader.getInt();
        this.compoundMin_ = dataReader.getInt();
        this.load(n2);
        return this;
    }

    int getCompoundMin() {
        return this.compoundMin_;
    }

    int step(int n, byte by) {
        if (n <= 0) {
            throw new RuntimeException("bad node " + n);
        }
        ++this.stepCnt_;
        this.reader_.seek(n);
        byte by2 = this.reader_.getByte();
        int n2 = this.reader_.sortedArrayFind(by, by2);
        if (n2 < 0) {
            return -1;
        }
        byte by3 = this.reader_.getByte();
        int n3 = (by3 & 3) + 1;
        this.reader_.skip(n2 * n3);
        int n4 = this.reader_.getInt(n3);
        if ((n4 & 1) == 0) {
            return n - (n4 >> 1);
        }
        if ((n4 & 2) != 0) {
            return this.sharedSuffixes_[n4 >> 2];
        }
        this.curNodeFlags_ = n4 >> 2;
        return 0;
    }

    int getFlags(int n) {
        int n2;
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            this.reader_.seek(n);
            byte by = this.reader_.getByte();
            if (by > 0) {
                this.reader_.skip(by);
            }
            n2 = this.reader_.getByte() >> 2;
        } else {
            n2 = this.curNodeFlags_;
        }
        return CompiledTLex.actualWord(n2) ? n2 : -1;
    }

    TLex.KEnum newKEnum(int n) {
        return new KEnum(n);
    }

    void load(int n) throws IOException, SpellException {
        this.reader_.seek(n);
        this.rootNode_ = this.reader_.getInt();
        int n2 = this.reader_.getInt();
        int n3 = this.reader_.getInt();
        this.reader_.seek(n2);
        super.load(this.reader_);
        this.reader_.seek(n3);
        int n4 = this.reader_.getInt();
        this.sharedSuffixes_ = new int[n4];
        for (int i = 0; i < n4; ++i) {
            this.sharedSuffixes_[i] = this.reader_.getInt(4);
        }
    }

    class KEnum
    implements TLex.KEnum {
        int node_;
        int kidCnt_;
        int kidPtr_;
        byte[] chars_;
        int[] kids_;

        public KEnum(int n) {
            this.node_ = n;
            CompiledTLex.this.reader_.seek(this.node_);
            this.kidCnt_ = CompiledTLex.this.reader_.getByte();
            this.chars_ = CompiledTLex.this.reader_.getBytes(this.kidCnt_);
            int n2 = (CompiledTLex.this.reader_.getByte() & 3) + 1;
            this.kids_ = CompiledTLex.this.reader_.getIntArray(this.kidCnt_, n2);
            this.kidPtr_ = -1;
        }

        public boolean next() {
            return ++this.kidPtr_ < this.kidCnt_;
        }

        public int getCurrentNode() {
            int n = this.kids_[this.kidPtr_];
            if ((n & 1) == 0) {
                return this.node_ - (n >> 1);
            }
            if ((n & 2) != 0) {
                return CompiledTLex.this.sharedSuffixes_[n >> 2];
            }
            CompiledTLex.this.curNodeFlags_ = n >> 2;
            return 0;
        }

        public byte getCurrentChar() {
            return this.chars_[this.kidPtr_];
        }
    }
}

