/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.SpellException;
import azcheck.engine.SuggestionBox;
import azcheck.engine.TLexRules;
import azcheck.util.CharSequence;
import java.io.IOException;
import java.io.Writer;

public abstract class TLex
extends TLexRules {
    public static final int MAX_WORD_LENGTH = 256;
    static final int FORCE_DEFAULT = 3;
    static final int FORCE_MAX = 5;
    static final int COST_OF_INSERTION = 15;
    static final int COST_OF_SWAPPING = 14;
    static final int COST_OF_DELETION = 17;
    static final int COST_OF_CHANGE = 18;
    static final int COST_OF_MISTAKE = 10;
    static final int INCR_OF_MISTAKE = 3;
    static final int COST_OF_KEYBOARD_SLIP = 13;
    static final int COST_OF_SPLIT = 27;
    static final int COST_OF_LEARNED = 0;
    static final int COST_OF_BAD_CAP = 3;
    static final int COST_OF_FREQUENT = -3;
    static final int QUICK_MIN = 4;
    Object location_;
    String copyright_ = "";
    int rootNode_;
    int stepCnt_;
    byte[] word_ = new byte[256];
    int wLength_;
    TLexRules.MRule[] matchedMRule_ = new TLexRules.MRule[257];
    SuggestionBox box_;
    boolean combinedSplit_ = true;
    int splitMax_ = 1;
    int compoundMin_ = 0;
    static final byte FREQUENT_FLAG = 8;
    static final byte PREFIX_FLAG = 16;

    TLex(Object object) {
        this.setLocation(object);
    }

    public Object getLocation() {
        return this.location_;
    }

    void setLocation(Object object) {
        this.location_ = object;
    }

    public void setCopyright(String string) {
        this.copyright_ = string;
    }

    public String getCopyright() {
        return this.copyright_;
    }

    int simpleSearch(CharSequence charSequence, int n, int n2) throws SpellException {
        this.encodeWord(charSequence, n, n2);
        int n3 = this.searchItem(this.rootNode_, this.word_, 0, n2);
        if (n3 < 0) {
            return -1;
        }
        return this.getFlags(n3);
    }

    void approximateSearch(CharSequence charSequence, int n, int n2, SuggestionBox suggestionBox, int n3) throws SpellException {
        int n4;
        if (n3 <= 0) {
            return;
        }
        this.encodeWord(charSequence, n, n2);
        this.box_ = suggestionBox;
        this.box_.setRules(this);
        this.stepCnt_ = 0;
        for (n4 = 0; n4 <= n2; ++n4) {
            TLexRules.CProps cProps = this.getChar(n4 < n2 ? this.word_[n4] : (byte)-2);
            TLexRules.MRule mRule = cProps.mistRules;
            while (mRule != null && !mRule.matches(this.word_, n4, n2)) {
                mRule = mRule.next;
            }
            this.matchedMRule_[n4] = mRule;
        }
        this.box_.back(0, 0);
        n4 = 32;
        if (n3 <= 1) {
            n4 -= 10;
        }
        this.box_.setCostMaximum(n4);
        this.approxSearch(0, this.rootNode_);
        if (this.box_.getCount() < 5) {
            this.compoundSuggest();
        }
        if (n3 >= 3 && this.box_.getCount() < (n3 <= 3 ? 3 : 5)) {
            this.box_.back(0, 0);
            int n5 = 45;
            if (n3 > 3) {
                n5 += 6;
            }
            if (n3 > 4) {
                n5 += 6;
            }
            this.box_.setCostMaximum(n5);
            this.approxSearch(0, this.rootNode_);
        }
        if (!this.combinedSplit_) {
            this.splitSearch(0, 0);
        }
    }

    int step(int n, byte by) {
        throw new RuntimeException("abstract method called");
    }

    KEnum newKEnum(int n) {
        throw new RuntimeException("abstract method called");
    }

    int getCompoundMin() {
        return 0;
    }

    int getFlags(int n) {
        throw new RuntimeException("abstract method called");
    }

    static byte wordFlags(int n) {
        return (byte)(1 + (n << 1));
    }

    static final int getWordType(int n) {
        return (n & 7) >> 1;
    }

    static final boolean actualWord(int n) {
        return n > 0 && (n & 1) != 0;
    }

    static final boolean validWord(int n, int n2) {
        return TLex.actualWord(n) && TLex.getWordType(n) <= n2;
    }

    static final boolean isaPrefix(int n) {
        return n > 0 && (n & 0x10) != 0;
    }

    int encodeWord(CharSequence charSequence, int n, int n2) throws SpellException {
        boolean bl;
        this.wLength_ = n2;
        byte by = TLex.capType(charSequence, n, n2);
        boolean bl2 = bl = by != 3;
        if (this.wLength_ > this.word_.length) {
            this.word_ = new byte[n2];
        }
        for (int i = 0; i < n2; ++i) {
            char c = charSequence.charAt(n + i);
            this.word_[i] = this.encode(bl ? Character.toLowerCase(c) : c);
            if (this.word_[i] != -1) continue;
            throw new SpellException("character '" + c + "' not accepted", i);
        }
        return by;
    }

    int searchItem(int n, byte[] byArray, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if (n <= 0) {
                return -1;
            }
            n = this.step(n, byArray[i]);
        }
        return n;
    }

    void approxSearch(int n, int n2) {
        int n3;
        int n4 = this.box_.getCursor();
        int n5 = this.box_.getCost();
        int n6 = this.getFlags(n2);
        if (n >= this.wLength_ && TLex.actualWord(n6)) {
            this.box_.storeWord(n6);
        }
        if (n2 <= 0) {
            return;
        }
        if (n > this.wLength_) {
            throw new RuntimeException("BUG wstart " + n + " > " + this.wLength_);
        }
        int n7 = this.step(n2, this.word_[n]);
        if (n7 >= 0 && n < this.wLength_) {
            this.box_.put(this.word_[n]);
            this.approxSearch(n + 1, n7);
            this.box_.back(n4, n5);
        }
        if (n < this.wLength_ && this.box_.checkCost(17)) {
            this.box_.putCost(17);
            this.approxSearch(n + 1, n2);
            this.box_.back(n4, n5);
        }
        if (n + 2 <= this.wLength_ && this.box_.checkCost(14)) {
            n7 = this.step(n2, this.word_[n + 1]);
            if (n7 > 0 && (n7 = this.step(n7, this.word_[n])) >= 0) {
                this.box_.put(this.word_[n + 1]);
                this.box_.put(this.word_[n]);
                this.box_.putCost(14);
                this.approxSearch(n + 2, n7);
            }
            this.box_.back(n4, n5);
        }
        KEnum kEnum = this.newKEnum(n2);
        while (kEnum.next()) {
            n7 = kEnum.getCurrentNode();
            byte by = kEnum.getCurrentChar();
            if (this.box_.checkCost(15)) {
                this.box_.put(by);
                this.box_.putCost(15);
                this.approxSearch(n, n7);
                this.box_.back(n4, n5);
            }
            if (n >= this.wLength_ || !this.box_.checkCost(n3 = this.charCloseness(by, this.word_[n], 18))) continue;
            this.box_.put(by);
            this.box_.putCost(n3);
            this.approxSearch(n + 1, n7);
            this.box_.back(n4, n5);
        }
        if (this.matchedMRule_[n] != null) {
            TLexRules.MRule mRule = this.matchedMRule_[n];
            n3 = mRule.itemNext(0);
            int n8 = mRule.matchedChars();
            int n9 = mRule.itemCount();
            while (--n9 >= 0) {
                n7 = this.tryAlternative(n2, n, mRule, n3);
                if (n7 >= 0 && this.box_.checkCost(mRule.itemCost(n3))) {
                    this.putAlternative(mRule, n3);
                    this.approxSearch(n + n8, n7);
                    this.box_.back(n4, n5);
                }
                n3 = mRule.itemNext(n3);
            }
        }
        if (this.combinedSplit_ && n > 1 && n <= this.wLength_ - 2 && TLex.actualWord(n6)) {
            int n10 = this.box_.split(0);
            n3 = 27;
            if (n10 > 0) {
                n3 += 13;
            }
            if (this.box_.checkCost(n3)) {
                this.box_.split(1);
                if (!TLex.isaPrefix(n6)) {
                    this.box_.put(this.encode(' '));
                }
                this.box_.putCost(n3);
                this.approxSearch(n, this.rootNode_);
                this.box_.back(n4, n5);
                this.box_.split(-1);
            }
        }
    }

    boolean splitSearch(int n, int n2) {
        int n3 = this.searchItem(this.rootNode_, this.word_, n, this.wLength_);
        int n4 = this.getFlags(n3);
        if (TLex.actualWord(n4)) {
            this.box_.put(this.word_, n, this.wLength_);
            this.box_.putCost(18 * n2);
            this.box_.storeWord(n4);
            return true;
        }
        if (n2 >= this.splitMax_) {
            return false;
        }
        int n5 = this.box_.getCursor();
        int n6 = this.box_.getCost();
        boolean bl = false;
        for (int i = n + 1; i < this.wLength_; ++i) {
            n3 = this.searchItem(this.rootNode_, this.word_, n, i);
            n4 = this.getFlags(n3);
            if (TLex.getWordType(n4) == 0) {
                this.box_.put(this.word_, n, i);
                this.box_.put(this.encode(' '));
                this.box_.split(1);
                if (this.splitSearch(i, n2 + 1)) {
                    bl = true;
                }
                this.box_.split(-1);
            }
            this.box_.back(n5, n6);
        }
        return bl;
    }

    void compoundSuggest() {
        byte by = this.encode('-');
        for (int i = 2; i < this.wLength_ - 1; ++i) {
            if (this.word_[i] != by) continue;
            int n = i;
            int n2 = this.searchItem(this.rootNode_, this.word_, 0, n);
            int n3 = this.getFlags(n2);
            if (!TLex.actualWord(n3) && !TLex.isaPrefix(n3)) {
                n2 = this.searchItem(this.rootNode_, this.word_, 0, ++n);
            }
            if (TLex.actualWord(n3) || TLex.isaPrefix(n3)) {
                this.box_.put(this.word_, 0, n);
                this.box_.put(by);
                this.approxSearch(i + 1, this.rootNode_);
                continue;
            }
            int n4 = this.searchItem(this.rootNode_, this.word_, n, this.wLength_);
            int n5 = this.getFlags(n4);
            if (!TLex.actualWord(n5)) continue;
            int n6 = this.wLength_;
            this.wLength_ = i;
            this.box_.setSuffix(this.decode(this.word_, i, n6 - i));
            this.approxSearch(0, this.rootNode_);
            this.box_.setSuffix(null);
            this.wLength_ = n6;
        }
    }

    int tryAlternative(int n, int n2, TLexRules.MRule mRule, int n3) {
        int n4 = n;
        int n5 = mRule.itemSize(n3);
        for (int i = 0; i < n5; ++i) {
            byte by = mRule.itemCode(n3, i);
            if (by == -1) {
                if (n2 <= 0) continue;
                return -1;
            }
            if (by == -2) {
                if (TLex.actualWord(this.getFlags(n4))) continue;
                return -1;
            }
            if (n4 <= 0) {
                return -1;
            }
            n4 = this.step(n4, by);
        }
        return n4;
    }

    void putAlternative(TLexRules.MRule mRule, int n) {
        int n2 = mRule.itemSize(n);
        for (int i = 0; i < n2; ++i) {
            byte by = mRule.itemCode(n, i);
            if (by == -1 || by == -2) continue;
            this.box_.put(by);
        }
        this.box_.putCost(mRule.itemCost(n));
    }

    void visit(Visitor visitor) {
        char[] cArray = new char[256];
        this.visit(visitor, cArray, 0, this.rootNode_);
    }

    private void visit(Visitor visitor, char[] cArray, int n, int n2) {
        int n3 = this.getFlags(n2);
        if (TLex.actualWord(n3)) {
            visitor.getWord(cArray, n, TLex.getWordType(n3), n2);
        }
        KEnum kEnum = this.newKEnum(n2);
        while (kEnum.next()) {
            cArray[n] = this.decode(kEnum.getCurrentChar());
            int n4 = kEnum.getCurrentNode();
            if (n4 > 0) {
                this.visit(visitor, cArray, n + 1, n4);
                continue;
            }
            if (n4 != 0) continue;
            visitor.getWord(cArray, n + 1, TLex.getWordType(this.getFlags(n4)), n4);
        }
    }

    void dump(final Writer writer) {
        this.visit(new Visitor(){

            public void getWord(char[] cArray, int n, int n2, int n3) {
                try {
                    for (int i = 0; i < n; ++i) {
                        char c = cArray[i];
                        if (n2 == 2 || i == 0 && n2 == 1) {
                            c = Character.toUpperCase(c);
                        }
                        writer.write(c);
                    }
                    writer.write(10);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.getMessage());
                }
            }
        });
    }

    public static interface Visitor {
        public void getWord(char[] var1, int var2, int var3, int var4);
    }

    static class Fragment {
        int start;
        int length;

        Fragment(int n, int n2) {
            this.start = n;
            this.length = n2;
        }
    }

    static interface KEnum {
        public boolean next();

        public int getCurrentNode();

        public byte getCurrentChar();
    }
}

