/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.engine.DictionaryManagerItem;
import azcheck.engine.SpellException;
import azcheck.engine.Suggestions;
import azcheck.ui.JSpellDialog;
import azcheck.ui.JSpellOptions;
import azcheck.ui.SpellControl;
import azcheck.ui.TextSource;
import azcheck.ui.ThinBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class JSpellComponent
extends JComponent
implements ActionListener,
ListSelectionListener,
DocumentListener {
    private File spellDir = null;
    public Properties prop = new Properties();
    String rcFileName = null;
    private JTextField status_;
    private JTextField faultyWord_;
    private JTextField inputWord_;
    private JList suggestionList_;
    private JViewport suggestionPort_;
    private JComboBox dictionaryBox_;
    private JButton[] buttons_;
    private JLabel copyrightLabel_;
    private SpellControl checker_;
    private int checkStatus_;
    private TextSource source_;
    private DictionaryManagerItem[] languages_;
    private String[] dictCodes_;
    private boolean autoDismiss;
    private boolean doneButtonClicked = false;
    private Vector actionListeners_ = new Vector();
    private static ResourceBundle resources = null;

    public JSpellComponent(TextSource textSource, String string) throws SpellException, IOException {
        this.source_ = textSource;
        this.checker_ = new SpellControl(string);
        this.createInterface();
    }

    public JSpellComponent(TextSource textSource, SpellControl spellControl) throws SpellException {
        this.source_ = textSource;
        this.checker_ = spellControl;
        this.createInterface();
    }

    public TextSource getSource() {
        return this.source_;
    }

    public void setSource(TextSource textSource) {
        this.source_ = textSource;
    }

    public SpellControl getChecker() {
        return this.checker_;
    }

    public int check() throws SpellException {
        this.status("");
        this.clearText(this.faultyWord_);
        this.clearText(this.inputWord_);
        this.suggestionList_.setListData(new String[0]);
        this.getButton("ignore").setEnabled(true);
        this.checkStatus_ = this.checker_.check(this.source_);
        switch (this.checkStatus_) {
            case 0: {
                this.done();
                this.enableReplace(false);
                this.enableLearning(false);
                this.getButton("ignore").setEnabled(false);
                this.status(JSpellComponent.lmsg("finished"));
                if (!this.isAutoDismiss()) break;
                this.close();
                break;
            }
            case 4: {
                this.status(JSpellComponent.lmsg("duplicate_word"), this.checker_.failingWord());
                this.enableReplace(true);
                this.enableLearning(false);
                break;
            }
            case 5: {
                this.showSuggestions("punctuation_problem", null);
                this.enableLearning(false);
                break;
            }
            case 3: {
                this.showSuggestions("word_should_be_capitalized", null);
                this.enableLearning(true);
                break;
            }
            case 2: {
                this.showSuggestions("unrecognized_word", null);
                this.enableLearning(true);
            }
        }
        this.inputWord_.requestFocus();
        return this.checkStatus_;
    }

    public void setSpelllDir() {
        String string = null;
        try {
            string = System.getProperty("HOME");
            if (string == null || string.length() == 0) {
                string = System.getProperty("user.home");
            }
            if (!new File(string).isDirectory()) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        String string2 = "spell";
        this.spellDir = new File(string + File.separatorChar + ".novell" + File.separatorChar + "groupwise" + File.separatorChar + string2);
        boolean bl = this.spellDir.isDirectory();
        if (!bl && !this.spellDir.mkdir()) {
            this.spellDir = new File(string);
        }
    }

    public void loadPrefs() {
        String string = "prefrences";
        if (this.spellDir == null) {
            this.setSpelllDir();
        }
        try {
            this.rcFileName = File.pathSeparatorChar == ';' ? this.spellDir.getAbsolutePath() + File.separatorChar + string + ".ini" : this.spellDir.getAbsolutePath() + File.separatorChar + string;
            if (!new File(this.rcFileName).isFile()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(this.rcFileName);
            this.prop.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            this.checker_.loadOptions(this.prop);
            return;
        }
        catch (Exception exception) {
            System.err.println(string + ": cannot load Preferences: " + exception.getMessage());
            return;
        }
    }

    public void savePrefs() {
        String string = "prefrences";
        if (this.spellDir == null) {
            this.setSpelllDir();
        }
        try {
            this.checker_.saveOptions(this.prop);
            FileOutputStream fileOutputStream = new FileOutputStream(this.rcFileName);
            this.prop.store(fileOutputStream, string);
            ((OutputStream)fileOutputStream).close();
            return;
        }
        catch (Exception exception) {
            System.err.println(string + ": cannot save Preferences: " + exception.getMessage());
            return;
        }
    }

    public void setPersonalDictionary(String string) {
        if (this.spellDir == null) {
            this.setSpelllDir();
        }
        this.checker_.setPersonalDictionaryPath(this.spellDir.getAbsolutePath() + File.separatorChar + string);
    }

    public void selectDictionary(String string) throws IOException, SpellException {
        this.checker_.selectDictionary(string);
        int n = this.languages_.length;
        while (--n >= 0) {
            if (!this.languages_[n].name.equals(string)) continue;
            this.dictionaryBox_.setSelectedIndex(n);
            break;
        }
    }

    public void selectDictionary() throws IOException, SpellException {
        String string = this.checker_.getPrefsLang_();
        if (string != null) {
            this.selectDictionary(string);
        } else {
            this.selectDictionary("en-US");
        }
    }

    public void done() {
        this.checker_.stop();
        this.checkStatus_ = 0;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners_.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners_.remove(actionListener);
    }

    private void fireSpellEvent(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 0, string);
        for (int i = 0; i < this.actionListeners_.size(); ++i) {
            ((ActionListener)this.actionListeners_.get(i)).actionPerformed(actionEvent);
        }
    }

    void status(String string) {
        this.status_.setText(string);
    }

    private void status(String string, String string2) {
        this.status_.setText(string + " : " + string2);
    }

    private void showSuggestions(String string, String string2) throws SpellException {
        this.status(JSpellComponent.lmsg(string));
        Suggestions suggestions = string2 == null ? this.checker_.getSuggestions() : this.checker_.getSuggestions(string2);
        this.suggestionList_.setListData(suggestions.toArray());
        this.suggestionPort_.setViewPosition(new Point(0, 0));
        this.clearText(this.faultyWord_);
        this.faultyWord_.setText(suggestions.getWord());
        this.clearText(this.inputWord_);
        this.inputWord_.setText(suggestions.getSuggestion(0));
        this.getRootPane().setDefaultButton(this.getButton("replace"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        String string = actionEvent.getActionCommand();
        try {
            if (string.equals("ignore")) {
                this.check();
            } else if (string.equals("ignore_all")) {
                this.checker_.ignoreAll(this.faultyWord_.getText());
                this.check();
            } else if (string.equals("replace")) {
                this.simpleReplace();
            } else if (string.equals("replace_all")) {
                this.checker_.replace(this.inputWord_.getText(), true);
                this.check();
            } else if (string.equals("learn")) {
                this.checker_.add(this.faultyWord_.getText());
                this.check();
            } else if (string.equals("ban")) {
                this.checker_.learnBannedWord(this.faultyWord_.getText(), "<personal>");
            } else if (string.equals("check")) {
                this.checkTypedWord();
            } else if (string.equals("done")) {
                this.setDoneButtonClicked(true);
                this.done();
                this.fireSpellEvent("spell_done");
            } else if (string.equals("options")) {
                this.options();
            } else if (string.equals("select_language")) {
                this.selectedDictionary();
            }
        }
        catch (SpellException spellException) {
            this.status("Error: " + spellException);
            spellException.printStackTrace();
        }
        catch (Exception exception) {
            this.status("Error: " + exception);
            exception.printStackTrace();
        }
    }

    public void close() {
        this.done();
        this.fireSpellEvent("spell_done");
    }

    public boolean isAutoDismiss() {
        return this.autoDismiss;
    }

    public void setAutoDismiss(boolean bl) {
        this.autoDismiss = bl;
    }

    public boolean isDoneButtonClicked() {
        return this.doneButtonClicked;
    }

    public void setDoneButtonClicked(boolean bl) {
        this.doneButtonClicked = bl;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.inputWord_.setText((String)this.suggestionList_.getSelectedValue());
        this.enableReplace(true);
        this.enableLearning(false);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableReplace(true);
        this.enableLearning(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableReplace(true);
        this.enableLearning(true);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableReplace(true);
        this.enableLearning(true);
    }

    private void enableReplace(boolean bl) {
        this.getButton("replace").setEnabled(bl);
        this.getButton("replace_all").setEnabled(bl);
        JButton jButton = this.getButton("check");
        if (jButton != null) {
            jButton.setEnabled(bl);
        }
        if ((jButton = this.getButton("ban")) != null) {
            jButton.setEnabled(bl && this.checkStatus_ == 2);
        }
    }

    private void enableLearning(boolean bl) {
        this.getButton("ignore_all").setEnabled(bl);
        this.getButton("learn").setEnabled(bl);
    }

    private void simpleReplace() {
        try {
            this.checker_.replace(this.inputWord_.getText(), false);
            if (this.source_ != null) {
                this.source_.highlight(-1, 0);
            }
            this.check();
        }
        catch (SpellException spellException) {
            this.status("Error: " + spellException.getMessage());
        }
    }

    private int checkTypedWord() {
        int n = 0;
        try {
            String string = this.inputWord_.getText().trim();
            n = this.checker_.checkWord(string);
            switch (n) {
                case 0: {
                    this.status(JSpellComponent.lmsg("finished"));
                    break;
                }
                case 3: {
                    this.showSuggestions("word_should_be_capitalized", string);
                    break;
                }
                case 2: {
                    this.showSuggestions("unrecognized_word", string);
                }
            }
        }
        catch (SpellException spellException) {
            this.status("Error: " + spellException.getMessage());
        }
        return n;
    }

    private void options() {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        JSpellOptions jSpellOptions = new JSpellOptions(jFrame, this.checker_);
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        JSpellDialog.place(jSpellOptions, window, 0, 2);
        jSpellOptions.setVisible(true);
    }

    private void selectedDictionary() {
        String string = this.dictCodes_[this.dictionaryBox_.getSelectedIndex()];
        try {
            this.checker_.selectDictionary(string);
            this.status("");
            String string2 = this.checker_.getCopyright();
            string2 = string2 != null && string2.length() > 0 ? JSpellComponent.lmsg("Dictionary_copyright_") + string2 : "";
            this.copyrightLabel_.setText(string2);
            if (this.source_ != null) {
                this.source_.highlight(-1, 0);
            }
            this.fireSpellEvent("spell_language");
            if (this.checkStatus_ != 0) {
                this.check();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error for dictionary " + JSpellComponent.lmsg(string) + ": " + exception);
            exception.printStackTrace();
            return;
        }
    }

    private JButton getButton(String string) {
        int n = this.buttons_.length;
        while (--n >= 0) {
            if (this.buttons_[n] == null || !string.equals(this.buttons_[n].getActionCommand())) continue;
            return this.buttons_[n];
        }
        return null;
    }

    private void createInterface() {
        Object object;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 8, 0, 8);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.status_ = new JTextField(20);
        this.status_.setBorder(null);
        this.status_.setEditable(false);
        this.status_.setForeground(new Color(0xD00000));
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.status_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.faultyWord_ = new JTextField(20);
        ThinBorder thinBorder = new ThinBorder(this.status_.getBackground(), false);
        this.faultyWord_.setEditable(false);
        this.faultyWord_.setBackground(this.status_.getBackground());
        this.faultyWord_.setBorder(thinBorder);
        this.faultyWord_.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JSpellComponent.this.inputWord_.setText(JSpellComponent.this.faultyWord_.getText());
            }
        });
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.faultyWord_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JLabel jLabel = new JLabel(JSpellComponent.lmsg("Replace_by") + ":");
        gridBagConstraints.insets.bottom = 0;
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 4;
        this.inputWord_ = new JTextField(20);
        this.inputWord_.setBorder(BorderFactory.createLoweredBevelBorder());
        this.inputWord_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JSpellComponent.this.simpleReplace();
            }
        });
        this.inputWord_.getDocument().addDocumentListener(this);
        this.add((Component)this.inputWord_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JLabel jLabel2 = new JLabel(JSpellComponent.lmsg("Suggestions") + ":");
        gridBagConstraints.insets.bottom = 0;
        this.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        String[] stringArray = new String[10];
        for (int i = 0; i < 10; ++i) {
            stringArray[i] = "\ufffd";
        }
        this.suggestionList_ = new JList<String>(stringArray);
        this.suggestionList_.setBorder(BorderFactory.createLoweredBevelBorder());
        this.suggestionList_.addListSelectionListener(this);
        this.suggestionList_.setMinimumSize(this.suggestionList_.getPreferredSize());
        this.suggestionList_.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JSpellComponent.this.simpleReplace();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.suggestionList_);
        this.suggestionPort_ = jScrollPane.getViewport();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 2.0;
        this.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        JLabel jLabel3 = new JLabel(JSpellComponent.lmsg("select_dictionary"));
        this.add((Component)jLabel3, gridBagConstraints);
        try {
            this.languages_ = this.checker_.listLanguages();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error on dictionary lookup: " + iOException.getMessage());
        }
        int n = this.languages_.length;
        String[] stringArray2 = new String[n];
        this.dictCodes_ = new String[n];
        int n2 = 0;
        for (int i = 0; i < this.languages_.length; ++i) {
            object = this.languages_[i];
            this.dictCodes_[n2] = ((DictionaryManagerItem)object).name;
            stringArray2[n2] = ((DictionaryManagerItem)object).local;
            ++n2;
        }
        this.dictionaryBox_ = new JComboBox<String>(stringArray2);
        this.dictionaryBox_.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.bottom = 8;
        gridBagConstraints.insets.top = 8;
        this.add((Component)this.dictionaryBox_, gridBagConstraints);
        this.dictionaryBox_.setActionCommand("select_language");
        this.dictionaryBox_.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.copyrightLabel_ = new JLabel("");
        Font font = this.inputWord_.getFont();
        this.copyrightLabel_.setFont(font.deriveFont((float)font.getSize() - 2.0f));
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        object = new JPanel(gridBagLayout);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.left = 15;
        gridBagConstraints.insets.top = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridheight = 0;
        this.add((Component)object, gridBagConstraints);
        String[] stringArray3 = new String[]{"replace", "replace_all", "ignore", "ignore_all", "learn", null, "options", null, "done"};
        this.buttons_ = new JButton[stringArray3.length];
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.ipady = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 1;
        for (int i = 0; i < stringArray3.length; ++i) {
            JComponent jComponent;
            String string = stringArray3[i];
            if (string == null) {
                jComponent = new JLabel(" ");
                gridBagConstraints2.fill = 1;
                gridBagConstraints2.weighty = 1.0;
                ((Container)object).add((Component)jComponent, gridBagConstraints2);
                gridBagConstraints2.fill = 2;
                gridBagConstraints2.weighty = 0.0;
            } else {
                jComponent = new JButton(JSpellComponent.lmsg(string));
                ((AbstractButton)jComponent).setActionCommand(string);
                ((AbstractButton)jComponent).addActionListener(this);
                ((Container)object).add((Component)jComponent, gridBagConstraints2);
                this.buttons_[i] = jComponent;
            }
            gridBagConstraints2.insets.top = 3;
            ++gridBagConstraints2.gridy;
        }
    }

    private void clearText(JTextComponent jTextComponent) {
        try {
            Document document = jTextComponent.getDocument();
            document.remove(0, document.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static String lmsg(String string) {
        try {
            String string2 = resources.getString(string);
            return string2;
        }
        catch (Exception exception) {
            System.err.println("JSpellComponet: Could not find string for: " + string);
            exception.printStackTrace();
            return string.replace('_', ' ');
        }
    }

    static {
        try {
            resources = ResourceBundle.getBundle("azcheck.ui.JSpellComponent");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

