/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.engine.DictionaryManagerItem;
import azcheck.engine.EditableWord;
import azcheck.engine.SpellChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JSpellDictEdit
extends JDialog
implements ActionListener,
ListSelectionListener {
    SpellChecker checker_;
    DictionaryManagerItem[] languages_;
    private JComboBox languageBox_;
    private JList dictList_;
    private JList wordList_;
    private JViewport wordPort_;
    private EditableWord[] ewords_;
    private static ResourceBundle resources = null;

    JSpellDictEdit(JFrame jFrame, SpellChecker spellChecker) {
        super((Frame)jFrame, true);
        Object object;
        int n;
        this.setTitle(JSpellDictEdit.lmsg("Dictionary_management"));
        this.checker_ = spellChecker;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 8, 3, 8);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        JLabel jLabel = new JLabel(JSpellDictEdit.lmsg("dictionaries"));
        container.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        String[] stringArray = new String[]{" ", " ", " ", " ", " ", "mmmmmmmmmmmmmm"};
        this.dictList_ = new JList<String>(stringArray);
        this.dictList_.addListSelectionListener(this);
        this.dictList_.setBorder(BorderFactory.createLoweredBevelBorder());
        this.dictList_.setMinimumSize(this.dictList_.getPreferredSize());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        container.add((Component)this.dictList_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        String string = this.checker_.getSelectedLanguage();
        JLabel jLabel2 = new JLabel(JSpellDictEdit.lmsg("current_language"));
        container.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        try {
            this.languages_ = this.checker_.listLanguages();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error on dictionary lookup: " + iOException.getMessage());
        }
        String[] stringArray2 = new String[this.languages_.length];
        int n2 = -1;
        for (n = 0; n < this.languages_.length; ++n) {
            object = this.languages_[n];
            stringArray2[n] = ((DictionaryManagerItem)object).local;
            if (!((DictionaryManagerItem)object).name.equals(string)) continue;
            n2 = n;
        }
        this.languageBox_ = new JComboBox<String>(stringArray2);
        this.languageBox_.setEditable(false);
        this.languageBox_.setActionCommand("select_language");
        this.languageBox_.addActionListener(this);
        gridBagConstraints.fill = 2;
        container.add((Component)this.languageBox_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        n = gridBagConstraints.gridy;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        object = new JLabel(JSpellDictEdit.lmsg("words"));
        container.add((Component)object, gridBagConstraints);
        ++gridBagConstraints.gridy;
        String[] stringArray3 = new String[]{" ", " ", " ", " ", " ", " ", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmm"};
        this.wordList_ = new JList<String>(stringArray3);
        this.wordList_.addListSelectionListener(this);
        this.wordList_.setBorder(BorderFactory.createLoweredBevelBorder());
        this.wordList_.setMinimumSize(this.wordList_.getPreferredSize());
        JScrollPane jScrollPane = new JScrollPane(this.wordList_);
        this.wordPort_ = jScrollPane.getViewport();
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        container.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton(JSpellDictEdit.lmsg("remove_word"));
        jButton.setActionCommand("remove_word");
        jButton.addActionListener(this);
        container.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 16, 0));
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = Math.max(n, gridBagConstraints.gridy);
        container.add((Component)jPanel, gridBagConstraints);
        JButton jButton2 = new JButton(JSpellDictEdit.lmsg("OK"));
        jButton2.setActionCommand("ok");
        jButton2.addActionListener(this);
        jPanel.add(jButton2);
        this.getRootPane().setDefaultButton(jButton2);
        jButton2 = new JButton(JSpellDictEdit.lmsg("Cancel"));
        jButton2.setActionCommand("cancel");
        jButton2.addActionListener(this);
        jPanel.add(jButton2);
        this.pack();
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        this.setLanguage(n2);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.dictList_) {
            this.getWords();
        } else if (listSelectionEvent.getSource() == this.wordList_) {
            // empty if block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            int n;
            if (string.equals("ok")) {
                this.ok();
            } else if (string.equals("cancel")) {
                this.cancel();
            } else if (string.equals("select_language")) {
                this.setLanguage(this.languageBox_.getSelectedIndex());
            } else if (string.equals("remove_word") && (n = this.wordList_.getSelectedIndex()) >= 0) {
                EditableWord editableWord = this.ewords_[n];
                editableWord.type = -1;
                this.checker_.changeWord(editableWord);
                this.getWords();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void ok() {
        this.setVisible(false);
    }

    void cancel() {
        this.setVisible(false);
    }

    void setLanguage(int n) {
        this.languageBox_.setSelectedIndex(n);
        if (n >= 0) {
            try {
                this.checker_.setSelectedLanguage(this.languages_[n].name);
                String[] stringArray = this.checker_.listEditableDictionaries();
                this.dictList_.setListData(stringArray);
                this.getWords();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void getWords() {
        try {
            if (this.checker_.manageEditableDictionary((String)this.dictList_.getSelectedValue(), 0)) {
                this.ewords_ = this.checker_.getEditableWords();
                String[] stringArray = new String[this.ewords_.length];
                for (int i = 0; i < this.ewords_.length; ++i) {
                    stringArray[i] = this.ewords_[i].word + " " + JSpellDictEdit.lmsg("ewtype" + this.ewords_[i].type, this.ewords_[i].value);
                }
                this.wordList_.setListData(stringArray);
            } else {
                this.wordList_.setListData(new String[]{" "});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String lmsg(String string) {
        try {
            return resources.getString(string);
        }
        catch (Exception exception) {
            return string.replace('_', ' ');
        }
    }

    public static String lmsg(String string, Object object) {
        String string2 = null;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        return MessageFormat.format(string2, object);
    }

    static {
        try {
            resources = ResourceBundle.getBundle("azcheck.ui.JSpellDictEdit");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

