/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.engine.DictionaryManagerItem;
import azcheck.engine.SpellChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JSpellOptions
extends JDialog
implements ActionListener {
    SpellChecker checker_;
    DictionaryManagerItem[] languages_;
    JCheckBox ignoreCase_;
    JCheckBox ignoreMixedCase_;
    JCheckBox ignoreDigits_;
    JCheckBox ignoreDuplicates_;
    JCheckBox ignoreURL_;
    JCheckBox checkPunctuation_;
    JCheckBox autoReplace_;
    JCheckBox allowCompound_;
    JCheckBox allowPrefixes_;
    JCheckBox allowFileExtensions_;
    JComboBox suggestForce_;
    JComboBox language_;
    private static ResourceBundle resources = null;

    JSpellOptions(JFrame jFrame, SpellChecker spellChecker) {
        super((Frame)jFrame, true);
        this.setTitle(JSpellOptions.lmsg("option_dialog"));
        this.checker_ = spellChecker;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 8, 3, 8);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.ignoreCase_ = new JCheckBox(JSpellOptions.lmsg("Ignore_case"), spellChecker.getIgnoreCase());
        container.add((Component)this.ignoreCase_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.ignoreMixedCase_ = new JCheckBox(JSpellOptions.lmsg("Ignore_mixed_case_words"), spellChecker.getIgnoreMixedCase());
        container.add((Component)this.ignoreMixedCase_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.ignoreDigits_ = new JCheckBox(JSpellOptions.lmsg("Ignore_words_with_digits"), spellChecker.getIgnoreDigits());
        container.add((Component)this.ignoreDigits_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.ignoreDuplicates_ = new JCheckBox(JSpellOptions.lmsg("Ignore_duplicates"), spellChecker.getIgnoreDuplicates());
        container.add((Component)this.ignoreDuplicates_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.ignoreURL_ = new JCheckBox(JSpellOptions.lmsg("Ignore_URL"), spellChecker.getIgnoreURL());
        container.add((Component)this.ignoreURL_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        int n = gridBagConstraints.gridy;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        this.checkPunctuation_ = new JCheckBox(JSpellOptions.lmsg("Check_punctuation"), spellChecker.getCheckPunctuation());
        container.add((Component)this.checkPunctuation_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.autoReplace_ = new JCheckBox(JSpellOptions.lmsg("Enable_auto_replace"), spellChecker.getAutoReplace());
        container.add((Component)this.autoReplace_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.allowCompound_ = new JCheckBox(JSpellOptions.lmsg("Allow_compound_words"), spellChecker.getAllowCompound());
        container.add((Component)this.allowCompound_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.allowPrefixes_ = new JCheckBox(JSpellOptions.lmsg("Allow_general_prefixes"), spellChecker.getAllowPrefixes());
        container.add((Component)this.allowPrefixes_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.allowFileExtensions_ = new JCheckBox(JSpellOptions.lmsg("Allow_file_extensions"), spellChecker.getAllowFileExtensions());
        container.add((Component)this.allowFileExtensions_, gridBagConstraints);
        ++gridBagConstraints.gridy;
        n = Math.max(gridBagConstraints.gridy, n);
        JLabel jLabel = new JLabel(JSpellOptions.lmsg("suggestion_force"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        container.add((Component)jLabel, gridBagConstraints);
        this.suggestForce_ = new JComboBox<String>(new String[]{JSpellOptions.lmsg("Less_suggestions"), JSpellOptions.lmsg("Normal_suggestions"), JSpellOptions.lmsg("More_suggestions")});
        this.suggestForce_.setSelectedIndex(spellChecker.getSuggestionForce() - 2);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        container.add((Component)this.suggestForce_, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 16, 0));
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(15, 0, 8, 8);
        gridBagConstraints.anchor = 13;
        container.add((Component)jPanel, gridBagConstraints);
        JButton jButton = new JButton(JSpellOptions.lmsg("OK"));
        jButton.setActionCommand("ok");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        jButton = new JButton(JSpellOptions.lmsg("Cancel"));
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            this.ok();
        } else if (string.equals("cancel")) {
            this.cancel();
        }
    }

    void ok() {
        this.checker_.setIgnoreCase(this.ignoreCase_.isSelected());
        this.checker_.setIgnoreMixedCase(this.ignoreMixedCase_.isSelected());
        this.checker_.setIgnoreDigits(this.ignoreDigits_.isSelected());
        this.checker_.setIgnoreDuplicates(this.ignoreDuplicates_.isSelected());
        this.checker_.setIgnoreURL(this.ignoreURL_.isSelected());
        this.checker_.setCheckPunctuation(this.checkPunctuation_.isSelected());
        this.checker_.setAutoReplace(this.autoReplace_.isSelected());
        this.checker_.setAllowCompound(this.allowCompound_.isSelected());
        this.checker_.setAllowPrefixes(this.allowPrefixes_.isSelected());
        this.checker_.setAllowFileExtensions(this.allowFileExtensions_.isSelected());
        int n = this.suggestForce_.getSelectedIndex();
        this.checker_.setSuggestionForce(n + 2);
        this.setVisible(false);
    }

    void cancel() {
        this.setVisible(false);
    }

    private static String lmsg(String string) {
        try {
            return resources.getString(string);
        }
        catch (Exception exception) {
            return string.replace('_', ' ');
        }
    }

    static {
        try {
            resources = ResourceBundle.getBundle("azcheck.ui.JSpellOptions");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

