/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.engine.CharChecker;
import azcheck.engine.SpellException;
import azcheck.ui.JTextSource;
import azcheck.ui.SpellControl;
import azcheck.util.StringCharSeq;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public class JTextAutoSpellCheck
extends JTextSource
implements DocumentListener {
    long last = System.currentTimeMillis();
    SpellControl checker;
    String dictionary;
    Object hiliTag;
    DefaultHighlighter.DefaultHighlightPainter hiPainter = new SpellHiliter();
    Vector hilights = new Vector();
    private static final String PKEY = "=auto=spell=checker=";

    public JTextAutoSpellCheck(JTextComponent jTextComponent, SpellControl spellControl, String string, boolean bl) throws IOException, SpellException {
        super(jTextComponent);
        this.checker = spellControl;
        this.dictionary = string;
        jTextComponent.getDocument().addDocumentListener(this);
        jTextComponent.putClientProperty(PKEY, this);
        if (bl) {
            this.checkAll();
        }
    }

    public static void stopChecking(JTextComponent jTextComponent) {
        JTextAutoSpellCheck jTextAutoSpellCheck = (JTextAutoSpellCheck)jTextComponent.getClientProperty(PKEY);
        if (jTextAutoSpellCheck != null) {
            jTextComponent.getDocument().removeDocumentListener(jTextAutoSpellCheck);
            jTextAutoSpellCheck.eraseHighlights();
        }
    }

    public void checkAll() throws IOException, SpellException {
        AbstractDocument abstractDocument = (AbstractDocument)this.source_.getDocument();
        int n = abstractDocument.getLength();
        try {
            Element element;
            int n2 = 0;
            while (n2 <= n && (element = this.checkableElement(n2, true)) != null) {
                this.checkElement(element);
                n2 = element.getEndOffset() + 1;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void eraseHighlights() {
        int n = this.hilights.size();
        while (--n >= 0) {
            Highlighter.Highlight highlight = (Highlighter.Highlight)this.hilights.get(n);
            this.source_.getHighlighter().removeHighlight(highlight);
            this.hilights.remove(highlight);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.busy_) {
            return;
        }
        long l = System.currentTimeMillis();
        boolean bl = l - this.last > 500L;
        int n = documentEvent.getLength();
        boolean bl2 = false;
        boolean bl3 = false;
        if (n == 1) {
            DocumentEvent.EventType eventType = documentEvent.getType();
            Document document = documentEvent.getDocument();
            int n2 = documentEvent.getOffset();
            String string = "";
            try {
                string = document.getText(n2, 1);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            bl2 = string.equals(" ") || string.equals(",") || string.equals(".") || string.equals(";") || string.equals(":");
            boolean bl4 = bl3 = string.equals("\n") || string.equals("\r");
        }
        if (bl || bl2) {
            this.checkAround();
        }
        if (bl3) {
            try {
                this.checkAll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.last = l;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.busy_) {
            return;
        }
        this.checkAround();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.busy_) {
            return;
        }
    }

    void checkAround() {
        try {
            CharChecker charChecker = this.checker.getCharChecker();
            AbstractDocument abstractDocument = (AbstractDocument)this.source_.getDocument();
            int n = this.source_.getSelectionStart();
            int n2 = this.source_.getSelectionEnd();
            boolean bl = false;
            int n3 = abstractDocument.getLength();
            Element element = this.checkableElement(n, true);
            Element element2 = this.checkableElement(n, false);
            if (element != null) {
                this.checkElement(element);
            }
            if (element2 != null && element2 != element) {
                this.checkElement(element2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkElement(Element element) throws IOException, BadLocationException, SpellException {
        Object object;
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        int n3 = this.hilights.size();
        while (--n3 >= 0) {
            object = (Highlighter.Highlight)this.hilights.get(n3);
            if (object.getStartOffset() < n || object.getEndOffset() > n2) continue;
            this.source_.getHighlighter().removeHighlight(object);
            this.hilights.remove(object);
        }
        n3 = ((AbstractDocument)this.source_.getDocument()).getLength();
        if (n >= (n2 = Math.min(n2, n3))) {
            return;
        }
        object = this.source_.getText(n, n2 - n);
        String string = this.checker.getSelectedLanguage();
        try {
            int n4;
            if (this.dictionary != null) {
                this.checker.setSelectedLanguage(this.dictionary);
            }
            this.checker.setInput(new StringCharSeq((String)object));
            while ((n4 = this.checker.checkNext()) != 0) {
                if (n4 != 2 && n4 != 3) continue;
                int n5 = n + this.checker.getPosition();
                String string2 = this.checker.getWord();
                Highlighter highlighter = this.source_.getHighlighter();
                int n6 = n5 + string2.length();
                this.hilights.add(highlighter.addHighlight(n5, n6, this.hiPainter));
            }
        }
        finally {
            this.checker.setSelectedLanguage(string);
        }
    }

    static class SpellHiliter
    extends DefaultHighlighter.DefaultHighlightPainter {
        SpellHiliter() {
            super(Color.red);
        }

        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            graphics.setColor(this.getColor());
            try {
                Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                Rectangle rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                graphics.fillRect(rectangle.x, rectangle.y + rectangle.height - 2, rectangle.width, 2);
                return rectangle;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }
}

