/*
 * Decompiled with CFR 0.152.
 */
package com.appframework;

import com.appframework.AppAction;
import com.appframework.IActionList;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.componentrelated.ComponentRelatedAction;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActionList<T extends MVCView>
extends MVCController<T>
implements IActionList {
    private static Logger logger = Logger.getLogger(GWClient.class);
    protected Map<ActionKey, AppAction> actions = new HashMap<ActionKey, AppAction>();

    public ActionList(T view, MVCController parentController) {
        super(view, parentController);
    }

    protected ActionList(T view, MVCController parentController, Class<? extends ComponentRelatedAction> type) {
        super(view, parentController, type);
    }

    public Component getOwnerComponent() {
        return (Component)this.getMVCView();
    }

    @Override
    public void addAction(AppAction action) {
        AppAction oldAction = this.actions.put(action.getActionKey(), action);
        if (oldAction != null) {
            logger.warn((Object)("Action '" + oldAction + "' was replaced with action '" + action + "' in " + this));
        }
    }

    public Collection<AppAction> getActions() {
        return this.actions.values();
    }

    public Set<ActionKey> getKeys() {
        return this.actions.keySet();
    }

    @Override
    public AppAction getAction(ActionKey actionName) {
        AppAction action = this.actions.get((Object)actionName);
        if (action == null) {
            logger.warn((Object)("Action '" + (Object)((Object)actionName) + "' not found in " + this));
        }
        return action;
    }

    @Override
    public void performAction(ActionKey theName) {
        if (this.actions.get((Object)theName) == null) {
            throw new NullPointerException("Action List \"" + this.getClass().getName() + "\" does not contain the action \"" + (Object)((Object)theName) + '\"');
        }
        AppAction action = this.actions.get((Object)theName);
        if (action.isEnabled()) {
            action.performAction(null);
        }
    }

    public void removeAllActions() {
        try {
            for (AppAction action : this.getActions()) {
                action.disposeAction();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error removing all actions: " + e.getLocalizedMessage()));
        }
        try {
            this.actions.clear();
        }
        catch (Exception e) {
            logger.error((Object)("Error clearing action list: " + e.getLocalizedMessage()));
        }
        if (OS.isMacOS()) {
            GWClient.getGwClientActionList().getAction(ActionKey.OPTIONS).disposeAction();
        }
    }
}

