/*
 * Decompiled with CFR 0.152.
 */
package com.appframework;

import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.selection.SelectionManagersFactory;
import com.appframework.utils.OS;
import com.appframework.utils.OSXAdapter;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.ActionCancelFrame;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.frames.AbstractOpenViewFrame;
import com.novell.gw.jclient.application.frames.addressbook.FrameAddressBook;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendar;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.options.WindowBoundsListener;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Application
extends MVCController {
    private static Logger logger = Logger.getLogger(Application.class);
    protected static List<ApplicationFrame> appFrames = new Vector<ApplicationFrame>();
    private static GWMainAppFrame lastActiveMainFrame;

    public Application() {
        super(LevelManager.getInstance().getGlobalLevel(), (Level)null);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent ae) {
                if (ae.getID() == 205) {
                    Window window = ((WindowEvent)ae).getWindow();
                    if (window instanceof GWMainAppFrame) {
                        lastActiveMainFrame = (GWMainAppFrame)window;
                    }
                    if (OS.isMacOS() && window instanceof ApplicationFrame) {
                        boolean ebabledPrefs = true;
                        if (!EngineCommandManager.getUserGuid().equals(((ApplicationFrame)window).getUserGuid())) {
                            ebabledPrefs = GWCommandManager.getInstance(((ApplicationFrame)window).getUserGuid()).getCurrentDataStore().checkAccess(DataStoreAccessRequestType.EDIT_PREFS, ItemType.ANY, 0);
                        }
                        OSXAdapter.enablePrefs(ebabledPrefs);
                    }
                }
            }
        }, 64L);
    }

    public static int getGWMainAppFramesCount() {
        int count = 0;
        for (ApplicationFrame appFrame : appFrames) {
            if (!(appFrame instanceof GWMainAppFrame)) continue;
            ++count;
        }
        return count;
    }

    public static int getGWFramesCount(Class frameClass) {
        int count = 0;
        for (ApplicationFrame appFrame : appFrames) {
            try {
                if (!appFrame.getClass().equals(frameClass)) continue;
                ++count;
            }
            catch (Exception e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return count;
    }

    public static Point[] getGWFrameCoords(Class frameClass, ApplicationFrame frameToExclude) {
        ArrayList<Point> coordsList = new ArrayList<Point>();
        for (ApplicationFrame appFrame : appFrames) {
            try {
                if (!appFrame.getClass().equals(frameClass) || appFrame == frameToExclude) continue;
                coordsList.add(appFrame.getLocation());
            }
            catch (Exception e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return coordsList.toArray(new Point[coordsList.size()]);
    }

    static void addFrame(ApplicationFrame frame) {
        logger.debug((Object)("ADD FRAME TO APPLICATION FRAMES : [ " + frame.getClass().getName() + ' ' + frame.getName() + " ]"));
        appFrames.add(frame);
        if (lastActiveMainFrame == null && frame instanceof GWMainAppFrame) {
            lastActiveMainFrame = (GWMainAppFrame)frame;
        }
        frame.addComponentListener(new WindowBoundsListener(frame.getOptionFrameName()));
        logger.debug((Object)("APPLICATION FRAMES SIZE : [ " + appFrames.size() + " ]"));
    }

    public static void removeFrame(ApplicationFrame theFrame) {
        logger.debug((Object)("REMOVE FRAME FROM APPLICATIONS FRAME : [ " + theFrame.getClass().getName() + ' ' + theFrame.getName() + " ]"));
        appFrames.remove(theFrame);
    }

    public static void disposeFrame(AbstractItem theItem) {
        ApplicationFrame[] theFrames = Application.getFramesForItem(theItem);
        if (theFrames != null) {
            for (ApplicationFrame theFrame : theFrames) {
                theFrame.setVisible(false);
                Application.disposeFrame(theFrame);
            }
        }
    }

    private static ApplicationFrame[] getFramesForItem(AbstractItem theItem) {
        if (theItem == null) {
            return null;
        }
        ArrayList<ApplicationFrame> results = new ArrayList<ApplicationFrame>();
        for (ApplicationFrame appFrame : appFrames) {
            AbstractItem currentItem;
            ApplicationFrame frame;
            if (appFrame instanceof AbstractOpenViewFrame) {
                frame = (AbstractOpenViewFrame)appFrame;
                currentItem = ((AbstractOpenViewFrame)frame).getGwItem();
                if (!currentItem.getID().equals(theItem.getID())) continue;
                results.add(frame);
                continue;
            }
            if (!(appFrame instanceof FrameCompose) || !(currentItem = ((FrameCompose)(frame = (FrameCompose)appFrame)).getGwItem()).getID().equals(theItem.getID())) continue;
            results.add(frame);
        }
        return results.toArray(new ApplicationFrame[results.size()]);
    }

    public static void disposeFrame(ApplicationFrame frame) {
        if (frame != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                Application.doDisposeForFrame(frame);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new RunDisposeFrame(frame));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    logger.debug((Object)e, (Throwable)e);
                }
            }
        }
    }

    private static void doDisposeForFrame(ApplicationFrame theFrame) {
        GWToolBarPanel toolBarPanel;
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("not EventDispatchThread");
        }
        logger.debug((Object)("DO DISPOSE FRAME : [ " + theFrame.getClass().getName() + ' ' + theFrame.getName() + " ]"));
        logger.debug((Object)("APPLICATION FRAMES SIZE : [ " + appFrames.size() + " ]"));
        GlobalCommand command = new GlobalCommand(490, theFrame);
        theFrame.getController().processCommand(command);
        Application.removeFrame(theFrame);
        logger.debug((Object)("REMOVE CHILD CONTROLLER FOR FRAME : [ " + theFrame.getClass().getName() + ' ' + theFrame.getName() + " ]"));
        ApplicationFrameActionList afal = theFrame.getAppActionList();
        if (afal == null) {
            logger.warn((Object)"Frame AppActionList is null!");
        } else {
            Level level = afal.getLevel();
            SelectionManagersFactory.getInstance().releaseManager(level);
            LevelManager.release(level);
            afal.removeAllActions();
        }
        GWMenuBar menuBar = theFrame.getGWMenuBar();
        if (menuBar != null) {
            menuBar.disposeMenus();
        }
        if ((toolBarPanel = theFrame.getToolBarPanel()) != null) {
            toolBarPanel.disposeToolBars();
        }
        theFrame.beforeDispose();
        theFrame.release();
        theFrame.cleanListenerManager();
        theFrame.dispose();
        theFrame = null;
        logger.debug((Object)("APPLICATION FRAMES SIZE : [ " + appFrames.size() + " ]"));
        System.runFinalization();
        System.gc();
    }

    public static ApplicationFrame getLastFrame(Class frameClass) {
        int framesFound = 0;
        for (int i = appFrames.size() - 1; i >= 0; --i) {
            if (appFrames.get(i).getClass().equals(frameClass)) {
                ++framesFound;
            }
            if (framesFound != 2) continue;
            return appFrames.get(i);
        }
        return null;
    }

    public static FrameOpen getLastFrameOpen() {
        for (int i = appFrames.size() - 1; i >= 0; --i) {
            if (!(appFrames.get(i) instanceof FrameOpen)) continue;
            return (FrameOpen)appFrames.get(i);
        }
        return null;
    }

    public static FrameAddressBook getAddressBookFrame() {
        for (ApplicationFrame appFrame : appFrames) {
            if (!(appFrame instanceof FrameAddressBook)) continue;
            return (FrameAddressBook)appFrame;
        }
        return null;
    }

    public static GWMainAppFrame getGWMainAppFrame() {
        for (ApplicationFrame appFrame : appFrames) {
            if (!(appFrame instanceof GWMainAppFrame)) continue;
            return (GWMainAppFrame)appFrame;
        }
        return null;
    }

    public static Window getParentForModalDialogs() {
        GWMainAppFrame frame = Application.getLastActiveMainFrame();
        if (frame != null) {
            if (frame.isActive()) {
                return frame;
            }
            Window window = Application.getTopWindow(Application.getLastActiveMainFrame());
            return window != null ? window : frame;
        }
        return null;
    }

    static Window getTopWindow(Window window) {
        for (Window child : window.getOwnedWindows()) {
            if (child.isShowing() && (child.isActive() || child.isFocusOwner())) {
                return child;
            }
            Application.getTopWindow(child);
        }
        return null;
    }

    public static FrameCalendar getFrameCalendar() {
        for (ApplicationFrame appFrame : appFrames) {
            if (!(appFrame instanceof FrameCalendar)) continue;
            return (FrameCalendar)appFrame;
        }
        return null;
    }

    public static int getFramesCount() {
        return appFrames.size();
    }

    public static List<ApplicationFrame> getAllFrames() {
        return appFrames;
    }

    public static boolean closeAllFrames() {
        ArrayList<FrameCompose> frameComposeList = new ArrayList<FrameCompose>();
        ArrayList<GWMainAppFrame> mainAppFrameList = new ArrayList<GWMainAppFrame>();
        int size = appFrames.size();
        for (ApplicationFrame appFrame : appFrames.toArray(new ApplicationFrame[size])) {
            if (appFrame instanceof FrameCompose) {
                frameComposeList.add((FrameCompose)appFrame);
                continue;
            }
            if (appFrame instanceof GWMainAppFrame) {
                mainAppFrameList.add((GWMainAppFrame)appFrame);
                continue;
            }
            appFrame.setVisible(false);
            Application.disposeFrame(appFrame);
        }
        for (FrameCompose frameCompose : frameComposeList) {
            ActionCancelFrame actionCancelFrame = (ActionCancelFrame)((FrameComposeActionList)frameCompose.getController()).getAction(ActionKey.CANCEL_FRAME);
            if (actionCancelFrame.doPerformAction()) continue;
            return false;
        }
        for (GWMainAppFrame mainAppFrame : mainAppFrameList) {
            mainAppFrame.setVisible(false);
            Application.disposeFrame(mainAppFrame);
        }
        return true;
    }

    public static GWMainAppFrame getLastActiveMainFrame() {
        return lastActiveMainFrame;
    }

    public static ApplicationFrame getActiveFrame() {
        for (ApplicationFrame appFrame : appFrames) {
            if (!appFrame.isActive()) continue;
            return appFrame;
        }
        return null;
    }

    public static void disableFrames(List<AbstractItem> items) {
        for (AbstractItem item : items) {
            Application.disableFrames(item);
        }
    }

    public static void disableFrames(AbstractItem item) {
        ApplicationFrame[] frames = Application.getFramesForItem(item);
        if (frames != null) {
            for (ApplicationFrame frame : frames) {
                ((ApplicationFrameActionList)frame.getController()).closeFrame();
            }
        }
    }

    @Override
    public synchronized boolean isReleased() {
        return false;
    }

    private static class RunDisposeFrame
    implements Runnable {
        private ApplicationFrame applicationFrame;

        public RunDisposeFrame(ApplicationFrame theApplicationFrame) {
            this.applicationFrame = theApplicationFrame;
        }

        public void run() {
            Application.doDisposeForFrame(this.applicationFrame);
        }
    }
}

