/*
 * Decompiled with CFR 0.152.
 */
package com.appframework;

import com.appframework.Application;
import com.appframework.ApplicationFrameActionList;
import com.appframework.cache.IdentifiedObject;
import com.appframework.listener.ListenerManager;
import com.appframework.listener.ListenerManagerOwner;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.IDGenerator;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.ClickAction;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWStatusBar;
import com.novell.gw.jclient.application.GWStatusBarController;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendar;
import com.novell.gw.jclient.application.frames.compose.FrameComposeAppointment;
import com.novell.gw.jclient.application.frames.compose.FrameComposeMail;
import com.novell.gw.jclient.application.frames.compose.FrameComposePhone;
import com.novell.gw.jclient.application.frames.compose.FrameComposePostedItem;
import com.novell.gw.jclient.application.frames.compose.FrameComposeReminderNote;
import com.novell.gw.jclient.application.frames.compose.FrameComposeTask;
import com.novell.gw.jclient.application.frames.search.FrameItemSearch;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationFrame<T extends ApplicationFrameActionList, M>
extends JFrame
implements MVCView<T, M>,
IdentifiedObject,
ListenerManagerOwner {
    private static Logger logger = Logger.getLogger(ApplicationFrame.class);
    public static final int CASCADE_X = 20;
    public static final int CASCADE_Y = 20;
    public static final int SMART_CASCADE_X = 60;
    public static final int SMART_CASCADE_Y = 40;
    public static final int SMART_CASCADE_EDGE_SPACE_X = 20;
    public static final int SMART_CASCADE_EDGE_SPACE_Y = 20;
    public static final int SMART_CASCADE_MIN_X = 1;
    public static final int SMART_CASCADE_MIN_Y = 1;
    protected T appActionList;
    private String defaultTitle;
    private String id;
    protected JPanel centeredContentPanel;
    protected GWStatusBar panStatusPanel;
    protected String optionFrameName;
    protected GWToolBarPanel gwToolBarPanel;
    protected String toolBarName;
    protected String userGuid;
    public boolean exitApplicationOnClose = false;
    private ListenerManager listenerManager;

    public ApplicationFrame(String theTitle, String theOptionFrameName, String userGuid) {
        if (userGuid == null) {
            throw new IllegalArgumentException(" userGuid - null");
        }
        this.userGuid = userGuid;
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setDefaultCloseOperation(0);
        this.id = IDGenerator.getUIDAsString();
        this.optionFrameName = theOptionFrameName;
        this.buildUI(theTitle);
        Application.addFrame(this);
    }

    @Override
    public String getName() {
        return this.getTitle();
    }

    @Deprecated
    public void setAppActionList(T actionList) {
        this.setController(actionList);
    }

    @Deprecated
    public ApplicationFrameActionList getAppActionList() {
        return this.appActionList;
    }

    protected void beforeShow() {
    }

    protected void afterShow() {
    }

    public void beforeDispose() {
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void showToolbar() {
        boolean isSelected = ApplicationOptions.getInstance().getBoolean(this.toolBarName, true);
        this.gwToolBarPanel.setVisible(isSelected);
    }

    public String getUserGuid() {
        return this.userGuid;
    }

    public void setUserGuid(String userGuid) {
        this.userGuid = userGuid;
    }

    public String getDefaultTitle() {
        return this.defaultTitle;
    }

    public void setDefaultTitle(String defaultTitle) {
        this.defaultTitle = defaultTitle;
    }

    public void release() {
        this.removeWindowListener((WindowListener)this.appActionList);
        this.setJMenuBar(null);
        this.getContentPane().removeAll();
        this.getRootPane().removeAll();
        this.getLayeredPane().removeAll();
        this.removeAll();
        this.setFocusTraversalPolicy(null);
        this.appActionList = null;
        this.centeredContentPanel = null;
        this.panStatusPanel = null;
        this.gwToolBarPanel = null;
    }

    @Override
    public void setController(T controller) {
        this.appActionList = controller;
        this.panStatusPanel.setController(new GWStatusBarController(this.panStatusPanel, (MVCController)controller));
        this.addWindowListener((WindowListener)controller);
    }

    @Override
    public T getController() {
        return this.appActionList;
    }

    @Override
    public void setMVCModel(M theModel) {
    }

    @Override
    public M getMVCModel() {
        return null;
    }

    protected Dimension getFrameSize() {
        int h = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_HEIGHT", 590);
        int w = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_WIDTH", 700);
        return new Dimension(w, h);
    }

    public void showMe(int x, int y) {
        logger.debug((Object)"frame ***** ------------------- showMe(x, y) entered");
        Dimension preferredSize = this.getFrameSize();
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setPreferredSize(preferredSize);
        int w = preferredSize.width;
        int h = preferredSize.height;
        if (x < 0) {
            logger.debug((Object)"frame ***** x < 0");
            x = 0;
        }
        if (y < 0) {
            logger.debug((Object)"frame ***** y < 0");
            y = 0;
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (x + w > screenSize.width || y + h > screenSize.height) {
            Point newCascadeStartCoords = this.calculateNewCascadeStartCoords(screenSize.width - w, screenSize.height - h);
            x = newCascadeStartCoords.x;
            y = newCascadeStartCoords.y;
        }
        this.beforeShow();
        Rectangle bounds = new Rectangle(x, y, w, h);
        this.setBounds(bounds);
        this.setVisible(true);
        this.afterShow();
        logger.debug((Object)"frame ***** ------------------- showMe(x, y) exited");
    }

    protected Point calculateNewCascadeStartCoords(int maxWidth, int maxHeight) {
        logger.debug((Object)"frame ***** calculation for new cascade starting point entered");
        Point[] existingFramesCoords = Application.getGWFrameCoords(this.getClass(), this);
        int xCascade = 60;
        int yCascade = 40;
        while (xCascade > 1 & yCascade > 1) {
            logger.debug((Object)("frame ***** xCascade=" + xCascade + "; yCascade=" + yCascade));
            for (int xStart = 20; xStart < maxWidth; xStart += xCascade) {
                int y = 20;
                for (int x = xStart; y < maxHeight && x < maxWidth && x >= 20; y += yCascade, x -= xCascade) {
                    logger.debug((Object)("frame ***** checking space at: x=" + x + "; y=" + y));
                    boolean canCascadeHere = true;
                    for (int i = 0; i < existingFramesCoords.length; ++i) {
                        if (existingFramesCoords[i].x < x || existingFramesCoords[i].x >= x + xCascade || existingFramesCoords[i].y < y || existingFramesCoords[i].y >= y + yCascade) continue;
                        canCascadeHere = false;
                    }
                    if (!canCascadeHere) continue;
                    logger.debug((Object)("frame ***** OPENING FRAME AT: x=" + x + "; y=" + y));
                    return new Point(x, y);
                }
            }
            xCascade /= 2;
            yCascade /= 2;
        }
        return new Point(0, 0);
    }

    public void showMe() {
        int y;
        int x;
        logger.debug((Object)"frame ***** ------------------- showMe() entered");
        if (this instanceof GWMainAppFrame && Application.getGWMainAppFramesCount() >= 2 || this instanceof FrameCalendar && Application.getGWFramesCount(FrameCalendar.class) >= 2 || this instanceof FrameComposeAppointment && Application.getGWFramesCount(FrameComposeAppointment.class) >= 2 || this instanceof FrameComposeMail && Application.getGWFramesCount(FrameComposeMail.class) >= 2 || this instanceof FrameComposePhone && Application.getGWFramesCount(FrameComposePhone.class) >= 2 || this instanceof FrameComposePostedItem && Application.getGWFramesCount(FrameComposePostedItem.class) >= 2 || this instanceof FrameComposeReminderNote && Application.getGWFramesCount(FrameComposeReminderNote.class) >= 2 || this instanceof FrameComposeTask && Application.getGWFramesCount(FrameComposeTask.class) >= 2) {
            ApplicationFrame lastFrame = Application.getLastFrame(this.getClass());
            if (lastFrame != null) {
                x = lastFrame.getLocation().x + 20;
                y = lastFrame.getLocation().y + 20;
                logger.debug((Object)"frame ***** CASCADING");
            } else {
                x = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_X", 0);
                y = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_Y", 0);
                logger.debug((Object)"frame ***** BACK AT DEFAULT X, Y (NULL LASTFRAME)");
            }
        } else {
            x = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_X", 0);
            y = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_Y", 0);
            logger.debug((Object)"frame ***** BACK AT DEFAULT X, Y (NO FRAMES)");
        }
        this.showMe(x, y);
    }

    private void buildUI(String title) {
        this.setTitle(title);
        this.setDefaultTitle(title);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        boolean isMainFrame = this instanceof GWMainAppFrame;
        boolean needPadLock = EngineCommandManager.isSSLActive() && (isMainFrame || this instanceof FrameCalendar || this instanceof FrameItemSearch);
        this.panStatusPanel = new GWStatusBar(isMainFrame, needPadLock);
        contentPane.add((Component)this.panStatusPanel, "South");
        this.centeredContentPanel = new OrientablePanel();
        this.centeredContentPanel.setLayout(new BorderLayout());
        contentPane.add((Component)this.centeredContentPanel, "Center");
        this.setIconImage(ImageResources.GW_ICON.getImage());
    }

    public void setStatusText(String theText) {
        this.panStatusPanel.setMessage(theText);
    }

    public void startStatusAnimation(ImageIcon theImage, String theStatusMessage, ClickAction theClickAction) {
        this.panStatusPanel.setAnimation(theImage, theStatusMessage, theClickAction);
        this.panStatusPanel.setMessage(theStatusMessage);
    }

    public void stopStatusAnimation() {
        this.panStatusPanel.setAnimation(null, null, null);
        this.panStatusPanel.setMessage("");
    }

    public String getOptionFrameName() {
        return this.optionFrameName;
    }

    public void setGWMenuBar(JMenuBar menubar) {
        if (!(menubar instanceof GWMenuBar)) {
            throw new IllegalArgumentException("Unsupported MenuBar type");
        }
        super.setJMenuBar(menubar);
        menubar.setComponentOrientation(UIUtils.getComponentOrientation());
    }

    public GWMenuBar getGWMenuBar() {
        return (GWMenuBar)super.getJMenuBar();
    }

    public GWStatusBar getStatusBar() {
        return this.panStatusPanel;
    }

    public GWToolBarPanel getToolBarPanel() {
        return this.gwToolBarPanel;
    }

    public void setToolBarPanel(GWToolBarPanel theToolBarPanel, String theBorderLayoutConst) {
        this.gwToolBarPanel = theToolBarPanel;
        this.getContentPane().add((Component)this.gwToolBarPanel, theBorderLayoutConst);
    }

    public void updateOrientation(ComponentOrientation co) {
        this.getJMenuBar().setComponentOrientation(co);
        this.gwToolBarPanel.setComponentOrientation(co);
        this.validate();
    }

    @Override
    public ListenerManager getListenerManager() {
        if (this.listenerManager == null) {
            this.listenerManager = new ListenerManager();
        }
        return this.listenerManager;
    }

    public void cleanListenerManager() {
        if (this.listenerManager != null) {
            this.listenerManager.clean();
        }
    }
}

