/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonList
extends ArrayList<AbstractButton> {
    boolean selected = true;
    boolean enabled = true;

    public ButtonList() {
    }

    public ButtonList(boolean selected) {
        this.selected = selected;
    }

    public ButtonList(Collection<? extends AbstractButton> c) {
        super(c);
    }

    public ButtonList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public boolean addAll(Collection<? extends AbstractButton> c) {
        for (AbstractButton abstractButton : c) {
            if (abstractButton == null) continue;
            this.updateButtonState(abstractButton);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends AbstractButton> c) {
        for (AbstractButton abstractButton : c) {
            if (abstractButton == null) continue;
            this.updateButtonState(abstractButton);
        }
        return super.addAll(index, c);
    }

    @Override
    public boolean add(AbstractButton button) {
        if (button != null) {
            this.updateButtonState(button);
        }
        return super.add(button);
    }

    protected void updateButtonState(AbstractButton button) {
        this.updateButtonEnablity(button);
        this.updateButtonSelection(button);
    }

    protected void updateButtonEnablity(AbstractButton button) {
        button.setEnabled(this.isEnabled());
    }

    protected void updateButtonSelection(AbstractButton button) {
        if (button.getModel() instanceof JToggleButton.ToggleButtonModel) {
            button.setSelected(this.isSelected());
        }
    }

    @Override
    public void add(int index, AbstractButton element) {
        if (element != null) {
            this.updateButtonState(element);
        }
        super.add(index, element);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        for (AbstractButton button : this) {
            this.updateButtonSelection(button);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        for (AbstractButton button : this) {
            this.updateButtonEnablity(button);
        }
    }
}

