/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.BrowserType;
import com.appframework.components.htmleditor.GWMozillaBrowser;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.bl.om.PathManager;
import com.webrenderer.swing.BrowserFactory;
import com.webrenderer.swing.IBrowserCanvas;
import com.webrenderer.swing.IMozillaBrowserCanvas;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GWBrowserFactory {
    private static Logger logger = Logger.getLogger(GWBrowserFactory.class);
    private static List<GWMozillaBrowser> createdBrowsers = new ArrayList<GWMozillaBrowser>();

    public static GWMozillaBrowser getBrowser(MVCController controller, BrowserType browserType) {
        GWMozillaBrowser browser = GWBrowserFactory.createBrowser(controller, browserType);
        createdBrowsers.add(browser);
        logger.debug((Object)("new browser created: " + browser));
        logger.debug((Object)("number of created browsers: " + createdBrowsers.size()));
        return browser;
    }

    public static void releaseBrowser(GWMozillaBrowser browser) {
        logger.debug((Object)("releasing browser: " + browser));
        createdBrowsers.remove(browser);
        GWBrowserFactory.destroyBrowser(browser);
        logger.debug((Object)("number of created browsers: " + createdBrowsers.size()));
    }

    private static GWMozillaBrowser createBrowser(MVCController controller, BrowserType browserType) {
        logger.debug((Object)"Creating new browser");
        IMozillaBrowserCanvas result = GWBrowserFactory.createNativeBrowser();
        GWMozillaBrowser gwMozillaBrowser = new GWMozillaBrowser(result, controller, browserType);
        return gwMozillaBrowser;
    }

    private static void destroyBrowser(GWMozillaBrowser browser) {
        logger.debug((Object)"Destroying browser");
        browser.release();
        MVCController controller = browser.getController();
        if (!controller.isReleased()) {
            Level level = browser.getController().getLevel();
            logger.debug((Object)("releasing controller at level " + level));
            LevelManager.release(level);
        }
        BrowserFactory.destroyBrowser((IBrowserCanvas)browser.getBrowser());
    }

    private static IMozillaBrowserCanvas createNativeBrowser() {
        IMozillaBrowserCanvas nativeBrowser = BrowserFactory.spawnMozilla();
        nativeBrowser.enableDefaultContextMenu(false);
        nativeBrowser.disableCache();
        nativeBrowser.setJavascriptEnabled(false);
        nativeBrowser.setPrefProperty("print.print_headerright", "");
        nativeBrowser.setPrefProperty("print.print_headerleft", "");
        nativeBrowser.setPrefProperty("print.print_headercenter", "");
        nativeBrowser.setPrefProperty("print.print_footerright", "");
        nativeBrowser.setPrefProperty("print.print_footerleft", "");
        nativeBrowser.setPrefProperty("print.print_footercenter", "");
        return nativeBrowser;
    }

    public static void destroySpawnedBrowsers() {
        if (createdBrowsers.isEmpty()) {
            logger.debug((Object)"all spawned browsers were correctly released");
            return;
        }
        logger.warn((Object)(createdBrowsers.size() + " browser(s) were NOT released as expected"));
        logger.debug((Object)"destroying browsers....");
        for (GWMozillaBrowser browser : createdBrowsers) {
            GWBrowserFactory.destroyBrowser(browser);
        }
        createdBrowsers.clear();
        logger.debug((Object)".....browsers destroyed");
    }

    public static String getWebrendererVersion() {
        return BrowserFactory.getWebrendererVersion();
    }

    static {
        BrowserFactory.setHomeDirectory((String)PathManager.getBaseOptionsPath());
        BrowserFactory.setLicenseData((String)"novlgwsw", (String)"D5BJS10ASI87S6053TT63M78");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Webrenderer Version: " + BrowserFactory.getWebrendererVersion()));
        }
    }
}

