/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.HTMLStyledDocument;
import com.appframework.components.htmleditor.HTMLStyledWriter;
import com.appframework.components.htmleditor.StyledHTMLFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.apache.log4j.Logger;

public class HTMLStyledEditorKit
extends HTMLEditorKit {
    private static Logger logger = Logger.getLogger(HTMLStyledEditorKit.class);
    private static StyleSheet defaultGwStyleSheet = null;
    private StyleSheet styleSheet = null;
    private static final String DEFAULT_CSS = "html_def.css";
    protected StyledHTMLFactory myFactory = new StyledHTMLFactory();
    boolean editMode = false;
    private static final String ATTRIBUTE_TRACKER_CLASS_NAME = "javax.swing.text.StyledEditorKit$AttributeTracker";

    public HTMLStyledEditorKit() {
        this(false);
    }

    public HTMLStyledEditorKit(boolean isEditMode) {
        this.editMode = isEditMode;
    }

    public Document createDefaultDocument() {
        StyleSheet documentStyles = new StyleSheet();
        documentStyles.addStyleSheet(this.getStyleSheet());
        HTMLStyledDocument doc = new HTMLStyledDocument(documentStyles, this.editMode);
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        return doc;
    }

    public StyleSheet getStyleSheet() {
        if (this.styleSheet == null) {
            if (defaultGwStyleSheet == null) {
                defaultGwStyleSheet = new StyleSheet();
                try {
                    InputStream is = HTMLStyledDocument.class.getResourceAsStream(DEFAULT_CSS);
                    if (is != null) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(is));
                        defaultGwStyleSheet.loadRules(r, null);
                        ((Reader)r).close();
                    }
                }
                catch (IOException e) {
                    logger.debug((Object)("Can not load default GW CSS: " + e.getMessage()), (Throwable)e);
                }
            }
            this.styleSheet = new StyleSheet();
            this.styleSheet.addStyleSheet(super.getStyleSheet());
            this.styleSheet.addStyleSheet(defaultGwStyleSheet);
        }
        if (this.styleSheet == null) {
            throw new IllegalStateException("failed to create Style Sheet");
        }
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        if (styleSheet == null) {
            throw new IllegalArgumentException("styleSheet is null");
        }
        this.styleSheet = styleSheet;
    }

    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        try {
            super.read(in, doc, pos);
            doc.putProperty("AdditionalComments", null);
        }
        catch (RuntimeException e) {
            logger.error((Object)e, (Throwable)e);
            doc.remove(0, doc.getLength());
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (ChangedCharSetException e) {
            if (e.getCharSetSpec().indexOf("UTF-16") >= 0) {
                ChangedCharSetException _e = new ChangedCharSetException("UTF-8", true);
                throw _e;
            }
            throw e;
        }
    }

    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        if (doc instanceof HTMLStyledDocument) {
            HTMLStyledWriter w = new HTMLStyledWriter(out, (HTMLDocument)doc, pos, len, defaultGwStyleSheet);
            w.write();
        } else {
            super.write(out, doc, pos, len);
        }
    }

    public void install(JEditorPane c) {
        super.install(c);
        CaretListener[] caretListeners = c.getCaretListeners();
        boolean removed = false;
        for (int i = 0; i < caretListeners.length; ++i) {
            CaretListener caretListener = caretListeners[i];
            if (!ATTRIBUTE_TRACKER_CLASS_NAME.equals(caretListener.getClass().getName())) continue;
            c.removeCaretListener(caretListener);
            removed = true;
        }
        if (removed) {
            c.addCaretListener(new AttributeTracker());
        } else {
            logger.error((Object)"javax.swing.text.StyledEditorKit$AttributeTracker location(inplementation) changed");
        }
        removed = false;
        PropertyChangeListener[] propertyChangeListeners = c.getPropertyChangeListeners();
        for (int i = 0; i < propertyChangeListeners.length; ++i) {
            PropertyChangeListener propertyChangeListener = propertyChangeListeners[i];
            if (!ATTRIBUTE_TRACKER_CLASS_NAME.equals(propertyChangeListener.getClass().getName())) continue;
            c.removePropertyChangeListener(propertyChangeListener);
            removed = true;
        }
        if (removed) {
            c.addPropertyChangeListener(new AttributeTracker());
        } else {
            logger.error((Object)"javax.swing.text.StyledEditorKit$AttributeTracker location(inplementation) changed");
        }
    }

    public void deinstall(JEditorPane c) {
        super.deinstall(c);
    }

    public ViewFactory getViewFactory() {
        return this.myFactory;
    }

    public Action[] getActions() {
        if (!this.editMode) {
            Action[] actions = super.getActions();
            ArrayList<Action> result = new ArrayList<Action>();
            for (int i = 0; i < actions.length; ++i) {
                Action action = actions[i];
                Object actionName = action.getValue("Name");
                if ("caret-up".equals(actionName) || "caret-down".equals(actionName)) continue;
                result.add(action);
            }
            return result.toArray(new Action[result.size()]);
        }
        return super.getActions();
    }

    protected void createInputAttributes(Element element, MutableAttributeSet set) {
        if (element.getDocument().getLength() == 0) {
            String fontFamily = StyleConstants.getFontFamily(set);
            int fontSize = StyleConstants.getFontSize(set);
            boolean bold = StyleConstants.isBold(set);
            boolean italic = StyleConstants.isItalic(set);
            boolean underline = StyleConstants.isUnderline(set);
            super.createInputAttributes(element, set);
            StyleConstants.setFontFamily(set, fontFamily);
            StyleConstants.setFontSize(set, fontSize);
            StyleConstants.setBold(set, bold);
            StyleConstants.setItalic(set, italic);
            StyleConstants.setUnderline(set, underline);
        } else {
            super.createInputAttributes(element, set);
        }
    }

    public MutableAttributeSet getInputAttributes() {
        MutableAttributeSet inputAttributes = super.getInputAttributes();
        if (inputAttributes.getAttribute(StyleConstants.FontFamily) == null) {
            String fontName = HTMLConstants.getDefaultFontName(1, this.editMode);
            int fontSize = HTMLConstants.getDefaultFontSize(1, this.editMode);
            StyleConstants.setFontFamily(inputAttributes, fontName);
            StyleConstants.setFontSize(inputAttributes, fontSize);
        }
        return inputAttributes;
    }

    class AttributeTracker
    implements CaretListener,
    PropertyChangeListener,
    Serializable {
        private Element currentParagraph;
        private Element currentRun;

        AttributeTracker() {
        }

        void updateInputAttributes(int dot, int mark, JTextComponent c, boolean caretUpdate) {
            Element run;
            Document aDoc = c.getDocument();
            if (!(aDoc instanceof StyledDocument)) {
                return;
            }
            int start = Math.min(dot, mark);
            StyledDocument doc = (StyledDocument)aDoc;
            this.currentParagraph = doc.getParagraphElement(start);
            if (this.currentParagraph.getStartOffset() == start || dot != mark) {
                if (caretUpdate && start == doc.getLength() && start > 0 && (this.currentRun == null || this.currentRun.getStartOffset() != this.currentRun.getEndOffset())) {
                    --start;
                }
                run = doc.getCharacterElement(start);
            } else {
                run = doc.getCharacterElement(Math.max(start - 1, 0));
            }
            if (run != this.currentRun) {
                this.currentRun = run;
                HTMLStyledEditorKit.this.createInputAttributes(this.currentRun, HTMLStyledEditorKit.this.getInputAttributes());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue = evt.getNewValue();
            Object source = evt.getSource();
            if (source instanceof JTextComponent && newValue instanceof Document) {
                this.updateInputAttributes(0, 0, (JTextComponent)source, false);
            }
        }

        public void caretUpdate(CaretEvent e) {
            this.updateInputAttributes(e.getDot(), e.getMark(), (JTextComponent)e.getSource(), true);
        }
    }
}

